package ash.reverse.uml;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.io.PrintStream;
import java.awt.Font;
import ash.reverse.parser.Visibility;
import ash.reverse.struct.ObjectVisitor;
import ash.reverse.struct.ClassVisitor;
import ash.reverse.struct.ObjectRecord;
import ash.reverse.struct.GroupRecord;
import ash.reverse.struct.FileRecord;
import ash.reverse.struct.ClassRecord;
import ash.reverse.struct.MethodRecord;
import ash.reverse.struct.FieldRecord;

/**
 * ̃t@CL^AŒ`ĂNX𒊏oA
 * NX}𐶐B
 */
public class ClsGenerator extends UMLDiagram {
	/**
	 * NX}o͂B
	 * @param out NX}̏o͐
	 * @param fileList t@CǗ郊Xg
	 * @param font CAEgvZŎgptHg
	 * @param selectLevel ̑Ix<p>
	 * 						1: public  2: protected  3: package  4: private
	 * @param aflag ̌^Qƈˑ֌W̐
	 * @param bflag \bh{̂̌^Qƈˑ֌W̐
	 */
	public static void generate(PrintStream out, List<FileRecord> fileList,
								Font font, int selectLevel,
								boolean aflag, boolean bflag) {
		ClsGenerator gen = new ClsGenerator();
		// CAEgvZŎgptHgݒ肷B
		gen.setFont(font);			// UMLDiagram̃\bh

		// NX}̃p[^ݒ肷B
		gen.setParams(selectLevel, aflag, bflag);

		// NX}̃Ot\̏inodeList  relListj𐶐B
		gen.generateClassInfo(fileList);

		// t@C̃wb_iNXꗗƃpbP[W`jo͂B
		gen.generateHeader(out);

		// Ot\񂩂NX}𐶐B
		gen.generateDiagram(out);	// UMLDiagram̃\bh

	}
	/**
	 * NX}̃p[^ݒ肷B
	 * @param selectLevel ̑Ix<p>
	 * 						1: public  2: protected  3: package  4: private
	 * @param aflag ̌^Qƈˑ֌W̐
	 * @param bflag \bh{̂̌^Qƈˑ֌W̐
	 */
	void setParams(int selectLevel, boolean aflag, boolean bflag) {
		this.selectLevel = selectLevel;
		this.aflag = aflag;
		this.bflag = bflag;
	}

	private int selectLevel;		// ̑Ix
									// 1:public 2:protected 3:package 4:private
	private boolean aflag;			// ̌^Qƈˑ֌W̐
	private boolean bflag;			// \bh{̂̌^Qƈˑ֌W̐
	
	private Map<String,Integer> packageMap;	// pbP[W}bv
	private Map<String,ClassRecord> fqcnMap; // FQCN}bv
	private Map<Integer,ClassNode> idMap;	// ID}bv
	
	private FileRecord theFile;			// ݉͒̃t@CL^
	private ClassRecord theClassRec;	// ݉͒̃NX̋L^
	private ClassNode theClassNode;		// ݉͒̃NXm[h
	private int packageID;				// ݉͒̃pbP[WID

	/** ݉͒̌^̃C^tF[X */
	private List<ClassRecord> interfaceList = new ArrayList<ClassRecord>();

	/** ݉͒̌^QƂ^炻̈ˑ֌Wւ̃}bv */
	private Map<ClassRecord,Depends>
		theRefMap = new HashMap<ClassRecord,Depends>();

	/**
	 * NX}𐶐B
	 * @param out NX}̏o͐
	 * @param fileList t@CpbP[WL^ƂĊǗ郊Xg
	 */
	void generateClassInfo(List<FileRecord> fileList) {
		// NX}ɕKvȃ}bv쐬B
		packageMap = makePackageMap(fileList);
		fqcnMap = new ClassVisitor(fileList).fqcnMap();
		idMap = new HashMap<Integer,ClassNode>();
		nodeList = new ArrayList<ClassNode>();
		relList = new ArrayList<Relationship>();

		// p[Y\[XR[hNX}𐶐B
		for(FileRecord frec : fileList) genFile(frec);

		// NXԂ̍ċAI֘Aɑ΂ẴNXւ̎QƂݒ肷B
		for(Relationship rel : relList) {
			if(rel instanceof Assoc) {
				Assoc assoc = (Assoc)rel;
				assoc.setRecursiveNode(idMap);
			}
		}

		// ̃NX̊ԂɊ֘Aݒ肳Ăꍇ͈ˑ֌W폜B
		Set<String> linkSet = new HashSet<String>();
		for(Relationship rel : relList) {
			if(rel instanceof Assoc) linkSet.add(rel.linkID());
		}
		List<Relationship> duplLinks = new ArrayList<Relationship>();
		for(Relationship rel : relList) {
			if(rel instanceof Depends) {
				if(linkSet.contains(rel.linkID())) duplLinks.add(rel);
			}
		}
		relList.removeAll(duplLinks);

	}


	/**
	 * SẴpbP[W`EQƂ̏Ԃœo^ӔԍUB
	 * @param p[Yt@C̃Xg
	 * @return pbP[WƈӔԍ̃}bv
	 */
	Map<String,Integer> makePackageMap(List<FileRecord> fileList) {
		// packageŐ錾ꂽpbP[Wdefpkgsɓo^B
		Set<String> defpkgs = new TreeSet<String>();
		for(FileRecord frec : fileList) {
			String pname = frec.pkgname();
			if(!pname.isEmpty()) defpkgs.add(pname);
		}

		// importŎQƂĂpbP[Wrefpkgsɓo^B
		Set<String> refpkgs = new TreeSet<String>();
		for(FileRecord frec : fileList) {
			for(String pkg : frec.onDemandSet()) refpkgs.add(pkg);
			for(String pkg : frec.typePkgMap().values()) refpkgs.add(pkg);
		}

		// SẴpbP[W`EQƂ̏Ԃ pkgMapɓo^B
		// epbP[Wɂ͂Pn܂ӎʎq蓖ĂB
		Map<String,Integer> pkgMap = new LinkedHashMap<String,Integer>();
		int seq = 0;
		for(String pkg : defpkgs) pkgMap.put(pkg, ++seq);
		for(String pkg : refpkgs) {
			if(!pkgMap.containsKey(pkg)) pkgMap.put(pkg, ++seq);
		}
		return pkgMap;
	}

	/**
	 * t@C̃wb_iNXꗗƃpbP[W`jo͂B
	 */
	void generateHeader(PrintStream out) {
		// NX^C^tF[Ẍꗗ\B
		for(String key : fqcnMap.keySet()) {	   // fqcnMap
			ClassRecord crec = fqcnMap.get(key);
			out.println("# " + crec.id() + ". " + key);
		}
		out.println();

		// pbP[WID̒`so͂B
		for(Map.Entry<String,Integer> e : packageMap.entrySet()) {
			out.println("PACKAGE" + SEP + e.getValue() + SEP + e.getKey());
		}
		if(!packageMap.isEmpty()) out.println();
	}

	/**
	 * t@CL^NX}𐶐B
	 * @param frec t@CL^
	 */
	private void genFile(FileRecord frec) {
		theFile = frec;
		String pname = frec.pkgname();
		packageID = pname.isEmpty() ? 0 : packageMap.get(pname);

		// ̃t@CŒ`ĂeNX̃NX}𐶐B
		//frec.printTypes(frec.name() + ": ");
		for(ObjectRecord crec : frec.members()) genClass((ClassRecord)crec);
	}

	/**
	 * ЂƂ̃NX̃NX}𐶐B
	 * @param crec NXL^
	 */
	private void genClass(ClassRecord crec) {

		// NXݒ肷
		theClassRec = crec;
		theClassNode = new ClassNode(crec.name(), classFormat(crec), packageID);
		idMap.put(crec.id(), theClassNode);
		nodeList.add(theClassNode);
		theClassNode.setFontMetrics(fm);
		theRefMap.clear();			// ˑ֌Wɂ^B
		interfaceList.clear();		// C^tF[XXgB

		// X[pNX`Ăg֌WipjǉB
		if(crec.superClass() != null) {
			ClassRecord sc = findType(crec, crec.superClass());
			if(sc != null) relList.add(new Extends(crec.id(), sc.id(), null));
		}
		// C^tF[X`Ăg֌Wijo^B
		for(String iname : crec.interfaces()) {
			ClassRecord ic = findType(crec, iname);
			if(ic != null) {
				relList.add(new Extends(crec.id(), ic.id(), null));
				interfaceList.add(ic);
			}
		}

		// 񋓌^̒ltB[hlƂēo^B
		if(selectLevel > 0) {
			for(String ev : crec.enumList()) {
				String line = ATTRIBUTE +SEP+ ev +SEP+ ENUM_TYPE + SEP + "null";
				theClassNode.addAttribute(ev, line, 0);
			}
		}

		// NX̃o[̋L^B
		for(ObjectRecord rec : crec.members()) {
			if(rec instanceof ClassRecord) {
				// NX̃NX𐶐LNXƂ̊֌Wo^B
				ClassRecord irec = (ClassRecord)rec;
				genClass(irec);
				relList.add(new InnerRel(irec.id(), crec.id(), null));
			} else {
				// tB[h܂̓\bh̏𐶐B
				if(rec instanceof FieldRecord) {
					genField((FieldRecord)rec);
				} else {
					genMethod((MethodRecord)rec);
				}
			}
		}
	}

	/**
	 * \bhL^烁\bh𐶐B
	 * @param mrec \bhL^
	 */
	private void genMethod(MethodRecord mrec) {
		String method = mrec.getSignature();
		if(method.indexOf('"') >= 0) return; // enum ̃IuWFNgr
		int i1 = method.indexOf('(');
		int i2 = method.lastIndexOf(')');
		if(i1 < 0 || i2 < 0) return;

		// ex. method = MD MD T NAME(T1 V1, T2 V2, ...)
		String methodDecl = method.substring(0, i1);
		// methodDecl = MD MD T NAME
		if(aflag) addRefFromAPI(mrec, mrec.type(), Stereotype.RETURN);

		// \bhݒ肷
		MethodNode mn = null;
		if(mrec.visibility().level() <= selectLevel) {
			mn = new MethodNode(mrec.name(), memberFormat(METHOD, mrec),
								findPackageID(mrec.type()));
			theClassNode.addMethod(mn);
		}
		String params = method.substring(i1+1, i2);
		// params = T1 V1, T2 V2, ...
		if(!params.isEmpty()) {
			String[] pairs = params.split(", ");
			for(String param : pairs) {
				String var = param;
				String type = "null";
				for(String token : param.split(" ")) {
					type = var;
					var = token;
				}
				if(mn != null) {
					// \bhp[^̏ݒ肷
					mn.addParam(var, PARAMETER + SEP + var + SEP + type,
								findPackageID(type));
				}
				if(aflag) addRefFromAPI(mrec, type, Stereotype.PARAM);
			}
		}
		if(bflag) parseBodyToken(mrec);	// \bh{̋Lqł̌^Q
	}

	// l̑dx\tB[ȟ^`: List<T>, Set<T>, ...
	static final String MULTIPLICITY = //".*List<(.+)>";
		"(List|ArrayList|LinkedList|Set|HashSet|TreeSet)<(\\w+)>";
	static final Pattern MULTI_PAT = Pattern.compile(MULTIPLICITY);
	/**
	 * tB[hL^瑮Ɗ֘A𐶐B
	 * ̃tB[ȟ^findType()\bhŌł^Ȃ΁A
	 * ֘A̒`Ɖ߂A֘Ao^B
	 * ^List<T>̌`̏ꍇ͑dxl̊֘AƂB
	 * @param field tB[hL^
	 */
	private void genField(FieldRecord field) {
		if(bflag) parseBodyToken(field);	// tB[hł̌^Q

		ClassRecord source = (ClassRecord)field.owner();
		String fieldDecl = field.signature();
		ClassRecord target = findType(field, field.type());
		if(target != null) {
			// tB[ȟ^NX}bvɂȂ΁A
			// dxOPTIONAL(0..1)̊֘AƂēo^B
			Assoc assoc = new Assoc(source.id(), target.id(), null);
			assoc.setTarget(OPTIONAL, true, field.name());
			relList.add(assoc);
			return;
		}
		Matcher m = MULTI_PAT.matcher(field.type());
		if(m.find()) {
			// tB[ȟ^ Link<T>̌`̏ꍇ
			target = findType(field, m.group(2));
			if(target != null) {
				// dxMULTIVALUED(*)̊֘AƂēo^B
				Assoc assoc = new Assoc(source.id(), target.id(), null);	
				assoc.setTarget(MULTIVALUED, true, field.name());
				relList.add(assoc);
				return;
			}
		}
		if(field.visibility().level() <= selectLevel) {
			theClassNode.addAttribute(field.name(),
									  memberFormat(ATTRIBUTE,field),
									  0);
		}
	}

	// ^p[^菜^̒`
	static final String TYPE_DECL = "(\\w+).*";
	static final Pattern TYPE_PAT = Pattern.compile(TYPE_DECL);

	private int findPackageID(String type) {
		Matcher m = TYPE_PAT.matcher(type);
		if(m.find()) {
			String pkg = theFile.getPackage(m.group(1));
			Integer id = packageMap.get(pkg);
			if(id != null) return id; 
		}
		return 0;
	}

	/**
	 * \bh̖߂l܂̓p[^̌^ɑ΂ˑ֌Wo^B
	 * @param mrec \bhL^
	 * @param tname ^
	 * @param tag QƎʂ^Oireturn/paramj
	 */
	private void addRefFromAPI(MethodRecord mrec, String tname, Stereotype tag) {
		String[] typeNames = tname.split("[<>,+]");
		for(String token : typeNames) {
			addDepends(mrec, token, tag);
		}
	}
	/**
	 * {̋Lq̃g[N͂A^QƂˑ֌Wo^B
	 * @param rec ͑Ώۂ̃IuWFNgitB[h\bhj̋L^
	 */
	private void parseBodyToken(ObjectRecord rec) {
		Stereotype tag = Stereotype.BODY;
		for(String token : rec.getTokens()) {
			addDepends(rec, token, tag);
			tag = Stereotype.value(token);
			if(tag != Stereotype.NEW) tag = Stereotype.BODY;
		}
	}
	/**
	 * ͑Ώۂ̃IuWFNgQƂĂ^ւ̈ˑ֌W
	 * o^B
	 * @param rec ͑Ώۂ̃IuWFNgitB[h\bhj̋L^
	 * @param token ^\g[N(hbgL@ŕ\ꂽO)
	 */
	private void addDepends(ObjectRecord rec, String token, Stereotype tag) {
		ClassRecord target = fqcnMap.get(token); // FQCN\Ľ^
		if(target != null) {
			addTarget(target, token, tag);
		} else {
			String[] items = token.split("\\.");
			for(String type : items) {
				target = findType(rec, type);
				if(target != null) addTarget(target, type, tag);
			}
		}
	}
	/**
	 * ˑ֌Wo^B
	 * @param target ˑ֌W̃^[QbgƂȂ^
	 * @param type ^
	 * @param tag ˑ֌W̎
	 */
	private void addTarget(ClassRecord target, String type, Stereotype tag) {
		assert trace(tag.label + " " + type);
		Depends dep = theRefMap.get(target);
		if (dep == null) {
			dep = new Depends(theClassRec.id(), target.id(), tag);
			relList.add(dep);
			theRefMap.put(target, dep);
		} else {
			dep.count(tag);
		}
	}

	/**
	 * O^肷B
	 * @param rec OQƂĂIuWFNg
	 * @param name O
	 * @return O^
	 */
	private ClassRecord findType(ObjectRecord orec, String name) {
		ClassRecord crec = fqcnMap.get(name);
		if(crec != null) return crec;		// FQCNŎQƂĂꍇ
		crec = orec.owner().findType(name);
		if(crec != null) return crec;		// ʃXR[vŒ`ꂽ^
		crec = findInterfaceType(name);
		if(crec != null) return crec;		// C^tF[XŒ`ꂽ^
		FileRecord frec = (FileRecord)orec.root();
		crec = fqcnMap.get(frec.fqcn(name));
		if(crec != null) return crec;		// import錾̂ꍇ
		crec = fqcnMap.get(frec.pkgname() + "." + name);
		if(crec != null) return crec;		// pbP[Wɂꍇ
		return crec;
	}

	/**
	 * w肵^ĂC^tF[XŐ錾Ă΂ԂB
	 * @param name ^
	 * @return C^tF[XŐ錾Ă^
	 */
	private ClassRecord findInterfaceType(String name) {
		for(ClassRecord ifrec : interfaceList) {
			ClassRecord crec = ifrec.findType(name);
			if(crec != null) return crec;
		}
		return null;
	}

	/**
	 * w肵NXo͂B
	 * @param crec NX
	 */
	String classFormat(ClassRecord crec) {
		String tag = crec.type().toUpperCase();
		if(crec.isAbstract()) tag = "@" + tag;
		return tag + SEP + crec.id() + SEP + crec.name() + SEP
			+ crec.visibility();
	}
	
	/**
	 * w肵NXo[(܂̓\bh)o͂B
	 * @param tag o[ʂ^OiATTRIB/METHODj
	 */
	String memberFormat(String tag, ObjectRecord rec) {
		if(rec.isAbstract()) tag = "@" + tag;
		return tag + SEP + rec.name() + SEP + rec.type() + SEP
			+ rec.visibility();
	}

	boolean trace(Object msg) {
		System.err.println(msg);
		return true;
	}
}
