# umed.mk

PROJECT	= umed
VIEWER	= tview -G$(PROJECT)
CDESRC	= src/**/*.java
APPFQCN	= pbl2011.gui.ClassEditorFrame
APP		= umed
APPVER	= 0.8
APPNAME	= $(APP)-$(APPVER)

SP		= "$(path.separator)"
JAVAC	= javac -d build -cp $HOME/ashwork.jar
JAVA	= java -cp build$(SP)$HOME/ashwork.jar

#==== Development
edit:							# \[XR[h̕ҏW
	$VIEWER	$CDESRC

sig:							# VOj`̐
	sig -rsgAav $CDESRC > $(APP).sig
	$VIEWER $(APP).sig

memo:							# ̍쐬
	echo `date` Memo >> memo.txt
	$VIEWER -g5000 memo.txt

run: _compile					# RpCƎs
	$JAVA $APPFQCN

tracerun: _compile				# g[XoĎs
	$JAVA -ea $APPFQCN

testrun: _compile				# g[XoĎs
	$JAVA -ea $APPFQCN >% testrun.out
	$VIEWER	testrun.out

redmine:						# Redmine PBL2011
	web http://akihost.aiit.ac.jp/redmine/

#==== Application building
APPDIR	= $(APPNAME)
CONTENTS= $(APP).jar src ashsrc conf img data
WINCMD	= 'java -cp $(APP).jar;lib/ashwork.jar $(APPFQCN)'
MACCMD	= 'java -cp $(APP).jar:lib/ashwork.jar $(APPFQCN)'

apprelease: appbuild			# [XpZIPt@C̐
	zip -z $APPDIR

appbuild: $(APP).jar $APPDIR	# [XpfBNg̍쐬
	echo $WINCMD > $APPDIR/$(APP).bat
	echo $MACCMD > $APPDIR/$(APP).sh
	cp -p -e .svn $CONTENTS $APPDIR
	cp -fp $HOME/ashwork.jar $APPDIR/lib/ashwork.jar

$(APP).jar: _compile			# Jart@C
	echo Main-Class: $(APPFQCN) > _app.mf
	jar -cmf _app.mf $(APP).jar -C build .

$APPDIR:	; mkdir $APPDIR

#==== House keeping
_compile: build $CDESRC
	make compile

compile:						# RpC
	@addspath . src
	@rm -fr build/*
	@set! SRCS `ls -M $CDESRC`
	@echo cmpiling $CDESRC ...
	@$JAVAC $SRCS
	@cp -p -e .svn img conf build
	@touch _compile
	@echo compile DONE!

build:
	@mkdir build

clean:							# svt@C̍폜
	rm -f **/*~ _compile _app.mf testrun.out $(APP).sig
	rm -fr build output

cleanall: clean					# SĂ̕svt@C̍폜
	rm -fr $(APP).jar $APPDIR $APPDIR.zip

# EOF
