/* cdedit2 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef CD_ARC_H
#define CD_ARC_H

#include <stdio.h>
#include <gtk/gtk.h>

#include "cd_define.h"

#define CD_ARC_ITEM_MAX 50

typedef struct _ArcTerm ArcTerm;
typedef struct _ArcItem ArcItem;
typedef struct _Arc Arc;

struct _ArcTerm
{
  GdkPoint point;
  double theta;
  CdNodeFace face;
  int node_id;
  CdToolType type;
  MultType mult;
  GdkRectangle mult_rect;
};  

struct _ArcItem
{
  int id;
  char name[64];
  GdkRectangle name_rect;

  ArcTerm start;
  ArcTerm end;

  gboolean select;
};

struct _Arc
{
  int seq;
  int count;
  int selecting;
  int selected;
  int start;

  ArcItem item[CD_ARC_ITEM_MAX];
};

void cd_arc_item_init(int i);
void cd_arc_item_new_start(int x, int y,
			   int start_node_index, CdToolType type);
void cd_arc_item_new_end(int x, int y,
			 int end_node_index, CdToolType type);
void cd_arc_item_copy(int dst, int src);
void cd_arc_item_term_copy(ArcTerm *dst, ArcTerm *src);
void cd_arc_item_escape(int i);

void cd_arc_item_calc_name_rect(int i);
void cd_arc_item_calc_mult_rect(int i);

gboolean cd_arc_item_delete();
gboolean cd_arc_item_is_exist();

void cd_arc_item_draw_last(GdkPixmap *pixmap, GdkGC *gc);
void cd_arc_item_draw(GdkPixmap *pixmap, GdkGC *gc, int i);
void cd_arc_item_draw2(GdkPixmap *pixmap, GdkGC *gc, ArcItem *a_ptr);
void cd_arc_item_draw_selecting(GdkPixmap *pixmap, GdkGC *gc);
void cd_arc_item_draw_selected(GdkPixmap *pixmap, GdkGC *gc);

void cd_arc_item_draw_term(GdkPixmap *pixmap, GdkGC *gc, ArcTerm *term);
void cd_arc_item_draw_arrow(GdkPixmap *pixmap, GdkGC *gc,
			    int x, int y, double theta, CdNodeFace face);
void cd_arc_item_draw_triangle(GdkPixmap *pixmap, GdkGC *gc,
			       int x, int y, double theta, CdNodeFace face);
void cd_arc_item_draw_diamond(GdkPixmap *pixmap, GdkGC *gc,
			      int x, int y, double theta,
			      CdNodeFace face, gboolean flg);

void cd_arc_item_erase_deleted(GdkPixmap *pixmap, GdkGC *gc);

void cd_arc_item_start_move(int dx, int dy, int i);
void cd_arc_item_end_move(int dx, int dy, int i);

int cd_arc_item_selection(int x, int y);
void cd_arc_item_selection_clear_all();

void cd_arc_init();
void cd_arc_load(FILE *fp);
void cd_arc_save(FILE *fp);

void cd_arc_selecting_end();
void cd_arc_selection_clear();

#endif
