/* cdedit2 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef CD_DEFINE_H
#define CD_DEFINE_H

#define CDEDIT2                     "cdedit2"

#define CD_FT_BASE                  1.570796
#define CD_SF_BASE                  0.000000

#define CD_SELECTING_CLEAR          99999

#define CD_CANVAS_WIDTH_DEFAULT     1600
#define CD_CANVAS_HEIGHT_DEFAULT    1200
#define CD_CANVAS_WIDTH_MAX         3200
#define CD_CANVAS_HEIGHT_MAX        2400
#define CD_CANVAS_WIDTH_MIN         800
#define CD_CANVAS_HEIGHT_MIN        600
#define CD_CANVAS_WIDTH_STEP        80
#define CD_CANVAS_HEIGHT_STEP       60

#define CD_NODE_ITEM_MAX            50
#define CD_NODE_ITEM_NAME_DEFAULT   "class"
#define CD_NODE_ITEM_WIDTH_DEFAULT  50
#define CD_NODE_ITEM_HEIGHT_DEFAULT 35

typedef enum {
  select,
  umlclass,
  association,
  association2,
  aggregation,
  aggregation2,
  implements,
  generalization
} CdToolType;

#define CD_MULT_NONE     "None"
#define CD_MULT_ZERO     "0"
#define CD_MULT_ZERO_ONE "0..1"
#define CD_MULT_ONE      "1"
#define CD_MULT_ZERO_N   "0..n"
#define CD_MULT_ONE_N    "1..n"

#define CD_MULT_HEIGHT       5

#define CD_MULT_ZERO_LEN     5
#define CD_MULT_ZERO_ONE_LEN 20
#define CD_MULT_ONE_LEN      5
#define CD_MULT_ZERO_N_NEN   20
#define CD_MULT_ONE_N_EN     20

typedef enum {
  m_none,
  m0,
  m0_1,
  m1,
  m0_n,
  m1_n
} MultType;

typedef enum {
  face_none,
  face_first,
  face_second,
  face_third,
  face_fourth
} CdNodeFace;

typedef enum {
  START, END
} CdTermType;

#define CD_VIS_PRIVATE      '-'
#define CD_VIS_PROTECTED    '#'
#define CD_VIS_PUBLIC       '+'

#define CD_VIS_PRIVATE_DQ   "-"
#define CD_VIS_PROTECTED_DQ "#"
#define CD_VIS_PUBLIC_DQ    "+"

#define CD_CLASS_STRING     "Class"
#define CD_ATTR_STRING      "Attribute"
#define CD_OP_STRING        "Operation"

#define CD_NAME_LABEL       "Name"
#define CD_VIS_LABEL        "+/#/-"

#define CD_ADD_LABEL        "Add"
#define CD_APPLY_LABEL      "Apply"
#define CD_DELETE_LABEL     "Delete"
#define CD_OK_LABEL         "OK"
#define CD_RESET_LABEL      "Reset"
#define CD_MAX_LABEL        "Max"
#define CD_MIN_LABEL        "Min"
#define CD_CLOSE_LABEL      "Close"
#define CD_UP_LABEL         "Up"
#define CD_DOWN_LABEL       "Down"
#define CD_WIDTH_LABEL      "Width"
#define CD_HEIGHT_LABEL     "Height"

typedef enum {
  vis_none,
  vis_public,
  vis_protected,
  vis_private
} CdVisibility;

#define CD_MENU_BRANCH    "<Branch>"
#define CD_MENU_SEPARATOR "<Separator>"

#define CD_MENU_FILE            "/File"
#define CD_MENU_FILE_NEW        "/File/New"
#define CD_MENU_FILE_OPEN       "/File/Open"
#define CD_MENU_FILE_SAVE       "/File/Save"
#define CD_MENU_FILE_SAVE_AS    "/File/Save as"
#define CD_MENU_FILE_SEPARATOR  "/File/separator"
#define CD_MENU_FILE_EXPORT     "/File/Export"
#define CD_MENU_FILE_EXPORT_JPG "/File/Export/jpg"
#define CD_MENU_FILE_EXPORT_EPS "/File/Export/eps"
#define CD_MENU_FILE_QUIT       "/File/Quit"

#define CD_MENU_EDIT            "/Edit"
#define CD_MENU_EDIT_DELETE     "/Edit/Delete"

#define CD_MENU_TOOL            "/Tool"
#define CD_MENU_TOOL_SET        "/Tool/Set"
#define CD_MENU_TOOL_REFRESH    "/Tool/Refresh"

#define CD_ARC_DIALOG_LABEL_START "Start"
#define CD_ARC_DIALOG_LABEL_ENTRY "String"
#define CD_ARC_DIALOG_LABEL_END   "End"

#define CD_ARC_DIALOG_MESSAGE1 "generalization cannot edit\n"
#define CD_CONTROL_MESSAGE1    "no more arc\n"
#define CD_CONTROL_MESSAGE2    "already exit\n"
#define CD_NODE_MESSAGE1       "new class intersect some class\n"
#define CD_IO_MESSAGE1         "Cannot get filename\n"
#define CD_IO_MESSAGE2         "Cannot Open %s\n" 
#define CD_IO_MESSAGE3         "Invalid Header\n" 
#define CD_IO_MESSAGE4         "File Load Failed\n"
#define CD_IO_MESSAGE5         "Cannot Save Image\n"
#define CD_IO_MESSAGE6         "Cannot Save Image\n"
#define CD_IO_MESSAGE7         "Cannot get filename... Try after Saving file\n"

#define CD_IO_FILENAME          "newfile.cd2"

#define CD_IO_AU "AUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAUAU\n"
#define CD_IO_HD "AU!        This file is generated by cdedit2         !AU\n"

#endif
