/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>

#include "sq_io.h"
#include "sq_define.h"
#include "sq_commands.h"

extern IoDialog iod;

///////////////////////////// menu commands ///////////////////////////////////
/*
 * sq_file_new
 */
void sq_file_new()
{
  if(iod.sq_filename){
    g_free(iod.sq_filename);
    iod.sq_filename = NULL;
  }

  sq_util_counters_init();
  sq_util_init_all();
  
  sq_drawing_area_white();
  sq_drawing_area_update_all();
}

/*
 * sq_file_load
 */
void sq_file_load()
{
  sq_util_counters_init();
  sq_util_init_all();

  sq_io_dialog_open();

  if(!sq_io_load()) {
    g_print("File Load Failed\n");
    return;
  }

  sq_drawing_area_white();
  sq_util_draw_all();
  sq_drawing_area_update_all();
}

/*
 * sq_file_save
 */
void sq_file_save()
{
  if(!iod.sq_filename)
    sq_io_dialog_open();

  sq_io_save();
}

/*
 * sq_file_save_as
 */
void sq_file_save_as()
{
  sq_io_dialog_open();
  sq_io_save();
}

/*
 * sq_export_jpg
 */
void sq_export_jpg()
{
  if(!iod.sq_filename){
    g_print("Cannot get filename... Try after Saving file \n");
    return;
  }

  sq_io_export(JPG);
}

/*
 * sq_export_eps
 */
void sq_export_eps()
{
  if(!iod.sq_filename){
    g_print("Cannot get filename... Try after Saving file \n");
    return;
  }

  sq_io_export(EPS);
}

/*
 * sq_quit
 */
void sq_quit()
{
  gtk_exit(0);
}

/*
 * sq_edit_delete
 */
void sq_edit_delete()
{
  sq_edit_message_delete();
  sq_edit_recursive_delete();
  sq_edit_lifeline_delete();

  sq_drawing_area_update_all();
}

///////////////////////////// toolbar commands ////////////////////////////////
SqMode sq_mode;

/*
 * sq_mode_select
 */
void sq_mode_select()
{
  sq_mode = sq_mode_select_enum;
}

/*
 * sq_mode_lifeline
 */
void sq_mode_lifeline()
{
  sq_mode = sq_mode_lifeline_enum;
}

/*
 * sq_mdoe_message
 */
void sq_mode_message()
{
  sq_mode = sq_mode_message_enum;
}

/*
 * sq_mdoe_recusive
 */
void sq_mode_recursive()
{
  sq_mode = sq_mode_recursive_enum;
}
