/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "sq_define.h"
#include "sq_drawing_area.h"

GtkWidget *sq_drawing_area;
GdkPixmap *sq_pixmap;

extern SqMode sq_mode;
extern int sq_selected_lifeline;
extern int sq_selected_message;
extern int sq_selected_recursive;

extern GdkGC *sq_white_gc;

int lastX, lastY;
int dx, dy;

////////////////////////////// local functions ///////////////////////////////
/*
 * sq_configure
 */
static gint sq_configure(GtkWidget *widget, GdkEventConfigure *event)
{ 
  if (sq_pixmap)
    gdk_pixmap_unref(sq_pixmap);

  sq_pixmap = gdk_pixmap_new(widget->window,
			     widget->allocation.width,
			     widget->allocation.height,
			     -1);

  gdk_draw_rectangle (sq_pixmap,
		      widget->style->white_gc,
		      TRUE,
		      0, 0,
		      widget->allocation.width,
		      widget->allocation.height);

  return TRUE;
}

/*
 * sq_expose
 */
static gint sq_expose(GtkWidget *widget, GdkEventExpose *event)
{
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
		  sq_pixmap,
		  event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);

  return TRUE;
}

/*
 * sq_motion_notify
 */
gint sq_motion_notify(GtkWidget *widget, GdkEventMotion *event)
{
  GdkModifierType state;
  int x, y;

  if(sq_selected_lifeline == 9999 &&
     sq_selected_message == 9999 &&
     sq_selected_recursive == 9999 )
    return TRUE;

  x = event->x;
  y = event->y;

  if (event->is_hint)
    gdk_window_get_pointer(event->window, &x, &y, &state);
  else {
    x = event->x;
    y = event->y;
    state = event->state;
  }

  switch(sq_mode){
  case sq_mode_select_enum:
    if(sq_selected_lifeline != 9999)
      sq_edit_lifeline_move(x, y, sq_selected_lifeline);
    if(sq_selected_message != 9999)
      sq_edit_message_move(x, y, sq_selected_message);
    if(sq_selected_recursive != 9999)
      sq_edit_recursive_move(x, y, sq_selected_recursive);
    break;
  }

  sq_drawing_area_update_all();

  return TRUE;
}

/*
 * sq_button_press
 */
gint sq_button_press(GtkWidget *widget, GdkEventButton *event)
{
  int x, y;

  lastX = x = event->x;
  lastY = y = event->y;

  if(event->button == 1){
    switch(sq_mode){
    case sq_mode_select_enum:
      sq_edit_selection(x, y, event);
      break;
    case sq_mode_lifeline_enum:
      sq_edit_lifeline_add(x, y);
      break;
    case sq_mode_message_enum:
      sq_edit_message_add_start(x, y);
      break;
    case sq_mode_recursive_enum:
      sq_edit_recursive_add(x, y);
      break;
    }
  }

  sq_drawing_area_update_all();

  return TRUE;
}

/*
 * sq_button_release
 */
gint sq_button_release(GtkWidget *widget, GdkEventButton *event)
{
  int x, y;

  x = event->x;
  y = event->y;

  sq_selected_lifeline = 9999;
  sq_selected_message = 9999;
  sq_selected_recursive = 9999;
  
  if(event->button == 1){
    switch(sq_mode){
    case sq_mode_message_enum:
      sq_edit_message_add_end(x, y);
      break;
    }
  }

  //sq_edit_canvas_init();
  sq_util_draw_all();
  sq_drawing_area_update_all();

  return TRUE;
}

/*
 * sq_drawing_area_set_event
 */
void sq_drawing_area_set_events(GtkWidget *sq_drawing_area)
{
  gtk_signal_connect(GTK_OBJECT(sq_drawing_area), "configure_event",
		     (GtkSignalFunc)sq_configure, NULL);
  gtk_signal_connect(GTK_OBJECT(sq_drawing_area), "expose_event",
		     (GtkSignalFunc)sq_expose, NULL);
  gtk_signal_connect(GTK_OBJECT(sq_drawing_area), "motion_notify_event",
		     (GtkSignalFunc)sq_motion_notify, NULL);
  gtk_signal_connect(GTK_OBJECT(sq_drawing_area), "button_press_event",
		     (GtkSignalFunc)sq_button_press, NULL);
  gtk_signal_connect(GTK_OBJECT(sq_drawing_area), "button_release_event",
		     (GtkSignalFunc)sq_button_release, NULL);

  gtk_widget_set_events(sq_drawing_area, GDK_EXPOSURE_MASK
			| GDK_LEAVE_NOTIFY_MASK
			| GDK_BUTTON_PRESS_MASK
			| GDK_BUTTON_RELEASE_MASK
			| GDK_POINTER_MOTION_MASK
			| GDK_POINTER_MOTION_HINT_MASK
			| GDK_KEY_PRESS_MASK
			);
}  

///////////////////////////// global functions ////////////////////////////////
/*
 * sq_drawing_area_new
 */
void sq_drawing_area_new(GtkWidget *window, GtkWidget *vbox)
{
  sq_drawing_area = gtk_drawing_area_new();

  gtk_drawing_area_size(GTK_DRAWING_AREA(sq_drawing_area),
			SQ_PICTURE_WIDTH, SQ_PICTURE_HEIGHT);

  sq_drawing_area_set_events(sq_drawing_area);

  gtk_widget_show(sq_drawing_area);

  sq_scrolled_window_new(sq_drawing_area, vbox);
}

/*
 * sq_drawing_area_white
 */
void sq_drawing_area_white()
{
  gdk_draw_rectangle(sq_pixmap, sq_white_gc, TRUE,
		     0, 0, SQ_PICTURE_WIDTH, SQ_PICTURE_HEIGHT);
}  

/*
 * sq_drawing_area_update_all
 */
void sq_drawing_area_update_all()
{
  GdkRectangle update_rect;

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = SQ_PICTURE_WIDTH;
  update_rect.height = SQ_PICTURE_HEIGHT;

  gtk_widget_draw(sq_drawing_area, &update_rect);
}
