/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "sq_define.h"
#include "sq_lifeline.h"
#include "sq_message.h"
#include "sq_recursive.h"
#include "sq_edit.h"
#include "sq_util.h"

extern Lifeline sqLifeline[SQ_LIFELINE_MAX];
extern int sq_lifeline_count;
extern int sq_lifeline_seq;
extern int sq_selected_lifeline;

extern Message sqMessage[SQ_MESSAGE_MAX];
extern int sq_message_count;
extern int sq_message_seq;
extern int sq_message_start;
extern int sq_selected_message;

extern Recursive sqRecursive[SQ_RECURSIVE_MAX];
extern int sq_recursive_count;
extern int sq_recursive_seq;
extern int sq_selected_recursive;

extern GdkGC *sq_black_gc;
extern GdkGC *sq_white_gc;
extern GdkGC *sq_select_gc;
extern GdkGC *sq_erase_gc;
extern GdkPixmap *sq_pixmap;

extern lastX, lastY;
extern dx, dy;

/*
 * sq_edit_selection
 */
void sq_edit_selection(int x, int y, GdkEventButton *event)
{
  int i;

  sq_lifeline_init_selection();
  sq_message_init_selection();
  sq_recursive_init_selection();

  for(i=0; i<sq_lifeline_count; i++){
    if(sq_util_select_rect(&sqLifeline[i].object_rect, x, y)){

      if(event->type == 5){
	sq_selected_lifeline = 9999;
	sq_selected_message = 9999;
	sq_selected_recursive = 9999;
	sq_lifeline_dialog_open(i);
	return;
      }
	
      sq_lifeline_draw(sq_pixmap, sq_white_gc, sq_select_gc,
		       &sqLifeline[i]);
      sq_lifeline_draw(sq_pixmap, sq_select_gc, sq_select_gc,
		       &sqLifeline[i]);
      
      sqLifeline[i].select_mode = TRUE;
      sq_selected_lifeline = i;
      sq_selected_message = 9999;
      sq_selected_recursive = 9999;
      return;
    }
  }

  for(i=0; i<sq_message_count; i++){
    if(sq_util_select_line_h(sqMessage[i].start_x, sqMessage[i].end_x,
			     sqMessage[i].start_y, x, y)){
      if(event->type == 5){
	sq_selected_lifeline = 9999;
	sq_selected_message = 9999;
	sq_selected_recursive = 9999;
	sq_message_dialog_open(i);
	return;
      }
	
      sq_message_draw2(sq_pixmap, sq_white_gc, i);
      sq_message_draw2(sq_pixmap, sq_select_gc, i);
      sqMessage[i].select_mode = TRUE;
      sq_selected_lifeline = 9999;
      sq_selected_message = i;
      sq_selected_recursive = 9999;
      return;
    }
  }

  for(i=0; i<sq_recursive_count; i++){
    if(sq_util_select_rect(&sqRecursive[i].rect, x, y)){

      if(event->type == 5){
	sq_selected_lifeline = 9999;
	sq_selected_message = 9999;
	sq_selected_recursive = 9999;
	sq_recursive_dialog_open(i);
	return;
      }

      sq_recursive_draw(sq_pixmap, sq_white_gc, i);
      sq_recursive_draw(sq_pixmap, sq_select_gc, i);
      sqRecursive[i].select_mode = TRUE;
      sq_selected_lifeline = 9999;
      sq_selected_message = 9999;
      sq_selected_recursive = i;
      return;
    }
  }
}

/*
 * sq_edit_lifeline_add
 */
void sq_edit_lifeline_add(int x, int y)
{
  int i, j;

  if(sq_lifeline_count >= SQ_LIFELINE_MAX) {
    g_print("no more lifeline\n");
    return;
  }

  i = sq_lifeline_count;
  j = sq_lifeline_seq;

  sq_lifeline_new(i, j, x, y);
  sq_lifeline_draw(sq_pixmap, sq_black_gc, sq_select_gc,
		   &sqLifeline[i]);

  sq_lifeline_count++;
  sq_lifeline_seq++;
}

/*
 * sq_edit_mr_follow
 */
void sq_edit_mr_follow(int i, int dx)
{
  int j;

  for(j=0; j<sq_message_count; j++){
    if(sqLifeline[i].id == sqMessage[j].start_node_id ){
      sq_message_draw2(sq_pixmap, sq_white_gc, j);
      sq_message_extend_start(dx, j);
      sq_message_draw2(sq_pixmap, sq_black_gc, j);
    }
    if(sqLifeline[i].id == sqMessage[j].end_node_id) {
      sq_message_draw2(sq_pixmap, sq_white_gc, j);
      sq_message_extend_end(dx, j);
      sq_message_draw2(sq_pixmap, sq_black_gc, j);
    }
  }
  for(j=0; j<sq_recursive_count; j++){
    if(sqLifeline[i].id == sqRecursive[j].node_id) {
      sq_recursive_draw(sq_pixmap, sq_erase_gc, j);
      //sq_recursive_erase(sq_pixmap, j);
      sq_recursive_move_h(dx, j);
      sq_recursive_draw(sq_pixmap, sq_black_gc, j);
    }
  }
}

/*
 * sq_edit_lifeline_move
 */
void sq_edit_lifeline_move(int x, int y, int i)
{
  int dx, dy;

  sq_lifeline_draw2(sq_pixmap, sq_white_gc, sq_white_gc, i);

  dx = x - lastX;
  dy = y - lastY;

  sq_lifeline_move(dx, dy, i);
  sq_edit_mr_follow(i, dx);

  sq_lifeline_draw2(sq_pixmap, sq_black_gc, sq_select_gc, i);

  lastX = x;
  lastY = y;
}

/*
 * sq_edit_lifeline_delete()
 */
void sq_edit_lifeline_delete()
{
  int i, j;

  j = sq_lifeline_count-1;

  if(sqLifeline[j].select_mode){

    sq_edit_message_delete_by_lifeline(sqLifeline[j].id);
    sq_edit_recursive_delete_by_lifeline(sqLifeline[j].id);

    sq_lifeline_draw2(sq_pixmap, sq_white_gc, sq_white_gc, j);
    sq_lifeline_init(j);
    sq_lifeline_count--;
    return;
  }

  for(i=sq_lifeline_count-2; i>=0; i--){
    if(sqLifeline[i].select_mode){

      sq_edit_message_delete_by_lifeline(sqLifeline[i].id);
      sq_edit_recursive_delete_by_lifeline(sqLifeline[i].id);

      sq_lifeline_draw2(sq_pixmap, sq_white_gc, sq_white_gc, i);
      sq_lifeline_copy(i, j);
      sq_lifeline_init(j);
      sq_lifeline_count--;
      return;
    }
  }
}

/*
 * sq_edit_message_delete_by_lifeline
 */
void sq_edit_message_delete_by_lifeline(int id)
{
  int j;

  for(j=sq_message_count-1; j>=0; j--){
    if(id == sqMessage[j].start_node_id || id == sqMessage[j].end_node_id){
      sqMessage[j].select_mode = TRUE;
      sq_edit_message_delete();
    }
  }
}

/*
 * sq_edit_recursive_delete_by_lifeline
 */
void sq_edit_recursive_delete_by_lifeline(int id)
{
  int j;

  for(j=sq_recursive_count-1; j>=0; j--){
    if(id == sqRecursive[j].node_id){
      sqRecursive[j].select_mode = TRUE;
      sq_edit_recursive_delete();
    }
  }
}

/*
 * sq_edit_message_move
 */
void sq_edit_message_move(int x, int y, int i)
{
  int dx, dy;

  sq_message_draw2(sq_pixmap, sq_white_gc, i);

  dy = y - lastY;

  sq_message_move(dy, i);

  sq_message_draw2(sq_pixmap, sq_black_gc, i);

  lastX = x;
  lastY = y;
}  

/*
 * sq_edit_message_add_start
 */
void sq_edit_message_add_start(int x, int y)
{
  int i;
  int start_y = y;

  if(sq_message_count >= SQ_MESSAGE_MAX) {
    g_print("no more message\n");
    return;
  }

  sq_message_start = 9999;

  for(i=0; i<sq_lifeline_count; i++){
    if(sq_util_select_line_v(&sqLifeline[i].rect, x, y)){
      sq_message_start = sq_message_count;
      sq_message_add_start(sq_message_count, sq_message_seq,
			   sqLifeline[i].id,
			   sqLifeline[i].rect.x, y);
      return;
    }
  }
}

/*
 * sq_edit_add_message_end
 */
void sq_edit_message_add_end(int x, int y)
{
  int i;

  if(sq_message_count >= SQ_MESSAGE_MAX) {
    g_print("no more message\n");
    return;
  }

  if(sq_message_start == 9999)
    return;

  for(i=0; i<sq_lifeline_count; i++){
    if(sq_util_select_line_v(&sqLifeline[i].rect, x, y)){
      if(!sq_message_add_end(sq_message_count,
			     sqLifeline[i].id, sqLifeline[i].rect.x))
	return;
      sq_message_draw2(sq_pixmap, sq_black_gc, sq_message_count);
      sq_message_count++;
      sq_message_seq++;
      return;
    }
  }
}

/*
 * sq_edit_message_delete()
 */
void sq_edit_message_delete()
{
  int i, j;

  j = sq_message_count-1;

  if(sqMessage[j].select_mode){
    sq_message_draw2(sq_pixmap, sq_white_gc, j);
    sq_message_init(j);
    sq_message_count--;
    return;
  }

  for(i=sq_message_count-2; i>=0; i--){
    if(sqMessage[i].select_mode){
      sq_message_draw2(sq_pixmap, sq_white_gc, i);
      sq_message_copy(i, j);
      sq_message_init(j);
      sq_message_count--;
      return;
    }
  }
}

/*
 * sq_edit_recursive_add
 */
void sq_edit_recursive_add(int x, int y)
{
  int i, count, seq;

  if(sq_recursive_count >= SQ_RECURSIVE_MAX){
    g_print("no more recursive\n");
    return;
  }

  count = sq_recursive_count;
  seq = sq_recursive_seq;

  for(i=0; i<sq_lifeline_count; i++){
    if(sq_util_select_line_v(&sqLifeline[i].rect, x, y)){
      sq_recursive_new(count, seq,
		       sqLifeline[i].rect.x, y,
		       sqLifeline[i].id);
      sq_recursive_draw(sq_pixmap, sq_black_gc, count);
      sq_recursive_count++;
      sq_recursive_seq++;
      return;
    }
  }
}

/*
 * sq_edit_recursive_move
 */
void sq_edit_recursive_move(int x, int y, int i)
{
  int dx, dy;

  sq_recursive_draw(sq_pixmap, sq_erase_gc, i);

  dy = y - lastY;

  sq_recursive_move_v(dy, i);

  sq_recursive_draw(sq_pixmap, sq_black_gc, i);

  lastX = x;
  lastY = y;
}  

/*
 * sq_edit_recursive_delete()
 */
void sq_edit_recursive_delete()
{
  int i, j;

  j = sq_recursive_count-1;

  if(sqRecursive[j].select_mode){
    sq_recursive_draw(sq_pixmap, sq_erase_gc, j);
    sq_recursive_init(j);
    sq_recursive_count--;
    return;
  }

  for(i=sq_recursive_count-2; i>=0; i--){
    if(sqRecursive[i].select_mode){
      sq_recursive_draw(sq_pixmap, sq_erase_gc, i);
      sq_recursive_copy(i, j);
      sq_recursive_init(j);
      sq_recursive_count--;
      return;
    }
  }
}

