/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <gdk_imlib.h>

#include "sq_io.h"

IoDialog iod;

extern GdkPixmap *sq_pixmap;

/*
 * sq_io_filename_init
 */
void sq_io_filename_init()
{
  if(iod.sq_filename){
    g_free(iod.sq_filename);
    iod.sq_filename = NULL;
  }
}

/*
 * sq_io_load
 */
int sq_io_load()
{
  FILE *fp;

  if(!iod.sq_filename){
    g_print("Cannot get filename\n");
    return FALSE;
  }
    
  if((fp = fopen(iod.sq_filename, "r")) == NULL) {
    g_print("Cannot Open %s\n", iod.sq_filename);
    return FALSE;
  }
  
  if(!sq_util_load_header(fp)){
    g_print("Invalid Header\n");
    return FALSE;
  }

  sq_lifeline_load(fp);
  sq_message_load(fp);
  sq_recursive_load(fp);

  fclose(fp);

  return TRUE;
}

/*
 * sq_io_save
 */
void sq_io_save()
{
  FILE *fp;

  if(!iod.sq_filename){
    g_print("Cannot get filename\n");
    return;
  }
    
  if((fp = fopen(iod.sq_filename, "w")) == NULL) {
    g_print("Cannot Open %s\n", iod.sq_filename);
    return;
  }
  
  sq_util_save_header(fp);
  sq_lifeline_save(fp);
  sq_message_save(fp);
  sq_recursive_save(fp);

  fclose(fp);
}

/*
 * sq_io_export
 */
void sq_io_export(export_kind ek)
{
  FILE *fp;
  GdkRectangle rect;
  GdkImlibImage *im;

  int res;

  gchar *export_filename;
  
  export_filename = g_strdup(iod.sq_filename);
  strtok(export_filename, ".");

  switch(ek){
  case JPG:
    strcat(export_filename, ".jpg");
    break;
  case EPS:
    strcat(export_filename, ".eps");
    break;
  }

  if((fp = fopen(export_filename, "w")) == NULL) {
    g_print("Cannot Open %s\n", export_filename);
    return;
  }

  if(!sq_util_get_effective_rect(&rect)){
    g_print("No Effective Rect\n");
    return;
  }

  im = gdk_imlib_create_image_from_drawable((GdkWindow*)sq_pixmap, 
					    NULL,
					    rect.x, rect.y,
					    rect.width, rect.height);

  res = gdk_imlib_save_image(im, export_filename, NULL);

  if(!res)
    g_print("Cannot Save Image\n");

  fclose(fp);
}

/*
 * sq_io_dialog_ok_button
 */
void sq_io_dialog_ok_button(GtkWidget *widget, GtkFileSelection *fs)
{
  if(iod.sq_filename)
    free(iod.sq_filename);

  iod.sq_filename =
    (gchar*)strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));

  gtk_widget_destroy(GTK_WIDGET(fs));

  gtk_main_quit();
}

/*
 * sq_io_dialog_open
 */
void sq_io_dialog_open()
{
  iod.window = gtk_file_selection_new(NULL);

  gtk_signal_connect(GTK_OBJECT(iod.window),"destroy",
		     (GtkSignalFunc)gtk_widget_destroy, iod.window);

  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(iod.window)->ok_button),
		     "clicked", (GtkSignalFunc)sq_io_dialog_ok_button,
		     iod.window);

  gtk_signal_connect_object
    (GTK_OBJECT(GTK_FILE_SELECTION(iod.window)->cancel_button),
     "clicked", (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(iod.window));

  gtk_file_selection_set_filename
    (GTK_FILE_SELECTION(iod.window), "newfile.sq");
  
  gtk_widget_show(iod.window);

  gtk_window_set_modal((GtkWindow*)iod.window, TRUE);

  gtk_main();
}
