/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>

#include "sq_define.h"
#include "sq_lifeline.h"

Lifeline sqLifeline[SQ_LIFELINE_MAX];
int sq_lifeline_count;
int sq_lifeline_seq;

int sq_selected_lifeline;

extern GdkGC *sq_black_gc;
extern GdkGC *sq_white_gc;
extern GdkGC *sq_select_gc;
extern GdkPixmap *sq_pixmap;

extern GdkFont *sq_font;

/*
 * sq_lifeline_init
 */
void sq_lifeline_init(int i)
{
  sqLifeline[i].id = 0;

  sprintf(sqLifeline[i].name, "");
  
  sqLifeline[i].name_point.x = 0; 
  sqLifeline[i].name_point.y = 0; 

  sqLifeline[i].object_rect.x = 0; 
  sqLifeline[i].object_rect.y = 0; 
  sqLifeline[i].object_rect.width = 0; 
  sqLifeline[i].object_rect.height = 0; 

  sqLifeline[i].rect.x = 0; 
  sqLifeline[i].rect.y = 0; 
  sqLifeline[i].rect.width = 0; 
  sqLifeline[i].rect.height = 0; 

  sqLifeline[i].select_mode = FALSE;
}

/*
 * sq_lifeline_init_all
 */
void sq_lifeline_init_all()
{
  int i;

  for(i=0; i<SQ_LIFELINE_MAX; i++)
    sq_lifeline_init(i);
}  

/*
 * sq_lifeline_init
 */
void sq_lifeline_init_selection()
{
  int i;

  for(i=0; i<sq_lifeline_count; i++)
    sqLifeline[i].select_mode = FALSE;
}

/*
 * sq_lifeline_new
 */
void sq_lifeline_new(int i, int j, int x, int y)
{
  sqLifeline[i].id = j;

  sprintf(sqLifeline[i].name, "%s", SQ_LIFELINE_DEFAULT_NAME);
  
  sqLifeline[i].object_rect.x = x; 
  sqLifeline[i].object_rect.y = 50; 

  sq_util_set_lifeline_geometry(&sqLifeline[i]);

  sqLifeline[i].select_mode = FALSE;
}

/*
 * sq_lifeline_copy
 */
void sq_lifeline_copy(int dst, int src)
{
  sqLifeline[dst].id = sqLifeline[src].id;

  sprintf(sqLifeline[dst].name, "%s", sqLifeline[src].name);
  
  sqLifeline[dst].name_point.x = sqLifeline[src].name_point.x;
  sqLifeline[dst].name_point.y = sqLifeline[src].name_point.y;

  sqLifeline[dst].object_rect.x = sqLifeline[src].object_rect.x; 
  sqLifeline[dst].object_rect.y = sqLifeline[src].object_rect.y; 
  sqLifeline[dst].object_rect.width = sqLifeline[src].object_rect.width; 
  sqLifeline[dst].object_rect.height = sqLifeline[src].object_rect.height; 

  sqLifeline[dst].rect.x = sqLifeline[src].rect.x;
  sqLifeline[dst].rect.y = sqLifeline[src].rect.y;
  sqLifeline[dst].rect.width = sqLifeline[src].rect.width; 
  sqLifeline[dst].rect.height = sqLifeline[src].rect.height; 

  sqLifeline[dst].select_mode = sqLifeline[src].select_mode;
}

/*
 * sq_lifeline_move
 */
void sq_lifeline_move(int dx, int dy, int i)
{
  sqLifeline[i].name_point.x += dx;
  //sqLifeline[i].name_point.y += dy;

  sqLifeline[i].object_rect.x += dx;
  //sqLifeline[i].object_rect.y += dy;

  sqLifeline[i].rect.x += dx;
  //sqLifeline[i].rect.y += dy;
}

/*
 * sq_lifeline_draw
 */
void sq_lifeline_draw(GdkPixmap *pixmap, GdkGC *gc1, GdkGC *gc2,
		      Lifeline *l_ptr)
{
  gdk_draw_line(pixmap, gc2,
		l_ptr->rect.x,
		l_ptr->rect.y,
		l_ptr->rect.x, l_ptr->rect.y+l_ptr->rect.height);

  gdk_draw_rectangle(pixmap, gc1, FALSE,
		     l_ptr->object_rect.x,
		     l_ptr->object_rect.y,
		     l_ptr->object_rect.width,
		     l_ptr->object_rect.height);

  gdk_draw_string(pixmap, sq_font, gc1,
		  l_ptr->name_point.x,
		  l_ptr->name_point.y,
		  l_ptr->name);
}

/*
 * sq_lifeline_draw2
 */
void sq_lifeline_draw2(GdkPixmap *pixmap, GdkGC *gc1, GdkGC *gc2, int i)
{
  gdk_draw_line(pixmap, gc2,
		sqLifeline[i].rect.x,
		sqLifeline[i].rect.y,
		sqLifeline[i].rect.x,
		sqLifeline[i].rect.y+sqLifeline[i].rect.height);

  gdk_draw_rectangle(pixmap, gc1, FALSE,
		     sqLifeline[i].object_rect.x,
		     sqLifeline[i].object_rect.y,
		     sqLifeline[i].object_rect.width,
		     sqLifeline[i].object_rect.height);

  gdk_draw_string(pixmap, sq_font, gc1,
		  sqLifeline[i].name_point.x,
		  sqLifeline[i].name_point.y,
		  sqLifeline[i].name);
}

/*
 * sq_lifeline_draw_all
 */
void sq_lifeline_draw_all()
{
  int i;

  for(i=0; i<sq_lifeline_count; i++)
    sq_lifeline_draw2(sq_pixmap, sq_black_gc, sq_select_gc, i);
}

/*
 * sq_lifeline_load
 */
void sq_lifeline_load(FILE *fp)
{
  char line[BUFSIZ];
  int count, seq;
  int i, dummy;
  char str[4], flg[4];

  fgets(line, BUFSIZ, fp);
  sscanf(line, "%s %d %d", str, &count, &seq);

  sq_lifeline_count = count;
  sq_lifeline_seq = seq;

  for(i=0; i<count; i++){
    fgets(line, BUFSIZ, fp);
    sscanf(line, "%s %d %s %d %d %d %d %d %d %d %d %d %d %d",
	   flg, &sqLifeline[i].id, sqLifeline[i].name,
	   &sqLifeline[i].name_point.x, 
	   &sqLifeline[i].name_point.y,
	   &sqLifeline[i].object_rect.x,
	   &sqLifeline[i].object_rect.y,
	   &sqLifeline[i].object_rect.width,
	   &sqLifeline[i].object_rect.height,
	   &sqLifeline[i].rect.x,
	   &sqLifeline[i].rect.y,
	   &sqLifeline[i].rect.width,
	   &sqLifeline[i].rect.height,
	   &sqLifeline[i].select_mode);

    if(!strcmp(sqLifeline[i].name,"None"))
      sprintf(sqLifeline[i].name, "");

    sqLifeline[i].select_mode = FALSE;
  }
}


/*
 * sq_lifeline_save
 */
void sq_lifeline_save(FILE *fp)
{
  int i;

  fprintf(fp, "LL! %d %d\n", sq_lifeline_count, sq_lifeline_seq);

  for(i=0; i<sq_lifeline_count; i++){
    fprintf(fp, "ll:");
    fprintf(fp, " %d", sqLifeline[i].id);

    if(strlen(sqLifeline[i].name) > 0)
      fprintf(fp, " %s", sqLifeline[i].name);
    else
      fprintf(fp, " None");
    
    fprintf(fp, " %d %d",
	    sqLifeline[i].name_point.x,
	    sqLifeline[i].name_point.y);
    fprintf(fp, " %d %d %d %d",
	    sqLifeline[i].object_rect.x,
	    sqLifeline[i].object_rect.y,
	    sqLifeline[i].object_rect.width,
	    sqLifeline[i].object_rect.height);
    fprintf(fp, " %d %d %d %d",
	    sqLifeline[i].rect.x,
	    sqLifeline[i].rect.y,
	    sqLifeline[i].rect.width,
	    sqLifeline[i].rect.height);
    fprintf(fp, " %d", sqLifeline[i].select_mode);
    fprintf(fp, "\n");
  }
}

/*
 * sq_lifeline_dialog_new
 */
void sq_lifeline_dialog_new(LifelineDialog *ld)
{
  ld->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal((GtkWindow*)ld->window, TRUE);
  gtk_container_border_width(GTK_CONTAINER(ld->window), 10);
  gtk_signal_connect(GTK_OBJECT(ld->window), "destroy",
		     NULL, NULL);
		     //		     (GtkSignalFunc)gtk_main_quit, NULL);

  gtk_widget_show(ld->window);

  ld->vbox = gtk_vbox_new(FALSE, 5);
  ld->hbox = gtk_hbox_new(FALSE, 5);
  ld->hbox2 = gtk_hbox_new(FALSE, 5);

  ld->entry = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(ld->entry), 20);

  gtk_box_pack_start(GTK_BOX(ld->hbox), ld->entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(ld->vbox), ld->hbox, FALSE, TRUE, 0);

  ld->ok_button = gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(ld->hbox2), ld->ok_button, TRUE, TRUE, 0);
  ld->apply_button = gtk_button_new_with_label("Apply");
  gtk_box_pack_start(GTK_BOX(ld->hbox2), ld->apply_button, TRUE, TRUE, 0);
  ld->close_button = gtk_button_new_with_label("Close");
  gtk_box_pack_start(GTK_BOX(ld->hbox2), ld->close_button, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(ld->vbox), ld->hbox2, FALSE, TRUE, 0);
  gtk_container_add(GTK_CONTAINER(ld->window), ld->vbox);

  gtk_widget_show_all(ld->vbox);
}

/*
 * sq_lifeline_dialog_apply_button
 */
void sq_lifeline_dialog_apply_button(GtkWidget *widget, LifelineDialog *ld)
{
  int dx;

  gchar *str = gtk_entry_get_text((GtkEntry*)ld->entry);

  sq_lifeline_draw2(sq_pixmap, sq_white_gc, sq_white_gc, ld->i);

  sprintf(sqLifeline[ld->i].name, "%s", str);
  dx = sq_util_set_lifeline_geometry(&sqLifeline[ld->i]);
  if(dx != 0) {
    sq_edit_mr_follow(ld->i, dx);
  }

  sq_lifeline_draw2(sq_pixmap, sq_black_gc, sq_select_gc, ld->i);

  sq_drawing_area_update_all();
}

/*
 * sq_lifeline_dialog_close_button
 */
void sq_lifeline_dialog_close_button(GtkWidget *widget, LifelineDialog *ld)
{
  gtk_widget_destroy(ld->window);
}

/*
 * sq_lifeline_dialog_ok_button
 */
void sq_lifeline_dialog_ok_button(GtkWidget *widget, LifelineDialog *ld)
{
  sq_lifeline_dialog_apply_button(widget, ld);
  sq_lifeline_dialog_close_button(widget, ld);
}

/*
 * sq_lifeline_dialog_set_signal
 */
void sq_lifeline_dialog_set_signal(LifelineDialog *ld)
{
  gtk_signal_connect (GTK_OBJECT (ld->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (sq_lifeline_dialog_ok_button),
		      (gpointer)ld);

  gtk_signal_connect (GTK_OBJECT (ld->apply_button), "clicked",
		      GTK_SIGNAL_FUNC (sq_lifeline_dialog_apply_button),
		      (gpointer)ld);
  
  gtk_signal_connect (GTK_OBJECT (ld->close_button), "clicked",
		      GTK_SIGNAL_FUNC (sq_lifeline_dialog_close_button),
		      (gpointer)ld);
}

/*
 * sq_lifeline_dialog_open
 */
void sq_lifeline_dialog_open(int i)
{
  LifelineDialog ld;

  ld.i = i;

  sq_lifeline_dialog_new(&ld);
  gtk_entry_set_text((GtkEntry*)ld.entry, sqLifeline[i].name);
  sq_lifeline_dialog_set_signal(&ld);

  gtk_main();
}
