/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef SQ_LIFELINE_H
#define SQ_LIFELINE_H

#include <stdio.h>
#include <gtk/gtk.h>

typedef struct _Lifeline Lifeline;
typedef struct _LifelineDialog LifelineDialog;

/*
 * Lifeline
 */
struct _Lifeline
{
  int id;

  char name[64];
  GdkPoint name_point;
  GdkRectangle object_rect;

  GdkRectangle rect;
  int select_mode;
};

/*
 * LifelineDialog
 */
struct _LifelineDialog
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *hbox2;
  GtkWidget *entry;

  GtkWidget *ok_button;
  GtkWidget *apply_button;
  GtkWidget *close_button;

  int i;
};

void sq_lifeline_init(int i);
void sq_lifeline_init_all();
void sq_lifeline_init_selection();

void sq_lifeline_new(int i, int j, int x, int y);
void sq_lifeline_copy(int dst, int src);
void sq_lifeline_move(int x, int y, int i);

void sq_lifeline_draw(GdkPixmap *pixmap, GdkGC *gc1, GdkGC *gc2,
		      Lifeline *l_ptr);
void sq_lifeline_draw2(GdkPixmap *pixmap, GdkGC *gc1, GdkGC *gc2, int i);
void sq_lifeline_draw_all();
		      
void sq_lifeline_load(FILE *fp);
void sq_lifeline_save(FILE *fp);

void sq_lifeline_dialog_open(int i);

#endif
