/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "sq_main_window.h"

/*
 * sq_main_window_signal (local)
 */ 
void sq_main_window_signal(GtkWidget *window)
{
  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		     GTK_SIGNAL_FUNC(gtk_exit), NULL);
  gtk_signal_connect(GTK_OBJECT(window), "destroy",
		     GTK_SIGNAL_FUNC(gtk_exit), NULL);
}

/*
 * sq_main_window_new
 */
GtkWidget* sq_main_window_new()
{
  GtkWidget *sq_main_window;
  GtkWidget *vbox;

  sq_main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(sq_main_window), "sqedit");
  gtk_window_set_policy(GTK_WINDOW(sq_main_window), FALSE, FALSE, TRUE);
  gtk_widget_set_usize(sq_main_window, 800, 600);
  sq_main_window_signal(sq_main_window);

  vbox = gtk_vbox_new(FALSE, 0);

  gtk_widget_show(sq_main_window);

  sq_menubar_new(sq_main_window, vbox);
  sq_toolbar_new(sq_main_window, vbox);
  sq_drawing_area_new(sq_main_window, vbox);

  gtk_container_add(GTK_CONTAINER(sq_main_window), vbox);
  gtk_widget_show(vbox);

  return sq_main_window;
}
