/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "sq_commands.h"
#include "sq_menubar.h"

/*
 * sq_menubar_new
 */
void sq_menubar_new(GtkWidget *window, GtkWidget *vbox)
{
  int sq_menu_file_num = sizeof(sq_menu_file) / sizeof(sq_menu_file[0]);
  int sq_menu_edit_num = sizeof(sq_menu_edit) / sizeof(sq_menu_edit[0]);

  GtkWidget *menubar;
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  GtkWidget *handle;

  handle = gtk_handle_box_new();

  accel_group = gtk_accel_group_new();

  item_factory = gtk_item_factory_new
    (GTK_TYPE_MENU_BAR, "<main>", accel_group);

  gtk_item_factory_create_items
    (item_factory, sq_menu_file_num, sq_menu_file, NULL);
  gtk_item_factory_create_items
    (item_factory, sq_menu_edit_num, sq_menu_edit, NULL);

  gtk_accel_group_attach(accel_group, GTK_OBJECT(window));

  menubar = gtk_item_factory_get_widget(item_factory, "<main>");

  gtk_widget_show(menubar);

  gtk_container_add(GTK_CONTAINER(handle), GTK_WIDGET(menubar));
  gtk_box_pack_start(GTK_BOX(vbox), handle, FALSE, FALSE, 0);
  gtk_widget_show(handle);
}
