/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef SQ_MENUBAR_H
#define SQ_MENUBAR_H

#include <gtk/gtk.h>

/*
 * File Menu
 */
static GtkItemFactoryEntry sq_menu_file[] = {
  { "/File",            NULL,         NULL,            0, "<Branch>" },
  { "/File/New",        "<control>N", sq_file_new,     0, NULL },
  { "/File/Open",       "<control>O", sq_file_load,    0, NULL },
  { "/File/Save",       "<control>S", sq_file_save,    0, NULL },
  { "/File/Save as",    NULL,         sq_file_save_as, 0, NULL },
  { "/File/separator",  NULL,         NULL,            0, "<Separator>" },
  { "/File/Export",     NULL,         NULL,            0, "<Branch>" },
  { "/File/Export/jpg", "<control>J", sq_export_jpg,   0, NULL },
  { "/File/Export/eps", "<control>E", sq_export_eps,   0, NULL },
  { "/File/separator",  NULL,         NULL,            0, "<Separator>" },
  { "/File/Quit", "     <control>Q",  sq_quit,         0, NULL },
};

/*
 * Edit Menu
 */
static GtkItemFactoryEntry sq_menu_edit[] = {
  { "/Edit",            NULL,         NULL,            0, "<Branch>" },
  { "/Edit/Delete",     "<control>D", sq_edit_delete,  0, NULL },
};

void sq_menubar_new(GtkWidget *window, GtkWidget *vbox);

#endif
