/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>

#include "sq_define.h"
#include "sq_lifeline.h"
#include "sq_message.h"

extern Lifeline sqLifeline[SQ_LIFELINE_MAX];

Message sqMessage[SQ_MESSAGE_MAX];

int sq_message_count;
int sq_message_seq;
int sq_message_start;

int sq_selected_message;

extern GdkFont *sq_font;
extern GdkGC *sq_black_gc;
extern GdkGC *sq_white_gc;
extern GdkGC *sq_select_gc;
extern GdkPixmap *sq_pixmap;

/*
 * sq_message_init
 */
void sq_message_init(int i)
{
  sqMessage[i].id = 0;

  sprintf(sqMessage[i].name, "");

  sqMessage[i].str_rect.x = 0;
  sqMessage[i].str_rect.y = 0;
  sqMessage[i].str_rect.width = 0;
  sqMessage[i].str_rect.height = 0;

  sqMessage[i].start_x = 0;
  sqMessage[i].start_y = 0;
  sqMessage[i].start_node_id = 0;

  sqMessage[i].end_x = 0;
  sqMessage[i].end_y = 0;
  sqMessage[i].end_node_id = 0;

  sqMessage[i].select_mode = FALSE;
}

/*
 * sq_message_init_all
 */
void sq_message_init_all()
{
  int i;

  for(i=0; i<SQ_MESSAGE_MAX; i++)
    sq_message_init(i);
}

/*
 * sq_message_init_selection
 */
void sq_message_init_selection()
{
  int i;

  for(i=0; i<sq_message_count; i++)
    sqMessage[i].select_mode = FALSE;
}
    
/*
 * sq_message_add_start
 */
void sq_message_add_start(int i, int id,
			  int start_node_id, int start_x, int start_y)
{
  sqMessage[i].id = id;

  sprintf(sqMessage[i].name,"");

  sqMessage[i].start_node_id = start_node_id;
  sqMessage[i].start_x = start_x;
  sqMessage[i].start_y = start_y;
}

/*
 * sq_message_add_end
 */
gint sq_message_add_end(int i, int end_node_id, int end_x)
{
  if(end_node_id == sqMessage[i].start_node_id){
    g_print("Invalid Operation ... Sorry\n");
    return FALSE;
  }

  sqMessage[i].end_node_id = end_node_id;
  sqMessage[i].end_x = end_x;
  sqMessage[i].end_y = sqMessage[i].start_y;

  sqMessage[i].select_mode = FALSE;

  return TRUE;
}

/*
 * sq_message_extend_start
 */
void sq_message_extend_start(int dx, int i)
{
  sqMessage[i].start_x += dx;
  sq_util_set_message_str_rect(&sqMessage[i]);
}

/*
 * sq_message_extend_end
 */
void sq_message_extend_end(int dx, int i)
{
  sqMessage[i].end_x += dx;
  sq_util_set_message_str_rect(&sqMessage[i]);
}

/*
 * sq_message_move
 */
void sq_message_move(int dy, int i)
{
  sqMessage[i].start_y += dy;
  sqMessage[i].end_y += dy;
  sq_util_set_message_str_rect(&sqMessage[i]);
}

/*
 * sq_message_copy
 */
void sq_message_copy(int dst, int src)
{
  sqMessage[dst].id = sqMessage[src].id;

  sprintf(sqMessage[dst].name, "%s", sqMessage[src].name);

  sqMessage[dst].str_rect.x = sqMessage[src].str_rect.x;
  sqMessage[dst].str_rect.y = sqMessage[src].str_rect.y;
  sqMessage[dst].str_rect.width = sqMessage[src].str_rect.width;
  sqMessage[dst].str_rect.height = sqMessage[src].str_rect.height;

  sqMessage[dst].start_x = sqMessage[src].start_x;
  sqMessage[dst].start_y = sqMessage[src].start_y;
  sqMessage[dst].start_node_id = sqMessage[src].start_node_id;

  sqMessage[dst].end_x = sqMessage[src].end_x;
  sqMessage[dst].end_y = sqMessage[src].end_y;
  sqMessage[dst].end_node_id = sqMessage[src].end_node_id;

  sqMessage[dst].select_mode = sqMessage[src].select_mode;
}  

/*
 * sq_message_draw
 */
void sq_message_draw(GdkPixmap *pixmap, GdkGC *gc, Message *m_ptr)
{
  gdk_draw_line(pixmap, gc,
		m_ptr->start_x, m_ptr->start_y,
		m_ptr->end_x, m_ptr->end_y);
}

/*
 * sq_message_draw2
 */
void sq_message_draw2(GdkPixmap *pixmap, GdkGC *gc, int i)
{
  gdk_draw_line(pixmap, gc,
		sqMessage[i].start_x,
		sqMessage[i].start_y,
		sqMessage[i].end_x,
		sqMessage[i].end_y);

  if(sqMessage[i].start_x < sqMessage[i].end_x) {

    gdk_draw_line(pixmap, gc,
		  sqMessage[i].end_x-5,
		  sqMessage[i].end_y-5,
		  sqMessage[i].end_x,
		  sqMessage[i].end_y);

    gdk_draw_line(pixmap, gc,
		  sqMessage[i].end_x-5,
		  sqMessage[i].end_y+5,
		  sqMessage[i].end_x,
		  sqMessage[i].end_y);
  } else {
    gdk_draw_line(pixmap, gc,
		  sqMessage[i].end_x+5,
		  sqMessage[i].end_y-5,
		  sqMessage[i].end_x,
		  sqMessage[i].end_y);

    gdk_draw_line(pixmap, gc,
		  sqMessage[i].end_x+5,
		  sqMessage[i].end_y+5,
		  sqMessage[i].end_x,
		  sqMessage[i].end_y);
  }

  if(strlen(sqMessage[i].name) > 0) {
    gdk_draw_rectangle(pixmap, sq_white_gc, TRUE,
		       sqMessage[i].str_rect.x,
		       sqMessage[i].str_rect.y,
		       sqMessage[i].str_rect.width,
		       sqMessage[i].str_rect.height);
    
    gdk_draw_string(pixmap, sq_font, gc,
		    sqMessage[i].str_rect.x,
		    sqMessage[i].str_rect.y,
		    sqMessage[i].name);
  }
}

/*
 * sq_message_draw_all
 */
void sq_message_draw_all()
{
  int i;

  for(i=0; i<sq_message_count; i++)
    sq_message_draw2(sq_pixmap, sq_black_gc, i);
}

/*
 * sq_message_load
 */
void sq_message_load(FILE *fp)
{
  char line[BUFSIZ];
  int count, seq;
  int i, dummy;
  char str[5], flg[5];

  fgets(line, BUFSIZ, fp);
  sscanf(line, "%s %d %d", str, &count, &seq);

  sq_message_count = count;
  sq_message_seq = seq;

  for(i=0; i<count; i++){
    fgets(line, BUFSIZ, fp);
    sscanf(line, "%s %d %s %d %d %d %d %d %d %d %d %d %d %d",
	   flg, &sqMessage[i].id, sqMessage[i].name,
	   &sqMessage[i].str_rect.x,
	   &sqMessage[i].str_rect.y,
	   &sqMessage[i].str_rect.width,
	   &sqMessage[i].str_rect.height,
	   &sqMessage[i].start_x,
	   &sqMessage[i].start_y,
	   &sqMessage[i].start_node_id,
	   &sqMessage[i].end_x,
	   &sqMessage[i].end_y,
	   &sqMessage[i].end_node_id,
	   &sqMessage[i].select_mode);

    if(!strcmp(sqMessage[i].name,"None"))
      sprintf(sqMessage[i].name, "");

    sqMessage[i].select_mode = FALSE;
  }
}  

/*
 * sq_message_save
 */
void sq_message_save(FILE *fp)
{
  int i;

  fprintf(fp, "MSG! %d %d\n", sq_message_count, sq_message_seq);

  for(i=0; i<sq_message_count; i++){
    fprintf(fp,"msg: %d", sqMessage[i].id);

    if(strlen(sqMessage[i].name) > 0)
      fprintf(fp, " %s", sqMessage[i].name);
    else
      fprintf(fp, " None");

    fprintf(fp," %d %d %d %d",
	    sqMessage[i].str_rect.x,
	    sqMessage[i].str_rect.y,
	    sqMessage[i].str_rect.width,
	    sqMessage[i].str_rect.height);
    fprintf(fp," %d %d %d",
	    sqMessage[i].start_x,
	    sqMessage[i].start_y,
	    sqMessage[i].start_node_id);
    fprintf(fp," %d %d %d",
	    sqMessage[i].end_x,
	    sqMessage[i].end_y,
	    sqMessage[i].end_node_id);
    fprintf(fp," %d",
	    sqMessage[i].select_mode);
    fprintf(fp, "\n");
  }
}

/*
 * sq_message_dialog_new
 */
void sq_message_dialog_new(MessageDialog *md)
{
  md->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal((GtkWindow*)md->window, TRUE);
  gtk_container_border_width(GTK_CONTAINER(md->window), 10);
  gtk_signal_connect(GTK_OBJECT(md->window), "destroy",
		     NULL, NULL);
		     //		     (GtkSignalFunc)gtk_main_quit, NULL);

  gtk_widget_show(md->window);

  md->vbox = gtk_vbox_new(FALSE, 5);
  md->hbox = gtk_hbox_new(FALSE, 5);
  md->hbox2 = gtk_hbox_new(FALSE, 5);

  md->entry = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(md->entry), 20);

  gtk_box_pack_start(GTK_BOX(md->hbox), md->entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(md->vbox), md->hbox, FALSE, TRUE, 0);

  md->ok_button = gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(md->hbox2), md->ok_button, TRUE, TRUE, 0);
  md->apply_button = gtk_button_new_with_label("Apply");
  gtk_box_pack_start(GTK_BOX(md->hbox2), md->apply_button, TRUE, TRUE, 0);
  md->close_button = gtk_button_new_with_label("Close");
  gtk_box_pack_start(GTK_BOX(md->hbox2), md->close_button, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(md->vbox), md->hbox2, FALSE, TRUE, 0);
  gtk_container_add(GTK_CONTAINER(md->window), md->vbox);

  gtk_widget_show_all(md->vbox);
}

/*
 * sq_message_dialog_apply_button
 */
void sq_message_dialog_apply_button(GtkWidget *widget, MessageDialog *md)
{
  gchar *str = gtk_entry_get_text((GtkEntry*)md->entry);

  sq_message_draw2(sq_pixmap, sq_white_gc, md->i);

  sprintf(sqMessage[md->i].name, "%s", str);
  sq_util_set_message_str_rect(&sqMessage[md->i]);

  sq_message_draw2(sq_pixmap, sq_black_gc, md->i);

  sq_drawing_area_update_all();
}

/*
 * sq_message_dialog_close_button
 */
void sq_message_dialog_close_button(GtkWidget *widget, MessageDialog *md)
{
  gtk_widget_destroy(md->window);
}

/*
 * sq_message_dialog_ok_button
 */
void sq_message_dialog_ok_button(GtkWidget *widget, MessageDialog *md)
{
  sq_message_dialog_apply_button(widget, md);
  sq_message_dialog_close_button(widget, md);
}

/*
 * sq_message_dialog_set_signal
 */
void sq_message_dialog_set_signal(MessageDialog *md)
{
  gtk_signal_connect (GTK_OBJECT (md->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (sq_message_dialog_ok_button),
		      (gpointer)md);

  gtk_signal_connect (GTK_OBJECT (md->apply_button), "clicked",
		      GTK_SIGNAL_FUNC (sq_message_dialog_apply_button),
		      (gpointer)md);
  
  gtk_signal_connect (GTK_OBJECT (md->close_button), "clicked",
		      GTK_SIGNAL_FUNC (sq_message_dialog_close_button),
		      (gpointer)md);
}

/*
 * sq_message_dialog_open
 */
void sq_message_dialog_open(int i)
{
  MessageDialog md;

  md.i = i;

  sq_message_dialog_new(&md);
  gtk_entry_set_text((GtkEntry*)md.entry, sqMessage[i].name);
  sq_message_dialog_set_signal(&md);

  gtk_main();
}
