/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef SQ_MESSAGE_H
#define SQ_MESSAGE_H

#include <gtk/gtk.h>

typedef struct _Message Message;
typedef struct _MessageDialog MessageDialog;

/*
 * Message
 */
struct _Message
{
  int id;
  char name[64];
  GdkRectangle str_rect;

  int start_x;
  int start_y;
  int start_node_id;

  int end_x;
  int end_y;
  int end_node_id;

  int select_mode;
};
  
struct _MessageDialog
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *hbox2;
  GtkWidget *entry;
  
  GtkWidget *ok_button;
  GtkWidget *apply_button;
  GtkWidget *close_button;

  int i;
};

void sq_message_init(int i);
void sq_message_init_all();
void sq_message_init_selection();

void sq_message_add_start(int i, int id,
			  int start_node_id, int start_x, int start_y);
gint sq_message_add_end(int i, int end_node_id, int end_x);
void sq_message_extend_start(int dx, int i);
void sq_message_extend_end(int dx, int i);

void sq_message_move(int dy, int i);
void sq_message_copy(int dst, int src);

void sq_message_draw(GdkPixmap *pixmap, GdkGC *gc, Message *m_ptr);
void sq_message_draw2(GdkPixmap *pixmap, GdkGC *gc, int i);
void sq_message_draw_all();

void sq_message_load(FILE *fp);
void sq_message_save(FILE *fp);

void sq_message_dialog_open(int i);

#endif
