/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>

#include "sq_define.h"
#include "sq_recursive.h"

Recursive sqRecursive[SQ_RECURSIVE_MAX];

int sq_recursive_count;
int sq_recursive_seq;

int sq_selected_recursive;

extern GdkFont *sq_font;
extern GdkGC *sq_black_gc;
extern GdkGC *sq_white_gc;
extern GdkGC *sq_select_gc;
extern GdkPixmap *sq_pixmap;

/*
 * sq_recursive_init
 */
void sq_recursive_init(int i)
{
  sqRecursive[i].id = 0;

  sprintf(sqRecursive[i].name, "");
  
  sqRecursive[i].rect.x = 0;
  sqRecursive[i].rect.y = 0;
  sqRecursive[i].rect.width = 0;
  sqRecursive[i].rect.height = 0;

  sqRecursive[i].str_rect.x = 0;
  sqRecursive[i].str_rect.y = 0;
  sqRecursive[i].str_rect.width = 0;
  sqRecursive[i].str_rect.height = 0;

  sqRecursive[i].node_id = 0;

  sqRecursive[i].select_mode = FALSE;
}

/*
 * sq_recursive_init_all
 */
void sq_recursive_init_all()
{
  int i;

  for(i=0; i<SQ_RECURSIVE_MAX; i++)
    sq_recursive_init(i);
}

/*
 * sq_recursive_init_selection
 */
void sq_recursive_init_selection()
{
  int i;

  for(i=0; i<sq_recursive_count; i++)
    sqRecursive[i].select_mode = FALSE;
}

/*
 * sq_recursive_add
 */
void sq_recursive_new(int i, int j, int x, int y, int node_id)
{
  sqRecursive[i].id = j;

  sqRecursive[i].rect.x = x;
  sqRecursive[i].rect.y = y;
  sqRecursive[i].rect.width = 25;
  sqRecursive[i].rect.height = 25;
  
  sqRecursive[i].str_rect.x = 0;
  sqRecursive[i].str_rect.y = 0;
  sqRecursive[i].str_rect.width = 0;
  sqRecursive[i].str_rect.height = 0;
  
  sprintf(sqRecursive[i].name,"");
  
  sqRecursive[i].node_id = node_id;
}

/*
 * sq_recursive_copy
 */
void sq_recursive_copy(int dst, int src)
{
  sqRecursive[dst].id = sqRecursive[src].id;

  sprintf(sqRecursive[dst].name, "%s", sqRecursive[src].name);
  
  sqRecursive[dst].rect.x = sqRecursive[src].rect.x;
  sqRecursive[dst].rect.y = sqRecursive[src].rect.y;
  sqRecursive[dst].rect.width = sqRecursive[src].rect.width;
  sqRecursive[dst].rect.height = sqRecursive[src].rect.height;

  sqRecursive[dst].str_rect.x = sqRecursive[src].str_rect.x;
  sqRecursive[dst].str_rect.y = sqRecursive[src].str_rect.y;
  sqRecursive[dst].str_rect.width = sqRecursive[src].str_rect.width;
  sqRecursive[dst].str_rect.height = sqRecursive[src].str_rect.height;

  sqRecursive[dst].node_id = sqRecursive[src].node_id;

  sqRecursive[dst].select_mode = sqRecursive[src].select_mode;
}

/*
 * sq_recursive_draw
 */
void sq_recursive_draw(GdkPixmap *pixmap, GdkGC *gc, int i)
{
  gdk_draw_arc(pixmap, gc, FALSE,
	       sqRecursive[i].rect.x,
	       sqRecursive[i].rect.y,
  	       sqRecursive[i].rect.width,
  	       sqRecursive[i].rect.height,
	       240*64, 270*64);

  {
    int x = sqRecursive[i].rect.x + 5;
    int y = sqRecursive[i].rect.y + 23;
      
    gdk_draw_line(pixmap, gc, x, y, x+7, y-2);
    gdk_draw_line(pixmap, gc, x, y, x+5, y+5);
  }

  if(strlen(sqRecursive[i].name) > 0) {
    gdk_draw_rectangle(pixmap, sq_white_gc, TRUE,
		       sqRecursive[i].str_rect.x,
		       sqRecursive[i].str_rect.y,
		       sqRecursive[i].str_rect.width,
		       sqRecursive[i].str_rect.height);
    
    gdk_draw_string(pixmap, sq_font, gc,
		    sqRecursive[i].str_rect.x,
		    sqRecursive[i].str_rect.y,
		    sqRecursive[i].name);
  }

}

/*
 * sq_recursive_erase
 */
void sq_recursive_erase(GdkPixmap *pixmap, int i)
{

  gdk_draw_rectangle(pixmap, sq_white_gc, TRUE,
		     sqRecursive[i].rect.x,
		     sqRecursive[i].rect.y,
		     sqRecursive[i].rect.width,
		     sqRecursive[i].rect.height);

  if(strlen(sqRecursive[i].name) > 0) {
    gdk_draw_rectangle(pixmap, sq_white_gc, TRUE,
		       sqRecursive[i].str_rect.x,
		       sqRecursive[i].str_rect.y,
		       sqRecursive[i].str_rect.width,
		       sqRecursive[i].str_rect.height);
  }
}

/*
 * sq_recursive_draw_all
 */
void sq_recursive_draw_all()
{
  int i;

  for(i=0; i<sq_recursive_count; i++)
    sq_recursive_draw(sq_pixmap, sq_black_gc, i);
}

/*
 * sq_recursive_move_h
 */
void sq_recursive_move_h(int dx, int i)
{
  sqRecursive[i].rect.x += dx;
  sq_util_set_recursive_str_rect(&sqRecursive[i]);
}

/*
 * sq_recursive_move_v
 */
void sq_recursive_move_v(int dy, int i)
{
  sqRecursive[i].rect.y += dy;
  sq_util_set_recursive_str_rect(&sqRecursive[i]);
}

/*
 * sq_recursive_load
 */
void sq_recursive_load(FILE *fp)
{
  char line[BUFSIZ];
  int count, seq;
  int i, dummy;
  char str[4], flg[4];

  fgets(line, BUFSIZ, fp);
  sscanf(line, "%s %d %d", str, &count, &seq);

  sq_recursive_count = count;
  sq_recursive_seq = seq;

  for(i=0; i<count; i++){
    fgets(line, BUFSIZ, fp);
    sscanf(line, "%s %d %s %d %d %d %d %d %d %d %d %d %d",
	   flg, &sqRecursive[i].id, sqRecursive[i].name,
	   &sqRecursive[i].rect.x,
	   &sqRecursive[i].rect.y,
	   &sqRecursive[i].rect.width,
	   &sqRecursive[i].rect.height,
	   &sqRecursive[i].str_rect.x,
	   &sqRecursive[i].str_rect.y,
	   &sqRecursive[i].str_rect.width,
	   &sqRecursive[i].str_rect.height,
	   &sqRecursive[i].node_id,
	   &sqRecursive[i].select_mode);

    if(!strcmp(sqRecursive[i].name,"None"))
      sprintf(sqRecursive[i].name, "");
    
    sqRecursive[i].select_mode = FALSE;
  }
}

/*
 * sq_recursive_save
 */
void sq_recursive_save(FILE *fp)
{
  int i;

  fprintf(fp, "RC! %d %d\n", sq_recursive_count, sq_recursive_seq);

  for(i=0; i<sq_recursive_count; i++){
    fprintf(fp, "rc: %d", sqRecursive[i].id);

    if(strlen(sqRecursive[i].name) > 0)
      fprintf(fp, " %s", sqRecursive[i].name);
    else
      fprintf(fp, " None");

    fprintf(fp, " %d %d %d %d",
	    sqRecursive[i].rect.x,
	    sqRecursive[i].rect.y,
	    sqRecursive[i].rect.width,
	    sqRecursive[i].rect.height);

    fprintf(fp, " %d %d %d %d",
	    sqRecursive[i].str_rect.x,
	    sqRecursive[i].str_rect.y,
	    sqRecursive[i].str_rect.width,
	    sqRecursive[i].str_rect.height);

    fprintf(fp, " %d", sqRecursive[i].node_id);
    fprintf(fp, " %d", sqRecursive[i].select_mode);
    fprintf(fp, "\n");
  }
}
    
void sq_recursive_dialog_new(RecursiveDialog *rd)
{
  rd->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal((GtkWindow*)rd->window, TRUE);
  gtk_container_border_width(GTK_CONTAINER(rd->window), 10);
  gtk_signal_connect(GTK_OBJECT(rd->window), "destroy",
		     NULL, NULL);
		     //		     (GtkSignalFunc)gtk_main_quit, NULL);

  gtk_widget_show(rd->window);

  rd->vbox = gtk_vbox_new(FALSE, 5);
  rd->hbox = gtk_hbox_new(FALSE, 5);
  rd->hbox2 = gtk_hbox_new(FALSE, 5);

  rd->entry = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(rd->entry), 20);

  gtk_box_pack_start(GTK_BOX(rd->hbox), rd->entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(rd->vbox), rd->hbox, FALSE, TRUE, 0);

  rd->ok_button = gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(rd->hbox2), rd->ok_button, TRUE, TRUE, 0);
  rd->apply_button = gtk_button_new_with_label("Apply");
  gtk_box_pack_start(GTK_BOX(rd->hbox2), rd->apply_button, TRUE, TRUE, 0);
  rd->close_button = gtk_button_new_with_label("Close");
  gtk_box_pack_start(GTK_BOX(rd->hbox2), rd->close_button, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(rd->vbox), rd->hbox2, FALSE, TRUE, 0);
  gtk_container_add(GTK_CONTAINER(rd->window), rd->vbox);

  gtk_widget_show_all(rd->vbox);
}

/*
 * sq_recursive_dialog_apply_button
 */
void sq_recursive_dialog_apply_button(GtkWidget *widget, RecursiveDialog *rd)
{
  gchar *str = gtk_entry_get_text((GtkEntry*)rd->entry);

  sq_recursive_draw(sq_pixmap, sq_white_gc, rd->i);

  sprintf(sqRecursive[rd->i].name, "%s", str);
  sq_util_set_recursive_str_rect(&sqRecursive[rd->i]);

  sq_recursive_draw(sq_pixmap, sq_black_gc, rd->i);

  sq_drawing_area_update_all();
}

/*
 * sq_recursive_dialog_close_button
 */
void sq_recursive_dialog_close_button(GtkWidget *widget, RecursiveDialog *rd)
{
  gtk_widget_destroy(rd->window);
}

/*
 * sq_recursive_dialog_ok_button
 */
void sq_recursive_dialog_ok_button(GtkWidget *widget, RecursiveDialog *rd)
{
  sq_recursive_dialog_apply_button(widget, rd);
  sq_recursive_dialog_close_button(widget, rd);
}

/*
 * sq_recursive_dialog_set_signal
 */
void sq_recursive_dialog_set_signal(RecursiveDialog *rd)
{
  gtk_signal_connect (GTK_OBJECT (rd->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (sq_recursive_dialog_ok_button),
		      (gpointer)rd);

  gtk_signal_connect (GTK_OBJECT (rd->apply_button), "clicked",
		      GTK_SIGNAL_FUNC (sq_recursive_dialog_apply_button),
		      (gpointer)rd);
  
  gtk_signal_connect (GTK_OBJECT (rd->close_button), "clicked",
		      GTK_SIGNAL_FUNC (sq_recursive_dialog_close_button),
		      (gpointer)rd);
}

/*
 * sq_recursive_dialog_open
 */
void sq_recursive_dialog_open(int i)
{
  RecursiveDialog rd;

  rd.i = i;

  sq_recursive_dialog_new(&rd);
  gtk_entry_set_text((GtkEntry*)rd.entry, sqRecursive[i].name);
  sq_recursive_dialog_set_signal(&rd);

  gtk_main();
}
    
