/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef SQ_RECURSIVE_H
#define SQ_RECURSIVE_H

#include <gtk/gtk.h>

typedef struct _Recursive Recursive;
typedef struct _RecursiveDialog RecursiveDialog;

/*
 * Recursive
 */
struct _Recursive
{
  int id;
  char name[64];
  GdkRectangle rect;
  GdkRectangle str_rect;

  int node_id;

  int select_mode;
};

struct _RecursiveDialog
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *hbox2;
  GtkWidget *entry;
  
  GtkWidget *ok_button;
  GtkWidget *apply_button;
  GtkWidget *close_button;

  int i;
};

void sq_recursive_init(int i);
void sq_recursive_init_all();
void sq_recursive_init_selection();

void sq_recursive_new(int i, int j, int x, int y, int node_id);
void sq_recursive_move_h(int dx, int i);
void sq_recursive_move_v(int dy, int i);

void sq_recursive_copy(int dst, int src);

void sq_recursive_draw(GdkPixmap *pixmap, GdkGC *gc, int i);
void sq_recursive_erase(GdkPixmap *pixmap, int i);
void sq_recursive_draw_all();

void sq_recursive_load(FILE *fp);
void sq_recursive_save(FILE *fp);

void sq_recursive_dialog_open(int i);

#endif
