/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "sq_scrolled_window.h"

void sq_scrolled_window_new(GtkWidget *sq_drawing_area, GtkWidget *vbox)
{
  GtkWidget *sq_scrolled_window;

  sq_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (sq_scrolled_window);
  gtk_container_set_border_width (GTK_CONTAINER (sq_scrolled_window), 10);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sq_scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  gtk_scrolled_window_add_with_viewport
    (GTK_SCROLLED_WINDOW (sq_scrolled_window), sq_drawing_area);

  gtk_box_pack_start (GTK_BOX(vbox), sq_scrolled_window, TRUE, TRUE, 0);
};

