/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "sq_commands.h"
#include "sq_toolbar.h"

#include "pixmaps/select.xpm"
#include "pixmaps/lifeline.xpm"
#include "pixmaps/message.xpm"
#include "pixmaps/recursive.xpm"

SqToolbarItem sq_toolbar_item[] =
{
  { "Select",   select_xpm,   sq_mode_select },
  { "Lifeline", lifeline_xpm, sq_mode_lifeline },
  { "Message",  message_xpm,  sq_mode_message },
  { "Recursive",  recursive_xpm,  sq_mode_recursive },
  { NULL,       NULL,         NULL }
};

/*
 * sq_radio_buttons_new (local)
 */
void sq_radio_buttons_new(GtkWidget *window, GtkWidget *toolbar)
{
  GSList *group = NULL;
  GtkWidget *button;
  GtkWidget *gtk_pixmap;
  GdkPixmap *gdk_pixmap;
  GdkBitmap *gtk_mask;

  int i = 0;

  while(sq_toolbar_item[i].tooltips != NULL){
    if(strcmp(sq_toolbar_item[i].tooltips, "_SPACE_") == 0){
      gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
      i++;
      continue;
    }

    gdk_pixmap =
      gdk_pixmap_create_from_xpm_d(window->window,
				   &gtk_mask,
				   &window->style->bg[GTK_STATE_NORMAL],
				   sq_toolbar_item[i].xpm);

    gtk_pixmap = gtk_pixmap_new(gdk_pixmap, gtk_mask);

    button = gtk_radio_button_new(group);
    group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(button), FALSE);

    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(sq_toolbar_item[i].func),
		       NULL);

    gtk_container_add(GTK_CONTAINER(button), gtk_pixmap);

    gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar),
			      GTK_WIDGET(button),
			      sq_toolbar_item[i].tooltips,
			      NULL);

    gtk_widget_show(GTK_WIDGET(button));
    gtk_widget_show(GTK_WIDGET(gtk_pixmap));

    i++;
  }
}

/*
 * sq_toolbar_new (global)
 */
void sq_toolbar_new(GtkWidget *window, GtkWidget *vbox)
{
  GtkWidget *toolbar;
  GtkWidget *handle;

  handle = gtk_handle_box_new();

  toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);

  gtk_widget_show(GTK_WIDGET(toolbar));

  sq_radio_buttons_new(window, toolbar);

  gtk_container_add(GTK_CONTAINER(handle), GTK_WIDGET(toolbar));
  gtk_box_pack_start(GTK_BOX(vbox), handle, FALSE, FALSE, 0);
  gtk_widget_show(handle);
}
