/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <math.h>

#include "sq_define.h"
#include "sq_util.h"
#include "sq_lifeline.h"
#include "sq_io.h"

extern int sq_lifeline_count;
extern int sq_lifeline_seq;
extern int sq_selected_lifeline;

extern int sq_message_count;
extern int sq_message_seq;
extern int sq_selected_message;

extern int sq_recursive_count;
extern int sq_recursive_seq;
extern int sq_selected_recursive;

extern IoDialog iod;

GdkFont *sq_font;
GdkGC *sq_white_gc;
GdkGC *sq_black_gc;
GdkGC *sq_select_gc;
GdkGC *sq_erase_gc;

extern Lifeline sqLifeline[SQ_LIFELINE_MAX];
extern Recursive sqRecursive[SQ_RECURSIVE_MAX];

/*
 * sq_util_counter_init
 */
void sq_util_counters_init()
{
  sq_lifeline_count = 0;
  sq_lifeline_seq = 0;
  sq_selected_lifeline = 9999;

  sq_message_count = 0;
  sq_message_seq = 0;
  sq_selected_message = 9999;

  sq_recursive_count = 0;
  sq_recursive_seq = 0;
  sq_selected_recursive = 9999;

  iod.seq = 0;
}

/*
 * sq_util_gc_init
 */
void sq_util_gc_init(GtkWidget *window)
{
  GdkColor color;

  sq_font = gdk_fontset_load
    ("-adobe-helvetica-medium-r-normal--12-110-*-*-*-*-iso8859*,
      -kaname-fixed-medium-r-normal--12-100-*-*-*-*-*");

  sq_white_gc = window->style->white_gc;
  sq_black_gc = window->style->black_gc;

  sq_select_gc = gdk_gc_new(window->window);
  gdk_gc_set_line_attributes
    (sq_select_gc, 1, GDK_LINE_ON_OFF_DASH, GDK_CAP_ROUND, GDK_JOIN_ROUND);

  color.red = 0xffff;
  color.green = 0xffff;
  color.blue = 0xffff;
  gdk_color_alloc(gdk_colormap_get_system(),&color);
  sq_erase_gc = gdk_gc_new(window->window);
  gdk_gc_set_foreground(sq_erase_gc, &color);
  gdk_gc_set_line_attributes
    (sq_erase_gc, 2, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_ROUND);
}  

/*
 * sq_util_init_all
 */
void sq_util_init_all()
{
  sq_lifeline_init_all();
  sq_message_init_all();
  sq_recursive_init_all();
}

/*
 * sq_util_select_rect
 */
gint sq_util_select_rect(GdkRectangle *rect, int x, int y)
{
  int x1, x2, y1, y2;
  
  x1 = rect->x;
  x2 = x1 + rect->width;
  y1 = rect->y;
  y2 = y1 + rect->height;

  if( x1<x && x<x2 && y1<y && y<y2 )
    return TRUE;

  return FALSE;
}

/*
 * sq_util_select_line_v
 */
gint sq_util_select_line_v(GdkRectangle *rect, int x, int y)
{
  int x1, x2, y1, y2;
  
  x1 = rect->x - 5;
  x2 = rect->x + 5;
  y1 = rect->y;
  y2 = y1 + rect->height;

  if( x1<x && x<x2 && y1<y && y<y2 )
    return TRUE;

  return FALSE;
}

/*
 * sq_util_select_line_h
 */
gint sq_util_select_line_h(int start_x, int end_x, int yy, int x, int y)
{
  int x1, x2, y1, y2;
  
  if(start_x < end_x){
    x1 = start_x;
    x2 = end_x;
  }else{
    x2 = start_x;
    x1 = end_x;
  }

  y1 = yy - 5;
  y2 = yy + 5;

  if( x1<x && x<x2 && y1<y && y<y2 )
    return TRUE;

  return FALSE;
}

/*
 * sq_util_get_lifeline_geometry
 */
int sq_util_set_lifeline_geometry(Lifeline *l_ptr)
{
  int lastX = l_ptr->rect.x; 

  int str_width = gdk_string_width(sq_font, l_ptr->name);
  int str_height = gdk_string_height(sq_font, l_ptr->name);

  l_ptr->object_rect.width = str_width + 20;
  l_ptr->object_rect.height = str_height + 20;

  l_ptr->rect.x = l_ptr->object_rect.x + l_ptr->object_rect.width/2;
  l_ptr->rect.y = l_ptr->object_rect.y + l_ptr->object_rect.height;
  l_ptr->rect.width = 0; 
  l_ptr->rect.height = 300; 

  l_ptr->name_point.x = l_ptr->object_rect.x + 10; 
  l_ptr->name_point.y = l_ptr->object_rect.y + str_height + 10;

  return(l_ptr->rect.x - lastX);
}  

/*
 * sq_util_set_message_str_rect
 */
void sq_util_set_message_str_rect(Message *m_ptr)
{
  int x,y,w,h,l;

  w = gdk_string_width(sq_font, m_ptr->name);
  h = gdk_string_height(sq_font, m_ptr->name);
  l = abs(m_ptr->start_x-m_ptr->end_x);

  if(m_ptr->start_x < m_ptr->end_x)
    x = m_ptr->start_x + 10;
  else
    x = m_ptr->start_x - w - 10;
    
  y = m_ptr->start_y - h;

  m_ptr->str_rect.x = x;
  m_ptr->str_rect.y = y;
  m_ptr->str_rect.width = w;
  m_ptr->str_rect.height = h;
}

/*
 * sq_util_set_recursive_str_rect
 */
void sq_util_set_recursive_str_rect(Recursive *r_ptr)
{
  r_ptr->str_rect.x = r_ptr->rect.x + 30;
  r_ptr->str_rect.y = r_ptr->rect.y + 15;
  r_ptr->str_rect.width = gdk_string_width(sq_font, r_ptr->name);
  r_ptr->str_rect.height = gdk_string_height(sq_font, r_ptr->name);
}

/*
 * sq_util_load_hear
 */
int sq_util_load_header(FILE *fp)
{
  char line[BUFSIZ];

  fgets(line, BUFSIZ, fp);
  if(strcmp(line,AU_LINE)){
    printf("Invalid File\n");
    return FALSE;
  }
  fgets(line, BUFSIZ, fp);
  if(strcmp(line,HD_LINE)){
    printf("Invalid File\n");
    return FALSE;
  }
  fgets(line, BUFSIZ, fp);
  if(strcmp(line,AU_LINE)){
    printf("Invalid File\n");
    return FALSE;
  }

  return TRUE;
}
  

/*
 * sq_util_save_header
 */
void sq_util_save_header(FILE *fp)
{
  fprintf(fp, AU_LINE);
  fprintf(fp, HD_LINE);
  fprintf(fp, AU_LINE);
}	  

/*
 * sq_util_draw_all
 */
void sq_util_draw_all()
{
  sq_recursive_draw_all();
  sq_message_draw_all();
  sq_lifeline_draw_all();
}
    
/*
 * sq_util_get_effective_rect
 */
gint sq_util_get_effective_rect(GdkRectangle *rect)
{
  int i;
  int x = SQ_PICTURE_WIDTH;
  int y = SQ_PICTURE_HEIGHT;
  int w = 0;
  int h = 0;

  if(sq_lifeline_count == 0)
    return FALSE;

  for(i=0; i<sq_lifeline_count; i++){
    if(x > sqLifeline[i].object_rect.x)
      x = sqLifeline[i].object_rect.x;
    if(y > sqLifeline[i].object_rect.y)
      y = sqLifeline[i].object_rect.y; 
    if(w < (sqLifeline[i].object_rect.x + sqLifeline[i].object_rect.width))
      w = sqLifeline[i].object_rect.x + sqLifeline[i].object_rect.width;
    if(h < (sqLifeline[i].rect.y + sqLifeline[i].rect.height))
      h = sqLifeline[i].rect.y + sqLifeline[i].rect.height;
  }

  for(i=0; i<sq_recursive_count; i++){
    if(w < (sqRecursive[i].str_rect.x + sqRecursive[i].str_rect.width))
      w = sqRecursive[i].str_rect.x + sqRecursive[i].str_rect.width;
  }

  rect->x = x-10;
  rect->y = y-10;
  rect->width = w+25-x;
  rect->height = h+30-y;

  return TRUE;
}

