/* sqedit -- sequence diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef SQ_UTIL_H
#define SQ_UTIL_H

#include <stdio.h>

#include <gtk/gtk.h>
#include "sq_lifeline.h"
#include "sq_message.h"
#include "sq_recursive.h"

void sq_util_counters_init();
void sq_util_gc_init(GtkWidget *window);
void sq_util_init_all();

gint sq_util_select_rect(GdkRectangle *rect, int x, int y);
gint sq_util_select_line_v(GdkRectangle *rect, int x, int y);
gint sq_util_select_line_h(int start_x, int end_x, int yy, int x, int y);

int sq_util_set_lifeline_geometry(Lifeline *l_ptr);
void sq_util_set_message_str_rect(Message *m_ptr);
void sq_util_set_recursive_str_rect(Recursive *r_ptr);

int sq_util_load_header(FILE *fp);
void sq_util_save_header(FILE *fp);

void sq_util_draw_all();

gint sq_util_get_effective_rect(GdkRectangle *rect);

#endif

  
