/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <gdk_imlib.h>

#include "cd_define.h"
#include "cd_io.h"

IoDialog iod;

extern GdkPixmap *cd_pixmap;

/*
 * cd_io_filename_init
 */
void cd_io_filename_init()
{
  if(iod.cd_filename){
    g_free(iod.cd_filename);
    iod.cd_filename = NULL;
  }
}

/*
 * cd_io_load
 */
int cd_io_load()
{
  FILE *fp;

  if(!iod.cd_filename){
    cd_util_message(ERR_CANNOT_GET_FILE);
    return FALSE;
  }
    
  if((fp = fopen(iod.cd_filename, "r")) == NULL) {
    cd_util_message(ERR_CANNOT_OPEN_FILE);
    return FALSE;
  }
  
  if(!cd_util_load_header(fp)){
    cd_util_message(ERR_INVALID_HEADER);
    return FALSE;
  }

  cd_canvas_load(fp);
  cd_node_load(fp);
  cd_arc_load(fp);

  fclose(fp);

  return TRUE;
}

/*
 * cd_io_save
 */
void cd_io_save()
{
  FILE *fp;
  char mes[64];

  if(!iod.cd_filename){
    cd_util_message(ERR_CANNOT_GET_FILE);
    return;
  }

  if((fp = fopen(iod.cd_filename, "w")) == NULL){
    cd_util_message(ERR_CANNOT_OPEN_FILE);
    g_free(iod.cd_filename);
    iod.cd_filename = NULL;
    return;
  }

  cd_util_save_header(fp);
  cd_canvas_save(fp);
  cd_node_save(fp);
  cd_arc_save(fp);

  fclose(fp);
}

/*
 * cd_io_export
 */
void cd_io_export(ExType type)
{
  FILE *fp;
  GdkRectangle rect;
  GdkImlibImage *im;

  char mes[64];
  int res;

  gchar *export_filename;
  
  if(!iod.cd_filename){
    cd_util_message(ERR_CANNOT_GET_FILE);
    return;
  }

  export_filename = g_strdup(iod.cd_filename);
  strtok(export_filename, ".");

  switch(type){
  case JPG:
    strcat(export_filename, ".jpg");
    break;
  case EPS:
    strcat(export_filename, ".eps");
    break;
  }

  if((fp = fopen(export_filename, "w")) == NULL) {
    cd_util_message(ERR_CANNOT_OPEN_FILE);
    return;
  }

  if(!cd_control_calc_effective_rect(&rect)){
    cd_util_message(ERR_CANNOT_SAVE_IMAGE);
    return;
  }

  im = gdk_imlib_create_image_from_drawable((GdkWindow*)cd_pixmap, 
					    NULL,
					    rect.x, rect.y,
					    rect.width, rect.height);

  res = gdk_imlib_save_image(im, export_filename, NULL);

  if(!res)
    cd_util_message(ERR_CANNOT_SAVE_IMAGE);

  fclose(fp);
}

/*
 * cd_io_dialog_ok_button_save
 */
void cd_io_dialog_ok_button_save(GtkWidget *widget, GtkFileSelection *fs)
{
  if(iod.cd_filename)
    free(iod.cd_filename);

  iod.cd_filename =
    (gchar*)strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));

  gtk_widget_destroy(GTK_WIDGET(fs));

  gtk_main_quit();
}

/*
 * cd_io_dialog_ok_button_load
 */
void cd_io_dialog_ok_button_load(GtkWidget *widget, GtkFileSelection *fs)
{
  gchar *test;
  FILE *fp;

  test =
    (gchar*)strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));

  fp = fopen(test, "r");
  if(fp == NULL)
    iod.res = FALSE;
  else {
    if(iod.cd_filename)
      free(iod.cd_filename);

    iod.cd_filename = (gchar*)strdup(test);
    fclose(fp);
  }
    
  g_free(test);

  gtk_widget_destroy(GTK_WIDGET(fs));

  gtk_main_quit();
}

/*
 * cd_io_dialog_open
 */
gboolean cd_io_dialog_open(IoType type)
{
  iod.res = TRUE;
  iod.window = gtk_file_selection_new(NULL);

  gtk_signal_connect(GTK_OBJECT(iod.window), "destroy",
		     (GtkSignalFunc)gtk_widget_destroy,
		     iod.window);

  switch(type){
  case io_save:
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(iod.window)->ok_button),
		       "clicked", (GtkSignalFunc)cd_io_dialog_ok_button_save,
		       iod.window);
    break;
  case io_load:
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(iod.window)->ok_button),
		       "clicked", (GtkSignalFunc)cd_io_dialog_ok_button_load,
		       iod.window);
    break;
  }

  gtk_signal_connect_object
    (GTK_OBJECT(GTK_FILE_SELECTION(iod.window)->cancel_button),
     "clicked", (GtkSignalFunc)gtk_widget_destroy,
     GTK_OBJECT(iod.window));

  gtk_file_selection_set_filename
    (GTK_FILE_SELECTION(iod.window), CD_IO_FILENAME);

  gtk_widget_show(iod.window);

  gtk_window_set_modal((GtkWindow*)iod.window, TRUE);

  gtk_main();

  return iod.res;
}
