/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "libpq-fe.h"
#include "cd_pg_app_panel.h"
#include "cd_define.h"

/*
 * cd_pg_app_select_submit
 */
void cd_pg_app_select_submit(GtkWidget *widget, PgSelectData *sd)
{
  cd_pg_util_select_table(sd);
}

/*
 * cd_pg_app_select_gtk
 */
void cd_pg_app_select_gtk(GtkWidget *widget, PgDialog *pd)
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *scrolled_win;
  GtkWidget *clist;

  GtkWidget *hbox;
  GtkWidget *select_button;
  GtkWidget *close_button;

  PgSelectData sd;
  
  int attr_len;

  attr_len = g_list_length(pd->ni->attributes);
  if(attr_len <= 0){
    cd_util_message(ERR_TABLE);
    return;
  }

  sd.pd = pd;

  /* window */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_widget_set_usize(window, 400, 300);
  gtk_window_set_modal((GtkWindow*)window, TRUE);
  gtk_container_border_width (GTK_CONTAINER (window), 10);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", NULL, NULL);

  /* vbox */
  vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  /* scrolled_win */
  scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (vbox), scrolled_win, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_win);

  /* clist */
  {
    int i;
    gchar* titles[attr_len];
    PgAttribute *attr;

    for(i=0; i<attr_len; i++){
      attr = g_list_nth_data(pd->ni->attributes, i);
      titles[i] = attr->name;
    }

    sd.clist = clist = gtk_clist_new_with_titles(attr_len, titles);
    gtk_scrolled_window_add_with_viewport
      (GTK_SCROLLED_WINDOW (scrolled_win), clist);
  }

  hbox = gtk_hbox_new(FALSE, 5);

  select_button = gtk_button_new_with_label(LABEL_SUBMIT);
  gtk_box_pack_start (GTK_BOX (hbox), select_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (select_button), "clicked",
		      (GtkSignalFunc)cd_pg_app_select_submit,
		      (gpointer)&sd);

  close_button = gtk_button_new_with_label(LABEL_CLOSE);
  gtk_box_pack_start (GTK_BOX (hbox), close_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
		      (GtkSignalFunc)gtk_main_quit,
		      (gpointer)pd);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);

  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_widget_show_all(vbox);
  gtk_widget_show(window);

  gtk_main();

  gtk_widget_destroy(window);
}

/*
 * cd_pg_app_insert_submit
 */
void cd_pg_app_insert_submit(GtkWidget *widget, PgInsertData *id)
{
  cd_pg_util_insert_tuple(id);
}

/*
 * cd_pg_app_insert_gtk
 */
void cd_pg_app_insert_gtk(GtkWidget *widget, PgDialog *pd)
{
  PgInsertData id;

  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *table;

  GtkWidget *hbox;
  GtkWidget *submit_button;
  GtkWidget *close_button;
  
  int attr_len;

  attr_len = g_list_length(pd->ni->attributes);
  if(attr_len <= 0){
    cd_util_message(ERR_TABLE);
    return;
  }

  id.pd = pd;
  id.list = NULL;

  /* window */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_window_set_modal((GtkWindow*)window, TRUE);
  gtk_container_border_width (GTK_CONTAINER (window), 10);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", NULL, NULL);

  /* vbox */
  vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  /* entrys with */
  {
    int i;
    PgAttribute *attr;
    GtkWidget *labels[attr_len];
    GtkWidget *entrys[attr_len];
    
    table = gtk_table_new(attr_len, 2, TRUE);

    for(i=0; i<attr_len; i++){
      attr = g_list_nth_data(pd->ni->attributes, i);
      labels[i] = gtk_label_new(attr->name);
      gtk_table_attach_defaults(GTK_TABLE(table),
				labels[i], 0, 1, i, i+1);
      gtk_widget_show(labels[i]);
      entrys[i] = gtk_entry_new();
      gtk_table_attach_defaults(GTK_TABLE(table),
				entrys[i], 1, 2, i, i+1);
      gtk_widget_show(entrys[i]);

      id.list = g_list_append(id.list, entrys[i]);
    }
  }    

  gtk_container_add(GTK_CONTAINER (vbox), table);
  gtk_widget_show(table);

  hbox = gtk_hbox_new(FALSE, 5);

  submit_button = gtk_button_new_with_label(LABEL_SUBMIT);
  gtk_box_pack_start (GTK_BOX (hbox), submit_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (submit_button), "clicked",
		      (GtkSignalFunc)cd_pg_app_insert_submit,
		      (gpointer)&id);

  close_button = gtk_button_new_with_label(LABEL_CLOSE);
  gtk_box_pack_start (GTK_BOX (hbox), close_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
		      (GtkSignalFunc)gtk_main_quit,
		      (gpointer)pd);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_widget_show_all(vbox);
  gtk_widget_show(window);

  gtk_main();

  gtk_widget_destroy(window);
}

/*
 * cd_pg_app_where_gtk
 */
void cd_pg_app_where_gtk(GtkWidget *widget, PgDialog *pd)
{
  //g_print("cd_pg_app_where_gtk\n"); //debug
}

/*
 * cd_pg_app_panel_private_new
 */
void cd_pg_app_panel_private_new(PgDialog *pd)
{
  GtkWidget *frame;
  GtkWidget *vbox;
  int i;
  char *name[] = { LABEL_SELECT, LABEL_INSERT, LABEL_UPDATE };
  void *func[] = {
    cd_pg_app_select_gtk, cd_pg_app_insert_gtk, cd_pg_app_where_gtk
  };

  frame = gtk_frame_new (LABEL_PRIVATE);
  gtk_box_pack_start (GTK_BOX (pd->ap.vbox), frame, TRUE, TRUE, 0);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  for(i=0; i<3; i++){
    pd->ap.pri_name[i] = gtk_button_new_with_label(name[i]);
    gtk_signal_connect(GTK_OBJECT(pd->ap.pri_name[i]), "clicked",
		       (GtkSignalFunc)func[i],
		       (gpointer)pd);

    gtk_box_pack_start (GTK_BOX (vbox),
			pd->ap.pri_name[i], TRUE, TRUE, 2);
    gtk_widget_show(pd->ap.pri_name[i]);
  }

  // callback not implemented ... au
  gtk_widget_set_sensitive(pd->ap.pri_name[2], FALSE);
}

/*
 * cd_pg_app_generate_php
 */
void cd_pg_app_generate_php(GtkWidget *widget, PgDialog *pd)
{
  cd_php_generate(pd);
}

/*
 * cd_pg_app_export_db
 */
void cd_pg_app_export_db(GtkWidget *widget, PgDialog *pd)
{
  cd_pg_util_export_db(pd);
}

/*
 * cd_pg_app_panel_public_new
 */
void cd_pg_app_panel_public_new(PgDialog *pd)
{
  GtkWidget *frame;
  GtkWidget *vbox;

  frame = gtk_frame_new (LABEL_PUBLIC);
  gtk_box_pack_start (GTK_BOX (pd->ap.vbox), frame, TRUE, TRUE, 0);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  pd->ap.pub_hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX (vbox), pd->ap.pub_hbox, TRUE, TRUE, 5);
		     
  pd->ap.pub_label = gtk_label_new(LABEL_TARGET);
  gtk_box_pack_start (GTK_BOX (pd->ap.pub_hbox),
		      pd->ap.pub_label, FALSE, FALSE, 0);

  pd->ap.pub_entry = gtk_entry_new();
  gtk_entry_set_text((GtkEntry*)pd->ap.pub_entry, PG_APP_PANEL_TARGET_VALUE); 
  gtk_box_pack_start (GTK_BOX (pd->ap.pub_hbox),
		      pd->ap.pub_entry, FALSE, FALSE, 0);

  pd->ap.pub_gen_button = gtk_button_new_with_label(LABEL_GEN_WAPP);
  gtk_box_pack_start(GTK_BOX (vbox), pd->ap.pub_gen_button, TRUE, TRUE, 2);
  gtk_signal_connect(GTK_OBJECT(pd->ap.pub_gen_button), "clicked",
		     (GtkSignalFunc)cd_pg_app_generate_php,
		     (gpointer)pd);

  pd->ap.pub_ex_button = gtk_button_new_with_label(LABEL_EXDB);
  gtk_box_pack_start(GTK_BOX (vbox), pd->ap.pub_ex_button, TRUE, TRUE, 3);
  gtk_signal_connect(GTK_OBJECT(pd->ap.pub_ex_button), "clicked",
		     (GtkSignalFunc)cd_pg_app_export_db,
		     (gpointer)pd);
}

/*
 * cd_pg_app_panel_new
 */
void cd_pg_app_panel_new(PgDialog *pd)
{
  pd->ap.vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (pd->ap.vbox), 10);
  pd->ap.label = gtk_label_new (LABEL_APP);
  gtk_notebook_insert_page (GTK_NOTEBOOK (pd->notebook),
			    pd->ap.vbox, pd->ap.label, 2);

  cd_pg_app_panel_private_new(pd);  
  cd_pg_app_panel_public_new(pd);  
}
