/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef CD_PG_DIALOG_H
#define CD_PG_DIALOG_H

#include <gtk/gtk.h>

#include "cd_define.h"
#include "cd_node.h"

typedef struct _PgDialog       PgDialog;
typedef struct _PgTablePanel   PgTablePanel;
typedef struct _PgConnectPanel PgConnectPanel;
typedef struct _PgAppPanel     PgAppPanel;

typedef struct _PgInsertData   PgInsertData;
typedef struct _PgSelectData   PgSelectData;

struct _PgInsertData
{
  PgDialog *pd;
  GList *list;
};

struct _PgSelectData
{
  PgDialog *pd;
  GtkWidget *clist;
};

struct _PgAppPanel
{
  GtkWidget *vbox;
  GtkWidget *label;

  GtkWidget *pri_name[3];

  GtkWidget *pub_hbox;
  GtkWidget *pub_label;
  GtkWidget *pub_entry;
  GtkWidget *pub_gen_button;
  GtkWidget *pub_ex_button;
};

struct _PgConnectPanel
{
  GtkWidget *vbox;
  GtkWidget *label;

  GtkWidget *table;
  GtkWidget *labels[5];
  GtkWidget *entrys[5];
  GtkWidget *hboxs[5];

  GtkWidget *create_button;
};

struct _PgTablePanel
{
  GtkWidget *vbox;
  GtkWidget *label;

  GtkWidget *name_hbox;
  GtkWidget *name_label;
  GtkWidget *name_entry;

  GtkWidget *hbox1;
  GtkWidget *hbox2;
  GtkWidget *hbox3;
  GtkWidget *scrolled_win;
  GtkWidget *list;
  GtkWidget *list_item;
  GtkWidget *opt_vis;
  GtkWidget *opt_menu_vis;
  GtkWidget *opt_menu_item_vis;
  GtkWidget *opt_type;
  GtkWidget *opt_menu_type;
  GtkWidget *opt_menu_item_type;
  GtkWidget *entry;
  int       select;
  CdVisibility vis;
  CdPgType   type;

  GtkWidget *add_button;
  GtkWidget *apply_button;
  GtkWidget *delete_button;
  GtkWidget *up_button;
  GtkWidget *down_button;

  GtkSortType sort_type0;
  GtkSortType sort_type1;
  GtkSortType sort_type2;
};

struct _PgDialog
{
  GtkWidget *window;
  GtkWidget *notebook;
  GtkWidget *vbox;

  NodeItem *ni;
  int item_index;

  PgTablePanel tp;
  PgConnectPanel cp;
  PgAppPanel ap;

  GtkWidget *hbox;
  GtkWidget *ok_button;
  GtkWidget *apply_button;
  GtkWidget *close_button;
};

void cd_pg_dialog_open(NodeItem *ni, int i); //au ... legacy

#endif
