/*
 * ucedit.c
 */
#include <gtk/gtk.h>

#include "usecase.h"
#include "usecase_util.h"

GdkFont *g_font;
GdkGC *white_gc;
GdkGC *black_gc;
GdkGC *select_gc;
GdkGC *erase_gc;

/**
extern int usecase_node_count;
extern int usecase_node_seq;

extern int usecase_selected_node;
extern int usecase_last_selected_node;

extern int usecase_arc_count;
extern int usecase_arc_seq;
extern int usecase_last_selected_arc;
**/

/*
 * init_tenko
 */
void init_tenko(GtkWidget *widget)
{
  GdkColor color;

  g_font = gdk_fontset_load
    ("-adobe-helvetica-medium-r-normal--12-110-*-*-*-*-iso8859*,
      -kaname-fixed-medium-r-normal--12-100-*-*-*-*-*");

  white_gc = widget->style->white_gc;
  black_gc = widget->style->black_gc;

  select_gc = gdk_gc_new(widget->window);
  gdk_gc_set_line_attributes
    (select_gc, 1, GDK_LINE_ON_OFF_DASH, GDK_CAP_ROUND, GDK_JOIN_ROUND);

  color.red = 0xffff;
  color.green = 0xffff;
  color.blue = 0xffff;
  gdk_color_alloc(gdk_colormap_get_system(),&color);
  erase_gc = gdk_gc_new(widget->window);
  gdk_gc_set_foreground(erase_gc, &color);
  gdk_gc_set_line_attributes
    (erase_gc, 2, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_ROUND);

  usecase_init_counters();
}  

/*
 * make_usecase_dialog
 */
void make_usecase_dialog(GtkWidget *window)
{
  GtkWidget *label;
  GtkWidget *vbox;
  GtkWidget *drawing_area;
  GtkWidget *menubar;
  GtkWidget *toolbar;
  GtkWidget *scrolled_window;

  vbox = gtk_vbox_new(FALSE, 0);

  gtk_widget_show(vbox);
  gtk_widget_show (window);

  menubar = usecase_create_menubar(window);
  gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, FALSE, 0);
  gtk_widget_show(menubar);

  toolbar = usecase_create_toolbar(window);
  gtk_box_pack_start(GTK_BOX(vbox), toolbar, FALSE, FALSE, 0);
  gtk_widget_show(toolbar);

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolled_window);
  gtk_container_set_border_width (GTK_CONTAINER (scrolled_window), 10);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  drawing_area = usecase_create_canvas();
  gtk_widget_show(drawing_area);
  gtk_scrolled_window_add_with_viewport
    (GTK_SCROLLED_WINDOW (scrolled_window), drawing_area);

  gtk_box_pack_start (GTK_BOX(vbox), scrolled_window, TRUE, TRUE, 0);

  gtk_container_add(GTK_CONTAINER(window), vbox);
}

/*
 * main
 */
int main(int argc, char *argv[])
{
  GtkWidget *window;

  gtk_set_locale();
  gtk_init( &argc, &argv );
  gdk_imlib_init();
  gtk_rc_parse( "./gtkrc" );

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "ucedit");
  gtk_widget_set_usize(window, 800, 600);

  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		     GTK_SIGNAL_FUNC(gtk_exit), NULL);
  gtk_signal_connect(GTK_OBJECT(window), "destroy",
		     GTK_SIGNAL_FUNC(gtk_exit), NULL);

  make_usecase_dialog(window);

  gtk_widget_show (window);

  init_tenko(window);
  gtk_main();

  return 0;
}
