/*
 * usecase.c
 */
#include <gtk/gtk.h>

#include "def_tenko.h"
#include "usecase.h"

GdkPixmap *g_usecase_pixmap;
GtkWidget *g_usecase_canvas;

extern int usecase_node_count;
extern int usecase_arc_count;

extern int usecase_system_count;
extern int usecase_selected_system;
extern int usecase_last_selected_system;

extern int usecase_selected_node;
extern int usecase_last_selected_node;
extern int lastX, lastY;
extern int usecase_last_selected_arc;

extern UsecaseArcStruct usecaseArcDat[USECASE_MAX_ARC];
extern UsecaseNodeStruct usecaseNodeDat[USECASE_MAX_NODE];
extern UsecaseSystemStruct usecaseSystemDat[USECASE_MAX_SYSTEM];

static UsecaseToolbarItem g_usecase_toolbar_item[] =
{
  { "Select",   usecaseSelectPixmap,  usecase_set_select_mode },
  { "Actor",    actor,                usecase_set_actor_mode },
  { "UseCase",  usecase,              usecase_set_usecase_mode  },
  { "Arc",      arc,                  usecase_set_arc_mode  },
  { "System",   system,               usecase_set_system_mode  },
  { NULL,       NULL,                 NULL          }
};

usecase_mode g_usecase_mode;

/*
 * usecase_set_select_mode
 */
void usecase_set_select_mode()
{
  g_usecase_mode = usecase_select_enum;
}

/*
 * usecase_set_actor_mode
 */
void usecase_set_actor_mode()
{
  g_usecase_mode = usecase_actor_enum;
}

/*
 * usecase_set_usecase_mode
 */
void usecase_set_usecase_mode()
{
  g_usecase_mode = usecase_usecase_enum;
}

/*
 * usecase_set_arc_mode
 */
void usecase_set_arc_mode()
{
  g_usecase_mode = usecase_arc_enum;
}

/*
 * usecase_set_system_mode
 */
void usecase_set_system_mode()
{
  g_usecase_mode = usecase_system_enum;
}

/*
 * usecase_configure
 */
static gint usecase_configure(GtkWidget *widget, GdkEventConfigure *event)
{
  if (g_usecase_pixmap)
    gdk_pixmap_unref(g_usecase_pixmap);

  g_usecase_pixmap = gdk_pixmap_new(widget->window,
				       widget->allocation.width,
				       widget->allocation.height,
				       -1);

  gdk_draw_rectangle (g_usecase_pixmap,
		      widget->style->white_gc,
		      TRUE,
		      0, 0,
		      widget->allocation.width,
		      widget->allocation.height);

  //gtk_window_set_focus(GTK_WINDOW(g_mainWindow), g_usecase_canvas);

  return TRUE;
}

/*
 * usecase_expose
 */
gint usecase_expose(GtkWidget *widget, GdkEventExpose *event)
{
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
		  g_usecase_pixmap,
		  event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);

  //return FALSE;
  return TRUE;
}

/*
 * usecase_motion_notify
 */
gint usecase_motion_notify(GtkWidget *widget, GdkEventMotion *event)
{
  int x, y;
  GdkModifierType state;
  GdkRectangle update_rect;

  x = event->x;
  y = event->y;

  //if(usecase_selected_node == 9999)
  if(usecase_selected_node == 9999 && usecase_selected_system == 9999)
    return TRUE;

  if (event->is_hint)
    gdk_window_get_pointer(event->window, &x, &y, &state);
  else {
    x = event->x;
    y = event->y;
    state = event->state;
  }

  if(usecase_selected_node != 9999) {
    switch(g_usecase_mode){
    case usecase_select_enum:
      usecase_move(x, y, usecase_selected_node);
      break;
    }
  }

  if(usecase_selected_system != 9999) {
    switch(g_usecase_mode){
    case usecase_select_enum:
      switch(usecaseSystemDat[usecase_selected_system].select_mode){
      case usecase_select:
	usecase_mod_system(x, y, usecase_selected_system);
	break;
      case usecase_first:
      case usecase_second:
      case usecase_third:
      case usecase_forth:
	usecase_resize_system(x, y, usecase_selected_system);
	break;
      }
      
      break;
    }
  }

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = USECASE_PICTURE_WIDTH;
  update_rect.height = USECASE_PICTURE_HEIGHT;

  gtk_widget_draw(g_usecase_canvas, &update_rect);

  return TRUE;
}

/*
 * usecase_button_press
 */
gint usecase_button_press(GtkWidget *widget, GdkEventButton *event)
{
  GdkRectangle update_rect;
  int x, y;

  lastX = x = event->x;
  lastY = y = event->y;

  /* dangerous */
  if(usecase_last_selected_arc < usecase_arc_count)
    usecaseArcDat[usecase_last_selected_arc].select_mode = FALSE;
  if(usecase_last_selected_node < usecase_node_count)
    usecaseNodeDat[usecase_last_selected_node].select_mode = FALSE;
  if(usecase_last_selected_system < usecase_system_count)
    usecaseSystemDat[usecase_last_selected_system].select_mode = FALSE;

  if(event->button == 1){
    switch(g_usecase_mode){
    case usecase_select_enum:
      usecase_selection(x, y, event);
      break;
    case usecase_actor_enum:
      if(usecase_node_count < USECASE_MAX_NODE)
	usecase_add_actor(x, y);
      else
	g_print("no more actor\n");
      break;
    case usecase_usecase_enum:
      if(usecase_node_count < USECASE_MAX_NODE)
	usecase_add_usecase(x, y);
      else
	g_print("no more usecase\n");
      break;
    case usecase_arc_enum:
      if(usecase_arc_count < USECASE_MAX_ARC)
	usecase_add_arc_start(x, y);
      else
	g_print("no more arc\n");
      break;
    case usecase_system_enum:
      if(usecase_system_count < USECASE_MAX_SYSTEM)
	usecase_add_system(x, y);
      else
	g_print("no more system\n");
      break;
    }
  }

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = USECASE_PICTURE_WIDTH;
  update_rect.height = USECASE_PICTURE_HEIGHT;

  gtk_widget_draw(g_usecase_canvas, &update_rect);

  return TRUE;
}

/*
 * usecase_button_release
 */
gint usecase_button_release(GtkWidget *widget, GdkEventButton *event)
{
  GdkRectangle update_rect;
  int x, y;

  x = event->x;
  y = event->y;

  usecase_last_selected_node = usecase_selected_node;
  usecase_selected_node = 9999;
  usecase_last_selected_system = usecase_selected_system;
  usecase_selected_system = 9999;

  switch(g_usecase_mode){
  case usecase_select_enum:
    usecase_draw_refresh_all();
    break;
  case usecase_actor_enum:
  case usecase_usecase_enum:
  case usecase_system_enum:
    break;
  case usecase_arc_enum:
    if(usecase_arc_count < USECASE_MAX_ARC)
      usecase_add_arc_end(x, y);
    else
      g_print("no more arc\n");
    break;
  }

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = USECASE_PICTURE_WIDTH;
  update_rect.height = USECASE_PICTURE_HEIGHT;

  gtk_widget_draw(g_usecase_canvas, &update_rect);

  return TRUE;
}

/*
 * usecase_create_canvas
 */
GtkWidget *usecase_create_canvas(void)
{
  g_usecase_canvas  = gtk_drawing_area_new();

  gtk_drawing_area_size( GTK_DRAWING_AREA(g_usecase_canvas),
			 USECASE_PICTURE_WIDTH, USECASE_PICTURE_HEIGHT);

  gtk_signal_connect(GTK_OBJECT(g_usecase_canvas), "expose_event",
		     (GtkSignalFunc) usecase_expose, NULL);

  gtk_signal_connect(GTK_OBJECT(g_usecase_canvas), "motion_notify_event",
		     (GtkSignalFunc) usecase_motion_notify, NULL);

  gtk_signal_connect(GTK_OBJECT(g_usecase_canvas), "button_press_event",
		     (GtkSignalFunc) usecase_button_press, NULL);

  gtk_signal_connect(GTK_OBJECT(g_usecase_canvas), "button_release_event",
		     (GtkSignalFunc) usecase_button_release, NULL);

  gtk_signal_connect (GTK_OBJECT(g_usecase_canvas),"configure_event",
		      (GtkSignalFunc) usecase_configure, NULL);

  gtk_widget_set_events(g_usecase_canvas, GDK_EXPOSURE_MASK
			| GDK_LEAVE_NOTIFY_MASK
			| GDK_BUTTON_PRESS_MASK
			| GDK_BUTTON_RELEASE_MASK
			| GDK_POINTER_MOTION_MASK
			| GDK_POINTER_MOTION_HINT_MASK
			| GDK_KEY_PRESS_MASK
			);

  return g_usecase_canvas;
}

/*
 * usecase_append_radio_buttons
 */
void usecase_append_radio_buttons(GtkWidget *window, GtkWidget *toolbar)
{
  GSList *group = NULL;
  GtkWidget *button;
  GtkWidget *gtkPixmap;
  GdkPixmap *gdkPixmap;
  GdkBitmap *gtkMask;
  int i = 0;

  while(g_usecase_toolbar_item[i].tooltips != NULL) {
    if (strcmp(g_usecase_toolbar_item[i].tooltips, SPACE_CMD) == 0){
      gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
      i ++;
      continue;
    }

    gdkPixmap = 
      gdk_pixmap_create_from_xpm_d(window->window,
				   &gtkMask,
				   &window->style->bg[GTK_STATE_NORMAL],
				   g_usecase_toolbar_item[i].xpm);

    gtkPixmap = gtk_pixmap_new(gdkPixmap, gtkMask);

    button = gtk_radio_button_new(group);
    group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(button), FALSE);

    gtk_signal_connect( GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(g_usecase_toolbar_item[i].func),
			NULL );

    gtk_container_add(GTK_CONTAINER(button), gtkPixmap);

    gtk_toolbar_append_widget( GTK_TOOLBAR(toolbar),
			       GTK_WIDGET(button),
			       g_usecase_toolbar_item[i].tooltips,
			       NULL);

    gtk_widget_show(GTK_WIDGET(button));
    gtk_widget_show(GTK_WIDGET(gtkPixmap));

    i ++;
  }
}

/*
 * usecase_create_toolbar
 */
GtkWidget *usecase_create_toolbar(GtkWidget *window)
{
  GtkWidget *toolbar;
  GtkWidget *handle;

  handle = gtk_handle_box_new();

  toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
			     GTK_TOOLBAR_ICONS);

  gtk_widget_show(GTK_WIDGET(toolbar));

  usecase_append_radio_buttons(window, toolbar);

  gtk_container_add(GTK_CONTAINER(handle), GTK_WIDGET(toolbar));

  return handle;
}

/*
 * usecase_create_menubar
 */
GtkWidget *usecase_create_menubar(GtkWidget *window)
{
  int file_menu_items_int =
    sizeof(file_menu_items) / sizeof(file_menu_items[0]);
  int edit_menu_items_int =
    sizeof(edit_menu_items) / sizeof(edit_menu_items[0]);
  int display_menu_items_int =
    sizeof(display_menu_items) / sizeof(display_menu_items[0]);

  GtkWidget *menubar;
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  GtkWidget *handle;

  handle = gtk_handle_box_new();

  accel_group = gtk_accel_group_new();

  item_factory = gtk_item_factory_new( GTK_TYPE_MENU_BAR,
				       "<main>", 
				       accel_group);

  gtk_item_factory_create_items
    (item_factory, file_menu_items_int, file_menu_items, NULL);
  gtk_item_factory_create_items
    (item_factory, edit_menu_items_int, edit_menu_items, NULL);
  gtk_item_factory_create_items
    (item_factory, display_menu_items_int, display_menu_items, NULL);

  gtk_accel_group_attach(accel_group, GTK_OBJECT(window));

  menubar = gtk_item_factory_get_widget(item_factory, "<main>");

  gtk_widget_show(menubar);

  gtk_container_add(GTK_CONTAINER(handle), GTK_WIDGET(menubar));

  return handle;
}
