/*
 * usecase.h
 */
#ifndef USECASE_H
#define USECASE_H

#include <gtk/gtk.h>
#include "usecase_commands.h"

#include "pixmaps/usecase_select.xpm"
#include "pixmaps/actor.xpm"
#include "pixmaps/usecase.xpm"
#include "pixmaps/arc.xpm"
#include "pixmaps/system.xpm"

/*
 * UsecaseNodeStruct
 */
typedef struct
{
  int id;
  char name[64];
  GdkRectangle rect;
  GdkRectangle str_rect;
  int type;
  int select_mode;
}
UsecaseNodeStruct;

/*
 * select_mode
 */
typedef enum {
  usecase_select,
  usecase_first,
  usecase_second,
  usecase_third,
  usecase_forth,
  usecase_false
}
SelectMode;

/*
 * UsecaseSystemStruct
 */
typedef struct
{
  int id;
  char name[64];
  GdkRectangle rect;
  GdkRectangle str_rect;
  int type;
  SelectMode select_mode;
}
UsecaseSystemStruct;

/*
 * usecase_mode
 */
typedef enum {
  usecase_select_enum,
  usecase_actor_enum,
  usecase_usecase_enum,
  usecase_arc_enum,
  usecase_system_enum
}
usecase_mode;

/*
 * UsecaseArcStruct
 */
typedef struct
{
  int id;
  char name[64];
  GdkRectangle str_rect;

  int start_x;
  int start_y;
  int start_node_id;

  int end_x;
  int end_y;
  int end_node_id;

  int select_mode;
}
UsecaseArcStruct;

/*
 * UsecaseToolbarItem
 */
typedef struct
{
  char *tooltips;
  char **xpm;
  void *func;
}
UsecaseToolbarItem;

/*
 * File Menu
 */
static GtkItemFactoryEntry file_menu_items[] = {
  { "/ե", NULL, NULL, 0, "<Branch>" },
  { "/ե/", "<control>N", usecase_new_file, 0, NULL },
  { "/ե/", "<control>O", usecase_load_file, 0, NULL },
  { "/ե/¸", "<control>S", usecase_save_file, 0, NULL },
  { "/ե/̾¸", NULL, usecase_save_file_as, 0, NULL },
  { "/ե/separator", NULL, NULL, 0, "<Separator>" },
  { "/ե/ݡ", NULL, NULL, 0, "<Branch>" },
  { "/ե/ݡ/jpg", "<control>J", usecase_export_jpg, 0, NULL },
  { "/ե/ݡ/eps", "<control>E", usecase_export_eps, 0, NULL },
  { "/ե/separator", NULL, NULL, 0, "<Separator>" },
  { "/ե/λ", "<control>Q", usecase_quit, 0, NULL },
};

/*
 * Edit Menu
 */
static GtkItemFactoryEntry edit_menu_items[] = {
  { "/Խ", NULL, NULL, 0, "<Branch>" },
  { "/Խ/", "<control>D", usecase_delete_element, 0, NULL },
};

/*
 * Display Menu
 */
static GtkItemFactoryEntry display_menu_items[] = {
  { "/ɽ", NULL, NULL, 0, "<Branch>" },
  { "/ɽ/եå", "<control>R", usecase_display_refresh, 0, NULL },
};

gint usecase_expose(GtkWidget *widget, GdkEventExpose *event);
gint usecase_motion_notify(GtkWidget *widget, GdkEventMotion *event);
gint usecase_button_press(GtkWidget *widget, GdkEventButton *event);
gint usecase_button_release(GtkWidget *widget, GdkEventButton *event);

GtkWidget *usecase_create_canvas(void);
GtkWidget *usecase_create_toolbar(GtkWidget *window);
GtkWidget *usecase_create_menubar(GtkWidget *window);

void usecase_append_radio_buttons(GtkWidget *window, GtkWidget *toolbar);

void usecase_set_select_mode();
void usecase_set_actor_mode();
void usecase_set_usecase_mode();
void usecase_set_arc_mode();
void usecase_set_system_mode();

#endif
