/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.mainmenu_api.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.aetherteam.mainmenu_api.MainMenuAPI;
import net.aetherteam.mainmenu_api.MenuBaseAether;
import net.aetherteam.mainmenu_api.MenuBaseLeftMinecraft;
import net.aetherteam.mainmenu_api.MenuBaseMinecraft;
import net.aetherteam.mainmenu_api.MenuCommonProxy;
import net.aetherteam.mainmenu_api.MenuSoundLoader;
import net.aetherteam.mainmenu_api.client.MenuClientTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.MinecraftForge;

public class MenuClientProxy
extends MenuCommonProxy {
    private static String soundZipPath = "/resources/";

    @Override
    public void registerTickHandler() {
        MainMenuAPI.registerMenu("Minecraft", MenuBaseMinecraft.class);
        MainMenuAPI.registerMenu("Left Minecraft", MenuBaseLeftMinecraft.class);
        MainMenuAPI.registerMenu("Aether I", MenuBaseAether.class);
        TickRegistry.registerTickHandler((ITickHandler)new MenuClientTickHandler(), (Side)Side.CLIENT);
    }

    @Override
    public Minecraft getClient() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public void registerSounds() {
        this.installSound("streaming/Aether Menu.ogg");
        this.installSound("streaming/Aether Menu Two.wav");
        MinecraftForge.EVENT_BUS.register((Object)new MenuSoundLoader());
    }

    private void installSound(String filename) {
        File soundFile = new File(ModLoader.getMinecraftInstance().field_71412_D, "resources/" + filename);
        if (!soundFile.exists()) {
            try {
                String srcPath = soundZipPath + filename;
                InputStream inStream = MainMenuAPI.class.getResourceAsStream(srcPath);
                if (inStream == null) {
                    throw new IOException();
                }
                if (!soundFile.getParentFile().exists()) {
                    soundFile.getParentFile().mkdirs();
                }
                BufferedInputStream fileIn = new BufferedInputStream(inStream);
                BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(soundFile));
                byte[] buffer = new byte[1024];
                int n = 0;
                while (-1 != (n = fileIn.read(buffer))) {
                    fileOut.write(buffer, 0, n);
                }
                fileIn.close();
                fileOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (soundFile.canRead() && soundFile.isFile()) {
            ModLoader.getMinecraftInstance().func_71360_a(filename, soundFile);
        } else {
            System.err.println("Could not load file: " + soundFile);
        }
    }
}

