/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import java.io.IOException;
import java.io.Writer;

public class TextExtractor
implements CharStreamSource {
    private final Segment segment;
    private boolean convertNonBreakingSpaces = true;
    private boolean includeAttributes = false;
    private boolean excludeNonHTMLElements = false;

    public TextExtractor(Segment segment) {
        this.segment = segment;
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.toString());
        writer.flush();
    }

    public long getEstimatedMaximumOutputLength() {
        return this.segment.length();
    }

    public String toString() {
        return new Processor(this.segment, this.getConvertNonBreakingSpaces(), this.getIncludeAttributes(), this.getExcludeNonHTMLElements()).toString();
    }

    public TextExtractor setConvertNonBreakingSpaces(boolean bl) {
        this.convertNonBreakingSpaces = bl;
        return this;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.convertNonBreakingSpaces;
    }

    public TextExtractor setIncludeAttributes(boolean bl) {
        this.includeAttributes = bl;
        return this;
    }

    public boolean getIncludeAttributes() {
        return this.includeAttributes;
    }

    public TextExtractor setExcludeNonHTMLElements(boolean bl) {
        this.excludeNonHTMLElements = bl;
        return this;
    }

    public boolean getExcludeNonHTMLElements() {
        return this.excludeNonHTMLElements;
    }

    public boolean excludeElement(StartTag startTag) {
        return false;
    }

    private final class Processor {
        private final Segment segment;
        private final Source source;
        private final boolean convertNonBreakingSpaces;
        private final boolean includeAttributes;
        private final boolean excludeNonHTMLElements;

        public Processor(Segment segment, boolean bl, boolean bl2, boolean bl3) {
            this.segment = segment;
            this.source = segment.source;
            this.convertNonBreakingSpaces = bl;
            this.includeAttributes = bl2;
            this.excludeNonHTMLElements = bl3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.segment.length());
            int n = this.segment.begin;
            Object object = this.segment.findAllTags().iterator();
            while (object.hasNext()) {
                Tag tag = (Tag)object.next();
                int n2 = tag.begin;
                if (n2 < n) continue;
                while (n < n2) {
                    stringBuffer.append(this.source.charAt(n++));
                }
                if (tag.getTagType() == StartTagType.NORMAL) {
                    StartTag startTag = (StartTag)tag;
                    if (tag.name == "script" || tag.name == "style" || TextExtractor.this.excludeElement(startTag) || this.excludeNonHTMLElements && !HTMLElements.getElementNames().contains(tag.name)) {
                        n = startTag.getElement().end;
                        continue;
                    }
                    if (this.includeAttributes) {
                        Attribute attribute;
                        Attribute attribute2;
                        Attribute attribute3;
                        Attribute attribute4;
                        Attributes attributes = startTag.getAttributes();
                        Attribute attribute5 = attributes.get("title");
                        if (attribute5 != null) {
                            stringBuffer.append(' ').append((Object)attribute5.getValueSegment()).append(' ');
                        }
                        if ((attribute4 = attributes.get("alt")) != null) {
                            stringBuffer.append(' ').append((Object)attribute4.getValueSegment()).append(' ');
                        }
                        if ((attribute3 = attributes.get("label")) != null) {
                            stringBuffer.append(' ').append((Object)attribute3.getValueSegment()).append(' ');
                        }
                        if ((attribute2 = attributes.get("summary")) != null) {
                            stringBuffer.append(' ').append((Object)attribute2.getValueSegment()).append(' ');
                        }
                        if ((attribute = attributes.get("content")) != null && attributes.get("name") != null) {
                            stringBuffer.append(' ').append((Object)attribute.getValueSegment()).append(' ');
                        }
                    }
                }
                if (tag.getName() == "br" || !HTMLElements.getInlineLevelElementNames().contains(tag.getName())) {
                    stringBuffer.append(' ');
                }
                n = tag.end;
            }
            while (n < this.segment.end) {
                stringBuffer.append(this.source.charAt(n++));
            }
            object = CharacterReference.decodeCollapseWhiteSpace(stringBuffer, this.convertNonBreakingSpaces);
            return object;
        }
    }
}

