/**
 * 
 */
package jp.arcanum.click.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import jp.arcanum.click.ArUtil;
import net.sf.click.Page;
import net.sf.click.control.HiddenField;
import net.sf.click.control.Submit;
import net.sf.click.control.TextArea;


/**
 *
 */
public class EditFilePage extends AbstractToolPage{

	
	/**
	 * t@Ce
	 */
	private TextArea filecontents = new TextArea("filecontents");
	
	/**
	 * OK{^
	 */
	private Submit ok      = new Submit("ok", "O.K", this, "onClickOk");
	
	/**
	 * ߂{^
	 */
	private Submit cancel  = new Submit("cancel", "߂", this, "onClickBack");
	
	
	/**
	 * pX<br>
	 * ̕ϐsetParameter()ɂꎞIɎgp
	 */
	private String _abspath = "";
	
	/**
	 * y[W<br>
	 * ̕ϐsetParameter()ɂꎞIɎgp
	 */
	private Page _caller = null;

	/**
	 * ҏWt@Cւ̃pXB
	 * F/WEB-INF/hoge.txt
	 */
	private HiddenField abspath = new HiddenField("abspath", String.class);

	/**
	 * Ăяoʂ̃NX
	 */
	private HiddenField caller = new HiddenField("caller", Class.class);
	
	/**
	 * p[^ݒ
	 * @param abspath 
	 * @param caller
	 */
	public void setParameter(
			String abspath,
			Page caller
	){
		_abspath = abspath;
		_caller = caller;
	}
	
	/**
	 * index.htmp
	 * @param abspath
	 */
	public void setParameter(
			String abspath
	){
		_abspath = abspath;
	}
	

	/**
	 * RXgN^
	 *
	 */
	public EditFilePage(){
		
		//eLXgGA
		filecontents.setAttribute("wrap", "off");
		filecontents.setCols(100);
		filecontents.setRows(25);
		form.add(filecontents);
		//OK
		form.add(ok);
		//cancel
		form.add(cancel);
		//ҏWpXiBځj
		form.add(abspath);
		//Ăяoy[WiBځj
		form.add(caller);
		
	}
	
	
	
	
	
	/**
	 * ݒ
	 */
	public void onInit(){
		super.onInit();

		//@ʕ\̏ꍇ
        if (getContext().isForward() && _abspath != null) {
			//̐ݒ
			abspath.setValueObject(_abspath);
			if(_caller != null){
				caller.setValueObject(_caller.getClass());
			}
        }

	}

	/**
	 * POST
	 */
	public void onPost(){
		
		if(ok.isClicked()){
			return;
		}
		
		//@ʂɈœnꂽt@C̓eݒ肷
		setFile();
		
	}

	/**
	 * GET
	 */
	public void onGet(){
		
		if(ok.isClicked()){
			return;
		}
		
		//@ʂɈœnꂽt@C̓eݒ肷
		setFile();
		
	}

	/**
	 * gq̕ϊe[u
	 */
	private static final Map EXT_TABLE = new HashMap(){
		{
			put("TXT", "ptext");
			put("HTML", "html");
			put("HTM", "html");
			put("CSS", "css");
			put("JS", "js");
			put("XML", "xml");
		}
	};
	
	
	/**
	 * ʂɃt@Ceݒ肷
	 *
	 */
	private void setFile(){
		
		//@t@C̎pX擾
		String filepath = super.context.getServletContext().getRealPath("");
		filepath = filepath + abspath.getValue();
		
		//@t@Ceǂݍ݉ʂɃZbg
		List lines = ArUtil.readFile(filepath);
		String _lines = "";
		for(int i = 0 ; i < lines.size(); i++){
			_lines = _lines + lines.get(i) + ArUtil.getClientChangingLine(this);
		}
		filecontents.setValue(_lines);
		

	}
	
	/**
	 * `O
	 */
	public void onRender(){
		super.onRender();
		
		//@ҏWt@C̃pX\
		String editpath = abspath.getValue();
		if(editpath.startsWith("//")){
			editpath = editpath.substring(1);
		}
		addModel("editpath", editpath);
		
		//@gqɂEditAreaݒiftHgptextj
		String filepath = super.context.getServletContext().getRealPath("");
		filepath = filepath + abspath.getValue();
		String ext = filepath.substring(filepath.lastIndexOf(".")+1).toUpperCase();
		String fileext = "ptext";
		if(EXT_TABLE.containsKey(ext)){
			fileext = (String)EXT_TABLE.get(ext);
		}
		addModel("fileext", fileext);
		
	}
	
	/**
	 * OK{^
	 * @return
	 */
    public boolean onClickOk(){
    	
    	//@eLXgGAɓ͂ꂽeۑɕҏW
        String text = this.filecontents.getValue();
        
        text = ArUtil.sanitize(text);
        
        System.out.println(text);
        filecontents.setValue(text);
        
        StringTokenizer tokens = new StringTokenizer(text, "\n");
        List wklines = new ArrayList();
        while(tokens.hasMoreTokens()){
            wklines.add(tokens.nextToken()+"\n");
        }
        
        //@ۑt@Cm聕ۑ
        String path = super.context.getServletContext().getRealPath("");
        path = path + abspath.getValue();
        ArUtil.writeFile(path, wklines);
        
        //@㏈
    	addMessage("t@CXV܂B");
        return true;

    }
    
    /**
     * ߂鏈
     * @return
     */
    public boolean onClickBack(){
        
    	
    	Class clazz = (Class)caller.getValueObject();
    	if(clazz != null){
        	super.setForward(clazz);
    	}
    	else{
    		super.setForward(abspath.getValue());
    	}
    	
        return false;
        
    }
    
    
}
