/**
 * 
 */
package jp.arcanum.click.pages;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

import jp.arcanum.click.ArUtil;
import jp.arcanum.click.PageProperties;
import jp.arcanum.click.UserInfo;
import jp.arcanum.click.pages.controls.ArTreeNode;
import jp.arcanum.click.pages.controls.LoginSubmit;
import net.sf.click.Context;
import net.sf.click.control.Checkbox;
import net.sf.click.control.FileField;
import net.sf.click.control.HiddenField;
import net.sf.click.control.Option;
import net.sf.click.control.PasswordField;
import net.sf.click.control.Select;
import net.sf.click.control.Submit;
import net.sf.click.control.TextArea;
import net.sf.click.control.TextField;
import net.sf.click.extras.control.PickList;
import net.sf.click.extras.tree.Tree;
import net.sf.click.extras.tree.TreeListener;
import net.sf.click.extras.tree.TreeNode;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;


/**
 * c[y[WNXB
 */
public class ToolMainPage extends AbstractToolPage implements TreeListener{

	/** fBNgc[̂[gm[hZbVɊi[ۂ̃L[ */
	private static final String TOOL_TREE = "TOOL_TREE";

	/**
	 * VKfBNg쐬{^
	 */
	private Submit newdir = new Submit("newdir", "VK",this,"onClickNewDir");
	
	/**
	 * VKfBNg̓tB[h
	 */
	private TextField newdirname = new TextField("newdirname");

	/**
	 * fBNg폜{^
	 */
	private Submit deldir = new Submit("deldir", "폜", this, "onClickDeleteDir");
	
	/**
	 * O[ṽpX[hύXtB[h
	 */
	private PasswordField password = new PasswordField("password"){
		
		public String toString(){
			UserInfo user = (UserInfo)super.context.getSession().getAttribute(ArUtil.USER);
			if(user == null){
				return "";
			}
			if(user.isAdmin()){
				return "";
			}
			return super.toString();
		}
	};
	
	/**
	 * XVÕ}[NAbv@
	 */
	private HiddenField exmarkup = new HiddenField("exmarkup", String.class);
	
	/**
	 * O[ṽpX[hύX{^
	 */
	private LoginSubmit changepass = 
		new LoginSubmit(
				"changepass", 
				"pX[hύX",
				this,
				"onClickChangePass",
				false);
		
	/**
	 * X[p[[Ũj[
	 */
	private LoginSubmit manageuser = 
		new LoginSubmit(
				"manageuser", 
				"[UǗ", 
				this, 
				"onClickManageUser",
				true);
	
	/**
	 * 
	 */
	private LoginSubmit managesite = 
		new LoginSubmit(
				"managesite", 
				"TCgݒ", 
				this, 
				"onClickManageSite",
				true);
	
	
	/**
	 * OAEg{^
	 */
	private Submit logout = new Submit("logout", "OAEg", this, "onClickLogout");
	
	
	//---------------------------------------------------------------------------
	
	/**
	 * fBNgIĂ邩ǂ<br>
	 * truȅꍇAڍׂ\B
	 */
	public boolean isselect = false;

	/**
	 * fBNgc[łǂ
	 */
	public boolean istreeok = false;
	
	/**
	 * fBNgc[
	 */
	public Tree dirtree = new Tree("dirtree");
	
	
	//------------------------------------------------------------------------
	//@ڍׂ̃tB[h
	//------------------------------------------------------------------------
	
	/**
	 * fBNg̕
	 */
	private TextField dirpname = new TextField("dirpname");
	/**
	 * fBNg̘_
	 */
	private TextField dirlname = new TextField("dirlname");
	/**
	 * fBNg̃I[i[
	 */
	private TextField dirowner = new TextField("dirowner");
	/**
	 * fBNg̕ҏW
	 */
	private PickList  direditor = new PickList("direditor");
	
	/**
	 * fBNg\邩ǂ̃`FbN{bNX
	 */
	private Checkbox publication     = new Checkbox("publication");
	/**
	 * fBNg\邩ǂ̃`FbN{bNX
	 */
	private Checkbox isshow     = new Checkbox("isshow");
	/**
	 * fBNg̕ҏW@<br>
	 * htmlAwiki̓\
	 */
	private Select   editmeth   = new Select("editmeth");
	/**
	 * zfBNg\邩ǂ
	 */
	private Checkbox rendierchildren = new Checkbox("rendierchildren");
	/**
	 * fBNg̐
	 */
	private TextArea description = new TextArea("description");
	/**
	 * ڍׂ̍XV{^
	 */
	private Submit okdetail = new Submit("okdetail", "XV", this, "onClickOkDetail");
	/**
	 * index.htm̃Abv[hit@CtB[hj
	 */
	private FileField filefld = new FileField("filefld");
	/**
	 * index.htm̃Abv[hi{^j
	 */
	private Submit uploadindex = new Submit("uploadindex", "Abv[h", this, "onClickUpload");
	/**
	 * index.htm̕ҏW{^
	 */
	private Submit editindex = new Submit("editindex", "eҏW", this, "onClickEditIndex");
	
	/**
	 * t@CXg{bNX
	 */
	private Select filelist = new Select("filelist");
	
	/**
	 * t@CRs[{^
	 */
	private Submit filecopy = new Submit("filecopy", "Rs[", 				this, "onClickFileCopy");
	/**
	 * fBNgRs[{^
	 */
	private Submit dircopy = new Submit("dircopy", "fBNgRs[", 		this, "onClickDirCopy");
	/**
	 * Rs[̃bZ[WGA
	 */
	public String copymessage = "";
	/**
	 * \t{^
	 */
	private Submit pasteobj = new Submit("pasteobj", "\t", 				this, "onClickPaste");
	/**
	 * t@C폜{^
	 */
	private Submit filedelete = new Submit("filedelete", "폜", 				this, "onClickFileDelete");
	/**
	 * t@CҏW{^
	 */
	private Submit fileedit = new Submit("fileedit", "ҏW", 					this, "onClickFileEdit");
	/**
	 * t@C_E[h{^
	 */
	private Submit filedownload = new Submit("filedownload", "_E[h", 	this, "onClickFileDownload");
	/**
	 * t@CZNg{bNX
	 */
	private HiddenField targetfile = new HiddenField("selfile", String.class);
	/**
	 * l[{^
	 */
	private Submit filerename = new Submit("filerename", "l[", this, "onClickFilrRename");
	/**
	 * VKt@C쐬{^
	 */
	private Submit filemake   = new Submit("filemake", "VKt@C", this, "onClickFileMake");
	/**
	 * l[AVKt@C̓GA
	 */
	private TextField inputfilename = new TextField("inputfilename"); 
	
	/**
	 * RXgN^
	 *
	 */
	public ToolMainPage(){
		
		//@VK{^		
		form.add(newdir);
		//@VKfBNg
		form.add(newdirname);
		//@[UǗ
		form.add(manageuser);
		//@pX[heLXg
		password.setSize(20);
		form.add(password);
		//@TCgݒ{^
		form.add(managesite);
		//@pX[hύX{^
		form.add(changepass);
		//@폜{^
		deldir.setAttribute("style", "color:blue;");
		deldir.setAttribute("onclick", "return confirm('IꂽfBNg܂ށAz̃fBNg폜܂')");
		form.add(deldir);
		
		//@fBNgc[
		dirtree.addListener(this);
		
		//@ڍׂ̍XV{^
		form.add(okdetail);
		
		//@OAEg
		form.add(logout);
		
		//------------------------------------------------
		//@ڍׂ̐ݒ
		//------------------------------------------------
		
		//@
		dirpname.setAttribute("disabled", "true");
		dirpname.setSize(40);
		form.add(dirpname);
		//@_
		dirlname.setSize(40);
		form.add(dirlname);
		//@fBNg̏L
		dirowner.setSize(40);
		form.add(dirowner);
		//@fBNg̕ҏW
		form.add(direditor);
		//@fBNg\邩
		form.add(isshow);
		//@J邩
		form.add(publication);
		//@ҏW@
		editmeth.add(new Option("html"));
		editmeth.add(new Option("wiki"));
		form.add(editmeth);
		form.add(exmarkup);
		//@z`悷邩
		form.add(rendierchildren);
		//@fBNg̐
		description.setCols(40);
		description.setRows(5);
		form.add(description);
		//@indexAbv[hitB[hj
		filefld.setAttribute("style", "width:400px;");
		form.add(filefld);
		//@indexAbv[hi{^j
		form.add(uploadindex);
		//  indexҏW
		form.add(editindex);
		//@t@CXg{bNX
		filelist.setSize(7);
		filelist.setAttribute("style", "width:200px;");
		form.add(filelist);
		
		//@Rs[
		filecopy.setAttribute("style", "width:80px");
		filecopy.setOnClick("form.selfile.value=form.filelist.value");
		form.add(filecopy);
		//@fBNgRs[
		dircopy.setAttribute("style", "width:80px");
		dircopy.setOnClick("form.selfile.value=form.filelist.value");
		form.add(dircopy);
		//@\t
		pasteobj.setAttribute("style", "width:80px");
		pasteobj.setOnClick("form.selfile.value=form.filelist.value");
		form.add(pasteobj);
		//@_E[h
		filedownload.setAttribute("style", "width:80px");
		filedownload.setOnClick("form.selfile.value=form.filelist.value");
		form.add(filedownload);
		//@폜
		filedelete.setAttribute("style", "width:80px");
		filedelete.setOnClick("form.selfile.value=form.filelist.value");
		form.add(filedelete);
		//@ҏW
		fileedit.setAttribute("style", "width:80px");
		fileedit.setOnClick("form.selfile.value=form.filelist.value");
		form.add(fileedit);
		//@Iy[VΏۃt@C
		form.add(targetfile);

		//@l[{^
		filerename.setAttribute("style", "width:80px");
		filerename.setOnClick("form.selfile.value=form.filelist.value");
		form.add(filerename);
		//@VKt@C쐬{^
		filemake.setAttribute("style", "width:80px");
		filemake.setOnClick("form.selfile.value=form.filelist.value");
		form.add(filemake);
		//@t@C
		form.add(inputfilename);
		
	}

	
	/**
	 * 
	 */
	public void onInit(){
	
		buildTree();
		
		
	}
	

	/**
	 * `O
	 */
	public void onRender(){
		
		super.onRender();
		
		//@fBNgIĂȂꍇ́A{^gpsƂ
		List selectednodes = dirtree.getSelectedNodes(true);
		if(selectednodes.isEmpty()){
			this.newdir.setAttribute("disabled", "true");
			this.deldir.setAttribute("disabled", "true");
			
		}
		//@ȂɂIԂ̏ꍇ́AfBNg̐ݒ\
		else{
			
			UserInfo user = (UserInfo)super.context.getSession().getAttribute(ArUtil.USER);
			
			isselect = true;
			TreeNode selected = (TreeNode)selectednodes.get(0);
			
			//@y[WvpeB擾
			String path = super.context.getServletContext().getRealPath("");
			path = path + "/" + selected.getId();
			PageProperties prop = ArUtil.getPageProperties(path);
			
			//@蓮ŏĂꍇ
			if(!new File(path).exists()){
				addMessage("IꂽfBNg͍폜Ă܂B");
				super.context.getSession().setAttribute("FORCE_BUILD_TREE", "FORCE_BUILD_TREE");
				buildTree();
				return;
			}
			
			//@fBNg
			this.dirpname.setValue((String)selected.getValue());
			//@fBNg_
			this.dirlname.setValue(prop.getTitle());
			//@j[\
			this.isshow.setChecked(prop.isVisible());
			//@J
			this.publication.setChecked(prop.isPublic());
			//@}[NAbv
			this.editmeth.setValue(prop.getMarkup());
			this.exmarkup.setValue(prop.getMarkup());
			//@z`悷邩
			this.rendierchildren.setChecked(prop.isRenderChild());
			//@
			String desc = "";
			for(int i = 0 ; i < prop.getDescs().size(); i++){
				desc = desc + prop.getDescs().get(i) + "\n";
			}
			this.description.setValue(desc);
			
			//@t@CXg
			File dir = new File(path);
			File[] files = dir.listFiles();
			for(int i = 0 ; i < files.length; i++){
				if(files[i].isFile()) filelist.add(files[i].getName());
			}
			
			//@Rs[Ԃ\
			String copytype   = (String)super.context.getSession().getAttribute("COPY_TYPE");
			String copytarget = (String)super.context.getSession().getAttribute("COPY_TARGET");
			if(copytype == null){
				pasteobj.setAttribute("disabled", "true");
				copymessage = "";
			}
			else{
				copymessage = "[" + copytarget + "]\tł܂B";
			}

			if(!user.isAdmin()){
				okdetail.setAttribute("disabled", "true");
			}

		
		}

	
	
	}
	
	
	/**
	 * fBNgc[\<br>
	 * ̃\bh́AXiݒ肵Ă邽߁AKonInit()ȑO
	 * gp邱
	 *
	 */
	private void buildTree(){

        TreeNode existingRootNode = 
        	(TreeNode)super.context.getSession().getAttribute(TOOL_TREE);
        if(super.context.getSession().getAttribute("FORCE_BUILD_TREE")== null 
        		&& existingRootNode != null ) {
        	
    			dirtree.setRootNode(existingRootNode);
    	        dirtree.setRootNodeDisplayed(true);
    	        istreeok = true;
                return;
        	
        }

		super.context.getSession().removeAttribute("FORCE_BUILD_TREE");
		
        //@[gpX擾
        String docroot = ArUtil.getProperty(this, ArUtil.PROP_SITE, ArUtil.KEY_SITECONF_DOCROOT);
        if(!docroot.startsWith("/")){
        	docroot = "/" + docroot;
        }
        String rootpath = context.getServletContext().getRealPath(docroot);
        String absrootpath = rootpath.substring(0,rootpath.length() - docroot.length());
        
        //@[gpX݂ȂΏI
        File rootpathfile = new File(rootpath);
        if(!rootpathfile.exists()){
        	return;
        }
        
        //@c[𐶐
    	istreeok = true;
        
        PageProperties prop = ArUtil.getPageProperties(rootpath);
        String title = rootpath.substring(absrootpath.length());
        if(title.startsWith("\\")){
            title = "/" + title.substring(1);
        }
        
        if(prop.isPublic()){
        	title = title + " [+";
        }
        else{
        	title = title + " [-";
        }
        if(prop.isVisible()){
        	title = title + "+";
        }
        else{
        	title = title + "-";
        }
        if(prop.getMarkup().equals(PageProperties.MARKUP_HTML)){
        	title = title + "h";
        }
        else{
        	title = title + "w";
        }
        if(prop.isRenderChild()){
        	title = title + "+]";
        }
        else{
        	title = title + "-]";
        }
        
        
        
        
        ArTreeNode rootnode = new ArTreeNode(title,docroot);
        rootnode.setIsVisible(prop.isVisible());
        rootnode.setIsLink(prop.isIslink());
        rootnode.setIsRenderChild(prop.isRenderChild());
        
        //ċAIɃfBNg\Zbg
        this.setTree(rootnode, rootpath, absrootpath);

        //@c[̂̐ݒ
        dirtree.setRootNode(rootnode);
        dirtree.expandAll();
        dirtree.setRootNodeDisplayed(true);
        if(existingRootNode != null){
        	
        	List selectedlist = dirtree.getSelectedNodes(true);
        	if(!selectedlist.isEmpty()){
        		
        		TreeNode selected = (TreeNode)selectedlist.get(0);
        		dirtree.select(selected.getId());
        		
        	}
        	
        }
        
        
        //@̃c[ZbVɕۑ
        getContext().getSession().setAttribute(TOOL_TREE, rootnode);

	
	}
	
	/**
	 * ċAIɃhLg[g猟sAfBNgc[ɕ\
	 * @param node
	 * @param path
	 * @param rootpath
	 */
	private void setTree(ArTreeNode node, String path, String rootpath){
		
		
		File file = new File(path);
		String[] files = file.list();
		
		for(int i = 0 ; i < files.length; i++){
			
			String abspath = path + "/" + files[i];
			File wkfile = new File(abspath);
			if(wkfile.isDirectory()){
				
				PageProperties prop = ArUtil.getPageProperties( abspath);
				
				String dirname =  abspath.substring(abspath.lastIndexOf("/"));
				
				//@̃tH_m[h
				String id = abspath.substring(rootpath.length()+1);
				if(id.startsWith("\\")){
					id = "/" + id.substring(1);
				}
				
				if(id.equals("/.settings")){
					continue;
				}
				if(id.equals("/work")){
					continue;
				}
				if(id.equals("/WEB-INF")){
					continue;
				}
				if(id.equals("/click")){
					continue;
				}
				if(id.equals("/tools")){
					continue;
				}

		        if(prop.isPublic()){
		        	dirname = dirname + " [+";
		        }
		        else{
		        	dirname = dirname + " [-";
		        }
		        if(prop.isVisible()){
		        	dirname = dirname + "+";
		        }
		        else{
		        	dirname = dirname + "-";
		        }
		        if(prop.getMarkup().equals(PageProperties.MARKUP_HTML)){
		        	dirname = dirname + "h";
		        }
		        else{
		        	dirname = dirname + "w";
		        }
		        if(prop.isRenderChild()){
		        	dirname = dirname + "+]";
		        }
		        else{
		        	dirname = dirname + "-]";
		        }
		        
				
				
				ArTreeNode child = 
					new ArTreeNode(dirname, id, node);

				child.setIsVisible(prop.isVisible());
				child.setIsLink(prop.isIslink());
				child.setIsRenderChild(prop.isRenderChild());
				
				setTree(child, abspath, rootpath);
						
			}
		}
		
	}

	/**
	 * VKfBNg쐬
	 * @return 
	 */
	public boolean onClickNewDir(){
		
		String dirname = newdirname.getValue();
		dirname = dirname.trim();
		if(dirname.equals("")){
			addMessage("fBNg͂ĂB");
			return true;
		}
		
		//@t@C֑̃`FbN
		//@@EWindows@\/:;*?"<>
		//@@EUnix@@ /ȊOOK
		//  ⑫F
		//@@@OS̔fĂ܂ƁAWebT[o̍ڂĂOS
		//@@@oĂ܂̂ŁAWindowsɂ킹B
		String checkstr = "\\/:;*?\"<>";
		for(int i = 0 ; i < checkstr.length(); i++){
			if(dirname.indexOf(checkstr.substring(i,i+1))!=-1){
				addMessage("fBNgɎgpłȂ܂B");
				return true;
			}
		}
		
	
		//@t@C֑̃`FbN
		//@@EȂǂ͍邯ǁATreeőIłȂȂ̂
        byte[] bytes = dirname.getBytes();
        int beams = dirname.length();
        if (beams != bytes.length) {
        	addMessage("Sp͎gpł܂B");
        	return true;
        }
	
		
		//@fBNgIĂȂꍇ̂
		List selected = dirtree.getSelectedNodes(true);
		if(selected.isEmpty()){
			addMessage("eƂȂfBNgIĂ܂B");
			return true;
		}
		
		
		//@쐬fBNgpXҏW
		TreeNode node = (TreeNode)selected.get(0);
		String abspath = super.context.getServletContext().getRealPath("");
		String makedir = abspath + "/" + node.getId() + "/" + dirname;
		 
		
		//@ɑ݂fBNg̏ꍇG[
		File file = new File(makedir);
		if(file.exists()){
			addMessage("ɃfBNg쐬Ă܂B");
			return true;
		}
		
		//@IɃfBNg쐬
		try {
			FileUtils.forceMkdir(file);
		} catch (IOException e) {
			addMessage("fBNg̍쐬Ɏs܂B" + e.getMessage());
			return true;
		}
		
		//@⑫Findex.htm,wiki.txtׂH
		//@@@RV[PX͐VKfBNgĂ
		//@@@}[NAbvύXēe̕ҏWƂȂ̂
		//@@@RRō̂html݂̂ɂȂBAA[U
		//@@@ɂẮAfBNgĂɃy[W
		//@@@\ꍇ̂ŁAꉞł
		
		//@index.htm,wiki.txt
		if(editmeth.getValue().equals("html")){
			List lines = new ArrayList();
			lines.add("<br>");
			lines.add("<hr>");
			lines.add("<h1>̓eύXĂB</h1>");
			lines.add("<hr>");
			ArUtil.writeFile(makedir + "/index.htm", lines);
		}
		else{
			List lines = new ArrayList();
			lines.add("$wikicontents");
			ArUtil.writeFile(makedir + "/wiki.txt", lines);
			
			List wikilines = new ArrayList();
			wikilines.add("--");
			wikilines.add("̓eύXĂB");
			wikilines.add("--");
			ArUtil.writeFile(makedir + "/index.htm", wikilines);
			
		}
		
		//@ZbVoRŃfBNgc[č쐬B
		super.context.getSession().setAttribute("FORCE_BUILD_TREE", "FORCE_BUILD_TREE");
		setLastUpdatedTime();
		
		buildTree();
		
		return true;
		
	}
	
	/**
	 * [UǗ
	 * @return
	 */
	public boolean onClickManageUser(){
		
		super.setForward(ManageUserPage.class);
		return false;

	}
	
	/**
	 * 폜{^
	 * @return
	 */
	public boolean onClickDeleteDir(){
		
		//@fBNgIĂȂꍇ
		List selected = dirtree.getSelectedNodes(true);
		if(selected.isEmpty()){
			addMessage("폜fBNgIĂ܂B");
			return true;
		}
		
		//@폜fBNg̎擾
		TreeNode node = (TreeNode)selected.get(0);
		String abspath = super.context.getServletContext().getRealPath("");
		String deldir = abspath + node.getId() ;
		System.out.println( deldir + "@폜܂");
		
		//@폜ΏۃfBNg̑݃`FbN
		File file = new File(deldir);
		if(!file.exists()){
			addMessage("ɃfBNg폜Ă܂B");
			//@폜fBNgN폜񂾂ǂČΗǂ񂾂ǁEEE
			return true;
		}

		try {
			//@IɃfBNg폜iċAIɍ폜܂j
			FileUtils.forceDelete(file);
		} catch (IOException e) {
			addMessage("fBNg̍폜Ɏs܂B" + e.getMessage());
			return true;
		}

		super.context.getSession().setAttribute("FORCE_BUILD_TREE", "FORCE_BUILD_TREE");
		setLastUpdatedTime();
		buildTree();
		
		return true;
	}

	/**
	 * OAEg{^
	 * @return
	 */
	public boolean onClickLogout(){
		
		super.context.getSession().removeAttribute(ArUtil.USER);
		super.context.getSession().invalidate();
		
		super.setRedirect(LoginPage.class);
		return false;
		
	}

	
	//-----------------------------------------------------------------------------
	
	
	public void nodeCollapsed(Tree tree, TreeNode node, Context context, boolean oldValue) {
	}


	public void nodeDeselected(Tree tree, TreeNode node, Context context, boolean oldValue) {
	}


	public void nodeExpanded(Tree tree, TreeNode node, Context context, boolean oldValue) {
	}

	/**
	 * fBNgc[̃m[hNbNꂽƂ<br>
	 * fBNgc[̂P̃m[ĥ݂I悤ɐ䂵܂B
	 */
	public void nodeSelected(Tree tree, TreeNode node, Context context, boolean oldValue) {

		System.out.println("--------------------------------");
		System.out.println(node);
		System.out.println(oldValue);
		
		
        List selected = tree.getSelectedNodes(false);
        for(int i = 0 ; i < selected.size(); i++){
            TreeNode selnode = (TreeNode)selected.get(i);
            if(selnode != node){
                tree.deselect(selnode);
            }
        }
        
        isselect = true;
	
	}

	
	/**
	 * eXV{^
	 * @return
	 */
	public boolean onClickOkDetail() {

		if(dirlname.getValue().trim().equals("")){
			addMessage("fBNg̘_͂Ă܂B");
			return true;
		}
		
		// TODO DOMŕۑ悤ɂ
		// TODO [eBeB
		
		//@ۑe̕ҏW
		List lines = new ArrayList();
		lines.add("<?xml version=\"1.0\" encoding=\"Shift_JIS\" ?>" + "\n");
		String page = "<page ";
		page = page + "visible=\"" + this.isshow.isChecked() + "\" ";
		page = page + "markup=\"" + this.editmeth.getValue() + "\" ";
		page = page + "renderchild=\"" + this.rendierchildren.isChecked() + "\" ";
		page = page + "public=\"" + this.publication.isChecked() + "\" ";
		page = page + ">";
		lines.add(page + "\n");
		
		String title = "<title>" + this.dirlname.getValue() + "</title>";
		lines.add(title + "\n");
		
		String descs = description.getValue();
		descs = descs.replaceAll("\r", "");
		StringTokenizer tokens = new StringTokenizer(descs,"\n");
		while(tokens.hasMoreTokens()){
			String token = tokens.nextToken();
			String desc = "<desc>" + token + "</desc>";
			lines.add(desc + "\n");
		}
		lines.add("</page>");
		
		//@ۑt@C̓
        List selected = dirtree.getSelectedNodes(false);
        if(selected.isEmpty()){
        	addMessage("XVׂfBNgȂȂI");
        	return true;
        }
        TreeNode node = (TreeNode)selected.get(0);
 
        String path = super.context.getServletContext().getRealPath("");
        String abspath = path + "/" + node.getId();
        String xmlpath = abspath + "/page.xml";
        
        //@̂悤ȃC[WōXV
		//<//page visible="true" link="true" markup="html" renderchild="true" >
	    //	<title>gbvy[W</title>
	    //	<desc>͂߂</desc>
	    //	<desc>ɂ̃NbNNW</desc>
	    //	<desc>XV</desc>
	    //	<desc>̑</desc>
		//</page>
        ArUtil.writeFile(xmlpath, lines);
		
        //@悤ɂ
        if(!this.exmarkup.getValue().equals(this.editmeth.getValue())){

        	//}[NAbv̍XV
        	this.exmarkup.setValue(this.editmeth.getValue());
        	
			Date date = new Date();
			SimpleDateFormat f = new SimpleDateFormat("yyyyMMddkkmmssSSS");
			String ymd = f.format(date);

			//@index.htm,wiki.txt
    		if(editmeth.getValue().equals("html")){

    			// obNAbv yyyymmddhhmmssSSS_wiki.txt
    			//                    yyyymmddhhmmssSSS_index.htm
    			File exindexwiki = new File(abspath + "/wiki.txt");
    			//File exindexhtml = new File(abspath + "/index.htm");
    			if(exindexwiki.exists()){
    				
        			try {
    					FileUtils.copyFile(exindexwiki,	new File(abspath + "/" + ymd + "_wiki.txt"));
    					//FileUtils.copyFile(exindexhtml,	new File(abspath + "/" + ymd + "_index.htm"));
    							
    				} catch (IOException e) {
    					throw new RuntimeException("t@CRs[s");
    				}
    				
    			}
    			

    			List lineshtml = new ArrayList();
    			lineshtml.add("<hr>");
    			lineshtml.add("<h1>̓eύXĂB</h1>");
    			lineshtml.add("<h2>}[NAbvhtmlł</h2>");
    			lineshtml.add("<hr>");
    			
    			ArUtil.writeFile(abspath + "/index.htm", lineshtml);

    		}
    		else{
    			

    			// obNAbv yyyymmddhhmmssSSS_index.htm
    			File exindex = new File(abspath + "/index.htm");
    			if(exindex.exists()){
    				
        			try {
    					FileUtils.copyFile(exindex,	new File(abspath + "/" + ymd + "_index.htm")
    							);
    				} catch (IOException e) {
    					throw new RuntimeException("t@CRs[s");
    				}
    				
    			}

    			
    			List lineshtml = new ArrayList();
    			lineshtml.add("$wikicontents");
    			ArUtil.writeFile(abspath + "/index.htm", lineshtml);
    			
    			List lineswiki = new ArrayList();
    			lineswiki.add("----\n");
    			lineswiki.add("!̓eύXĂB\n");
    			lineswiki.add("!!}[NAbvwikił\n");
    			lineswiki.add("----\n");
    			
    			ArUtil.writeFile(abspath + "/wiki.txt", lineswiki);
    			
    		}

        }
        
        addMessage("ݒXV܂B");
		isselect = true;
		super.context.getSession().setAttribute("FORCE_BUILD_TREE", "FORCE_BUILD_TREE");
		buildTree();
		setLastUpdatedTime();

		return true;
	
	}

	/**
	 * eҏW{^
	 * @return
	 */
	public boolean onClickEditIndex(){
		
        List selectednode = dirtree.getSelectedNodes(true);
        TreeNode node = (TreeNode)selectednode.get(0);
        
        super.context.setRequestAttribute("EDIT_PATH", node.getId());
		
		super.setForward(EditIndexPage.class);
		return false;
		
	}
	
	/**
	 * TCgǗ{^
	 * @return
	 */
	public boolean onClickManageSite(){
		
		super.setForward(ManageSitePage.class);
		return false;
		
	}
	
	/**
	 * Abv[h{^
	 * @return
	 */
	public boolean onClickUpload(){
		
		FileItem item = filefld.getFileItem();
		if(item.getSize() == 0){
			addMessage("Abv[ht@CIĂ܂B");
			return true;
		}
		
		
		InputStream inst = null;
		try {
			inst = item.getInputStream();
		} catch (IOException e) {
			addMessage("t@C̃Abv[hɃG[܂B" + e.getMessage());
			return true;
		}

		//@ǂ̃fBNgɃAbv[h邩
        List selected = dirtree.getSelectedNodes(false);
        TreeNode node = (TreeNode)selected.get(0);
        
        //@fBNgւ̐΃pXҏW
        String path = super.context.getServletContext().getRealPath("");
        path = path + "/" + node.getId() + "/";
        
        //@t@Ĉ̕ҏW
        String filename = item.getName();
        String filesep = ArUtil.getClientFileSeparator(this);
        filename = filename.substring(filename.lastIndexOf(filesep)+1);
        path = path + filename;
        
        //@Abv[h
		FileOutputStream fos = null;
		try {
			fos = new FileOutputStream(path);
			byte[] b = new byte[2048];
			while((inst.read(b,0,2048)) != -1){
				fos.write(b,0 ,2048);
			}
			
		} catch (Exception e) {
			addMessage("t@C̃Abv[hɃG[܂B" + e.getMessage());
			return true;
		}
		finally{
			try {
				if(fos != null)fos.close();
			} catch (IOException e) {
				addMessage("t@C̃N[YɃG[܂B" + e.getMessage());
				return true;
			}
		}
		
		addMessage("t@Cu"+ item.getName() +"vAbv[h܂B");
		return true;
		
	}

	/**
	 * ŏIXV<br>
	 * ͍̏ŏIIɎgpȂȂ\
	 *
	 */
	private void setLastUpdatedTime(){
		
        String lastpath = super.context.getServletContext().getRealPath("/");
        lastpath = lastpath + ArUtil.DIR_CONF + "lastupdated.txt";

        Date now = new Date();
        List lines = new ArrayList();
        lines.add(now.toString());
        
        ArUtil.writeFile(lastpath, lines);
        
	}
	
	/**
	 * t@CҏW{^
	 * @return
	 */
	public boolean onClickFileEdit(){
		
		String selfile = targetfile.getValue();
		if(selfile.equals("")){
			addMessage("t@CIĂ܂B");
			return true;
		}
		if(selfile.endsWith("_index.htm")||
		   selfile.endsWith("_wiki.txt")){
			addMessage("t@C͕ҏWł܂B");
			return true;
		}
		if(selfile.endsWith("index.htm")){
			return onClickEditIndex();
		}
		
		//@fBNgIĂꍇ̂
		List selectednodes = dirtree.getSelectedNodes(true);
		if(!selectednodes.isEmpty()){
			
			TreeNode node = (TreeNode)selectednodes.get(0);
			
			//@ҏWʂɑJ
			EditFilePage page = (EditFilePage)super.context.createPage(EditFilePage.class);
			page.setParameter(node.getId() + "/" + selfile, this);
			super.setForward(page);
		}
		else{
			addMessage("ҏWׂt@CȂȂII");
		}
		
		return true;
	}


	/**
	 * t@C폜
	 * @return
	 */
	public boolean onClickFileDelete(){
		
		String selfile = targetfile.getValue();
		if(selfile.equals("")){
			addMessage("t@CIĂ܂B");
			return true;
		}
		
		//@fBNgIĂꍇ̂
		List selectednodes = dirtree.getSelectedNodes(true);
		if(!selectednodes.isEmpty()){
			
			TreeNode node = (TreeNode)selectednodes.get(0);
			String abspath = super.context.getServletContext().getRealPath("");
			abspath = abspath + node.getId() + "/" + selfile;

			try {
				FileUtils.forceDelete(new File(abspath));
			} catch (IOException e) {
				throw new RuntimeException("t@C폜Ɏs " + abspath , e);
			}
			
			addMessage("[" + node.getId() + "/" + selfile + "]̍폜s܂B");
		}
		else{
			addMessage("ҏWׂt@CȂȂII");
		}
		
		return true;
	}


	/**
	 * t@C_E[h
	 * @return
	 */
	public boolean onClickFileDownload(){

		//@t@CIĂ邩
		String selfile = targetfile.getValue();
		if(selfile.equals("")){
			addMessage("t@CIĂ܂B");
			return true;
		}
		
		//@fBNgIĂꍇ̂
		List selectednodes = dirtree.getSelectedNodes(true);
		if(selectednodes.isEmpty()){
			addMessage("ҏWׂt@CȂȂII");
			
		}
		
		//@_E[hpX̕ҏW
		TreeNode node = (TreeNode)selectednodes.get(0);
		String abspath = super.context.getServletContext().getRealPath("");
		abspath = abspath + node.getId() + "/" + selfile;

		//@_E[hʂɏϏ
		super.context.getRequest().setAttribute("DLPATH", abspath);
		super.setForward(DownloadPage.class);

		return true;
	
	}

	

	/**
	 * t@CRs[
	 * @return
	 */
	public boolean onClickFileCopy(){
		
		String selfile = targetfile.getValue();
		if(selfile.equals("")){
			addMessage("t@CIĂ܂B");
			return true;
		}
		
		//@fBNgIĂꍇ̂
		List selectednodes = dirtree.getSelectedNodes(true);
		if(!selectednodes.isEmpty()){
			
			TreeNode node = (TreeNode)selectednodes.get(0);

			super.context.getSession().setAttribute("COPY_TYPE", "FILE");
			super.context.getSession().setAttribute("COPY_TARGET", node.getId() + "/" + selfile);
		
		
		}
		else{
			addMessage("Rs[ׂt@CȂȂII");
		}
		
		return true;
	}
	
	/**
	 * fBNgRs[
	 * @return
	 */
	public boolean onClickDirCopy(){
		
		//@fBNgIĂꍇ̂
		List selectednodes = dirtree.getSelectedNodes(true);
		if(!selectednodes.isEmpty()){
			
			TreeNode node = (TreeNode)selectednodes.get(0);

			super.context.getSession().setAttribute("COPY_TYPE", "DIR");
			super.context.getSession().setAttribute("COPY_TARGET", node.getId() );
		
		}
		else{
			addMessage("Rs[ׂfBNg킩ȂȂII");
		}
		
		return true;
	}
	
	/**
	 * \t
	 * @return
	 */
	public boolean onClickPaste(){
		
		String type   = (String)super.context.getSession().getAttribute("COPY_TYPE");
		String target = (String)super.context.getSession().getAttribute("COPY_TARGET");
	
		if(type == null){
			addMessage("Rs[ʂ܂@" + type);
			return true;
		}
		
		if(type.equals("FILE")){
			return pasteFile();
		}
		else if(type.equals("DIR")){
			
			boolean ret = pasteDir();
			
			super.context.getSession().setAttribute("FORCE_BUILD_TREE", "FORCE_BUILD_TREE");
			buildTree();
			setLastUpdatedTime();
				
			addMessage(target + " \t܂B");
			
			return ret;
		}
		else{
			addMessage("Rs[Ώۂ܂@" + target);
			return true;
		}
		
	}
	
	/**
	 * \tit@Cj
	 * @return
	 */
	private boolean pasteFile(){
		
		String expath = (String)super.context.getSession().getAttribute("COPY_TARGET");
		expath = super.context.getServletContext().getRealPath("") + expath;
		
		File extarget = new File(expath);
		if(!extarget.exists()){
			addMessage("Rs[t@C͊ɍ폜ꂽ悤łB" + expath);
			return true;
		}
		
		List selectednodes = dirtree.getSelectedNodes(true);
		if(selectednodes.isEmpty()){
			addMessage("ΏۃfBNgȂȂB");
			return true;
		}
		
		TreeNode node = (TreeNode)selectednodes.get(0);
		
		String topath = super.context.getServletContext().getRealPath("");
		topath = topath + node.getId();
		
		File todir = new File(topath);
		if(!todir.exists()){
			addMessage("Rs[̃fBNg͊ɂ܂ " + topath);
			return true;
		}
		
		String exabspath = extarget.getAbsolutePath();
		exabspath = exabspath.substring(0, exabspath.lastIndexOf(ArUtil.SV_FILE_SEPARATOR));
		
		if(exabspath.equals(todir.getAbsolutePath())){
			addMessage("Rs[悪Rs[t@CƓ̂łB");
			return true;
		}
		
		try {
			FileUtils.copyFileToDirectory(extarget, todir);
		} catch (IOException e) {
			throw new RuntimeException("t@CRs[Ɏs", e);
		}
		
		addMessage("t@CRs[܂B");
		return true;

	}
	
	/**
	 * \tifBNgj
	 * @return
	 */
	private boolean pasteDir(){
	
		String expath = (String)super.context.getSession().getAttribute("COPY_TARGET");
		expath = super.context.getServletContext().getRealPath("") + expath;
		
		File extarget = new File(expath);
		if(!extarget.exists()){
			addMessage("Rs[fBNg͊ɍ폜ꂽ悤łB" + expath);
			return true;
		}
		
		List selectednodes = dirtree.getSelectedNodes(true);
		if(selectednodes.isEmpty()){
			addMessage("ΏۃfBNgȂȂB");
			return true;
		}
		
		TreeNode node = (TreeNode)selectednodes.get(0);
		
		String topath = super.context.getServletContext().getRealPath("");
		topath = topath + node.getId();
		
		File todir = new File(topath);
		if(!todir.exists()){
			addMessage("Rs[̃fBNg͊ɂ܂ " + topath);
			return true;
		}
		
		if(extarget.equals(todir)){
			addMessage("Rs[悪fBNgłB");
			return true;
		}
		
		
		try {
			FileUtils.copyDirectoryToDirectory(extarget, todir);
		} catch (IOException e) {
			throw new RuntimeException("fBNgƃRs[Ɏs", e);
		}
		
		addMessage("fBNgRs[܂B");
		return true;

	}
	
	

	public boolean onClickFilrRename(){
		
		String selfile = targetfile.getValue();
		if(selfile.equals("")){
			addMessage("t@CIĂ܂B");
			return true;
		}

		String filename = inputfilename.getValue();
		if(filename.equals("")){
			addMessage("t@C͂Ă܂B");
			return true;
		}
		
		//@fBNgIĂȂꍇ̂
		List selected = dirtree.getSelectedNodes(true);
		if(selected.isEmpty()){
			addMessage("fBNg킩ȂȂB");
			return true;
		}
		
		
		//@ύXfBNgpXҏW
		TreeNode node = (TreeNode)selected.get(0);
		String abspath = super.context.getServletContext().getRealPath("");
		String renamepath = abspath + "/" + node.getId() + "/";

		//@ɂ閼OȂʖ
		if(new File(renamepath + filename).exists()){
			addMessage("ɑ݂fBNg܂̓t@CłB");
			return true;
		}
		
		File file = new File(renamepath + selfile); 
		file.renameTo(new File(renamepath + filename));
		
		addMessage(node.getId() + "/" + selfile +"  " + node.getId() + "/" + filename + " ɕύX܂B");
		
		return true;
		
	}
	

	public boolean onClickFileMake(){
		
		String filename = inputfilename.getValue();
		if(filename.equals("")){
			addMessage("t@C͂Ă܂B");
			return true;
		}
		
		//@fBNgIĂȂꍇ̂
		List selected = dirtree.getSelectedNodes(true);
		if(selected.isEmpty()){
			addMessage("fBNg킩ȂȂB");
			return true;
		}
		
		
		//@ύXfBNgpXҏW
		TreeNode node = (TreeNode)selected.get(0);
		String abspath = super.context.getServletContext().getRealPath("");
		String renamepath = abspath + "/" + node.getId() + "/";

		//@ɂ閼OȂʖ
		if(new File(renamepath + filename).exists()){
			addMessage("ɑ݂fBNg܂̓t@CłB");
			return true;
		}
		
		File file = new File(renamepath + filename); 
		try {
			FileUtils.writeStringToFile(file, "");
		} catch (IOException e) {
			e.printStackTrace();
			throw new RuntimeException("t@CVK쐬Ɏs",e);
		}
		
		addMessage(node.getId() + "/" + filename + " 쐬܂B");

		return true;
		
	}



}
