/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.tree;

import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.tree.BaseTree;
import org.apache.wicket.model.IModel;

public class LabelIconPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference RESOURCE_FOLDER_OPEN = new ResourceReference(LabelIconPanel.class, "res/folder-open.gif");
    private static final ResourceReference RESOURCE_FOLDER_CLOSED = new ResourceReference(LabelIconPanel.class, "res/folder-closed.gif");
    private static final ResourceReference RESOURCE_ITEM = new ResourceReference(LabelIconPanel.class, "res/item.gif");

    public LabelIconPanel(String id, IModel model, BaseTree tree) {
        super(id, model);
        this.addComponents(model, tree);
    }

    protected void addComponents(IModel model, BaseTree tree) {
        this.add(this.newImageComponent("icon", tree, model));
        this.add(this.newContentComponent("content", tree, model));
    }

    protected Component newImageComponent(String componentId, final BaseTree tree, final IModel model) {
        return new Image(componentId){
            private static final long serialVersionUID = 1L;

            protected ResourceReference getImageResourceReference() {
                return LabelIconPanel.this.getImageResourceReference(tree, (TreeNode)model.getObject());
            }
        };
    }

    protected Component newContentComponent(String componentId, BaseTree tree, IModel model) {
        return new Label(componentId, model);
    }

    protected ResourceReference getImageResourceReference(BaseTree tree, TreeNode node) {
        if (node.isLeaf()) {
            return this.getResourceItemLeaf(node);
        }
        if (tree.getTreeState().isNodeExpanded(node)) {
            return this.getResourceFolderOpen(node);
        }
        return this.getResourceFolderClosed(node);
    }

    protected IModel wrapNodeModel(IModel nodeModel) {
        return nodeModel;
    }

    protected ResourceReference getResourceFolderClosed(TreeNode node) {
        return RESOURCE_FOLDER_CLOSED;
    }

    protected ResourceReference getResourceFolderOpen(TreeNode node) {
        return RESOURCE_FOLDER_OPEN;
    }

    protected ResourceReference getResourceItemLeaf(TreeNode node) {
        return RESOURCE_ITEM;
    }
}

