/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request.urlcompressing;

import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.behavior.IActivePageBehaviorListener;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.listener.IListenerInterfaceRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class UrlCompressingWebCodingStrategy
extends WebRequestCodingStrategy {
    protected CharSequence encode(RequestCycle requestCycle, IListenerInterfaceRequestTarget requestTarget) {
        RequestListenerInterface rli = requestTarget.getRequestListenerInterface();
        AppendingStringBuffer url = new AppendingStringBuffer(64);
        url.append('?');
        url.append("wicket:interface");
        url.append('=');
        Component component = requestTarget.getTarget();
        Page page = component.getPage();
        IPageMap pageMap = page.getPageMap();
        if (!pageMap.isDefault()) {
            url.append(pageMap.getName());
        }
        url.append(':');
        String listenerName = rli.getName();
        if (page instanceof WebPage && !"IResourceListener".equals(listenerName)) {
            url.append(page.getId());
            url.append(':');
            url.append(((WebPage)page).getUrlCompressor().getUIDForComponentAndInterface(component, listenerName));
            listenerName = null;
        } else {
            url.append(component.getPath());
        }
        url.append(':');
        int versionNumber = component.getPage().getCurrentVersionNumber();
        if (!rli.getRecordsPageVersion()) {
            url.append(-1);
        } else if (versionNumber > 0) {
            url.append(versionNumber);
        }
        url.append(':');
        if (listenerName != null && !IRedirectListener.INTERFACE.getName().equals(listenerName)) {
            url.append(listenerName);
        }
        url.append(':');
        RequestParameters params = requestTarget.getRequestParameters();
        if (params != null && params.getBehaviorId() != null) {
            url.append(params.getBehaviorId());
        }
        url.append(':');
        if (params != null && params.getUrlDepth() != 0) {
            url.append(params.getUrlDepth());
        }
        if (IActivePageBehaviorListener.INTERFACE.getName().equals(listenerName)) {
            url.append(url.indexOf("?") > -1 ? "&amp;" : "?").append("wicket:ignoreIfNotActive").append("=true");
        }
        return requestCycle.getOriginalResponse().encodeURL(url);
    }
}

