/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.version.undo;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelChange
extends Change {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)ModelChange.class);
    private final Component component;
    private IModel originalModel;

    ModelChange(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("argument component must be not null");
        }
        this.component = component;
        IModel model = component.getModel();
        if (model != null) {
            boolean cloneModel = true;
            if (model instanceof CompoundPropertyModel) {
                if (component instanceof FormComponent) {
                    if (((FormComponent)component).getForm().getModel() == model) {
                        cloneModel = false;
                    }
                } else if (component.getPage().getModel() == model) {
                    cloneModel = false;
                }
            }
            if (cloneModel) {
                model.detach();
                this.originalModel = (IModel)Objects.cloneModel(model);
            } else {
                this.originalModel = model;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("RECORD MODEL CHANGE: changed model of  (" + Classes.simpleName(component.getClass()) + "@" + component.hashCode() + ")");
        }
    }

    public void undo() {
        if (log.isDebugEnabled()) {
            log.debug("UNDO MODEL CHANGE: setting original model " + this.originalModel + " to " + this.component.getPath() + "@" + this.component.hashCode() + ")");
        }
        this.component.setModel(this.originalModel);
    }

    public String toString() {
        return "ModelChange[component: " + this.component.getPath() + "]";
    }
}

