/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.RequestParameters;

public abstract class Request {
    private Page page;
    private RequestParameters requestParameters;

    public String decodeURL(String url) {
        return url;
    }

    public abstract Locale getLocale();

    public Page getPage() {
        return this.page;
    }

    public abstract String getParameter(String var1);

    public abstract Map getParameterMap();

    public abstract String[] getParameters(String var1);

    public abstract String getPath();

    public abstract String getRelativePathPrefixToContextRoot();

    public abstract String getRelativePathPrefixToWicketHandler();

    public String getRelativeURL() {
        return this.getURL();
    }

    public final RequestParameters getRequestParameters() {
        if (this.requestParameters != null) {
            return this.requestParameters;
        }
        IRequestCycleProcessor processor = RequestCycle.get().getProcessor();
        IRequestCodingStrategy encoder = processor.getRequestCodingStrategy();
        if (encoder == null) {
            throw new WicketRuntimeException("request encoder must be not-null (provided by " + processor + ")");
        }
        try {
            this.requestParameters = encoder.decode(this);
        }
        catch (RuntimeException re) {
            this.requestParameters = new RequestParameters();
            throw re;
        }
        if (this.requestParameters == null) {
            throw new WicketRuntimeException("request parameters must be not-null (provided by " + encoder + ")");
        }
        return this.requestParameters;
    }

    public abstract String getURL();

    public void setPage(Page page) {
        this.page = page;
    }

    public boolean mergeVersion() {
        return false;
    }

    public String toString() {
        return "Request[url=" + this.getURL() + "]";
    }
}

