/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.UnsupportedEncodingException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.resource.AbstractStringResourceStream;

public final class StringResourceStream
extends AbstractStringResourceStream {
    private static final long serialVersionUID = 1L;
    private final CharSequence string;

    public StringResourceStream(CharSequence string) {
        this.string = string;
    }

    public StringResourceStream(CharSequence string, String contentType) {
        super(contentType);
        this.string = string;
    }

    public String toString() {
        return ((Object)this.string).toString();
    }

    protected String getString() {
        return this.toString();
    }

    public String asString() {
        return this.getString();
    }

    public long length() {
        if (this.getCharset() != null) {
            try {
                return this.getString().getBytes(this.getCharset().name()).length;
            }
            catch (UnsupportedEncodingException e) {
                throw new WicketRuntimeException("StringResourceStream created with unsupported charset: " + this.getCharset().name());
            }
        }
        return this.getString().getBytes().length;
    }
}

