<?php

/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable 
 *              to obtain it through the world-wide-web, please send a note to 
 *              license@php.net so we can mail you a copy immediately.  
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/02/17] Ver1.1.0Nighty package
 * ======================================================================== 
 */

/**
 * OpenPNE
 * @copyright 2005-2006 OpenPNE Project
 * @link      http://www.tejimaya.com/openpne.shtml
 *
 */

class pc_page_h_message_box extends OpenPNE_Action
{
    function execute($requests)
    {
        $u = $GLOBALS['AUTH']->uid();

        // --- リクエスト変数
        $box = $requests['box'];
        $ru_page = $requests['ru_page'];
        $s_page = $requests['s_page'];
        $save_page = $requests['save_page'];
        $trash_page = $requests['trash_page'];
        // ----------

        $this->set('inc_navi', fetch_inc_navi("h"));

        $this->set('u', $u);

        // 1ページ当たりに表示するメッセージ数
        $page_size = 20;
        $this->set("page_size", $page_size);

        //ボックス判定
        $this->set("box", $box);

        switch ($box) {

        //受信リスト
        case 'inbox':
        default:
            list($ru_list,$is_ru_prev,$is_ru_next) = p_h_message_box_c_message_received_list4c_member_id4range($u, $ru_page, $page_size);
            $this->set("c_message_ru_list", $ru_list);
            $this->set("count_c_message_ru_list", count($ru_list));

            $ru_data = array('ru_page' => $ru_page,'is_ru_prev' => $is_ru_prev,'is_ru_next' => $is_ru_next);

            $this->set("ru_data", $ru_data);
            break;

        //送信済みリスト
        case 'outbox':
            list($s_list,$is_s_prev,$is_s_next) = p_h_message_box_c_message_sent_list4c_member_id4range($u, $s_page, $page_size);
            $this->set("c_message_s_list", $s_list);
            $this->set("count_c_message_s_list", count($s_list));

            $s_data = array('s_page' => $s_page,'is_s_prev' => $is_s_prev,'is_s_next' => $is_s_next);

            $this->set("s_data", $s_data);
            break;

        //下書き保存リスト
        case 'savebox':
            list($save_list,$is_save_prev,$is_save_next) = p_h_message_box_c_message_save_list4c_member_id4range($u, $save_page, $page_size);
            $this->set("c_message_save_list", $save_list);
            $this->set("count_c_message_save_list", count($save_list));

            $save_data = array('save_page' => $save_page,'is_save_prev' => $is_save_prev,'is_save_next' => $is_save_next);

            $this->set("save_data", $save_data);
            break;

        //ごみ箱リスト
        case 'trash':
            list($trash_list,$is_trash_prev,$is_trash_next) = p_h_message_box_c_message_trash_list4c_member_id4range($u, $trash_page, $page_size);
            $this->set("c_message_trash_list", $trash_list);
            $this->set("count_c_message_trash_list", count($trash_list));

            $trash_data = array('trash_page' => $trash_page,'is_trash_prev' => $is_trash_prev,'is_trash_next' => $is_trash_next);

            $this->set("trash_data", $trash_data);
            break;
        }

        return 'success';
    }
}

?>
