<?php

/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *      		that is available at http://www.php.net/license/3_01.txt
 *      		If you did not receive a copy of the PHP license and are unable 
 *      		to obtain it through the world-wide-web, please send a note to 
 *      		license@php.net so we can mail you a copy immediately.  
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/02/17] Ver1.1.0Nighty package
 * ======================================================================== 
 */

//日記のタグ機能を実装
//2007/01/30 KT

/**
 * 日記のタグを追加する
 *@param tag_name		タグの名称
 *@param entry_menber_id 	タグの追加した人（０の場合は管理画面でのADMIN）
 */
function db_tag_insert_c_diary_tag($tag_name, $entry_member_id = '')
{


    $data = array(
        'tag_name' => strval($tag_name),
        'entry_member_id'   => intval($entry_member_id),
        'r_datetime' => db_now(),
    );
    if (!db_insert('c_diary_tag', $data)) {
        return false;
    }

    return true;
}

/*タグを削除する
 *
 *@param c_diary_tag_id		タグのID
 *
 */
function db_tag_delete_c_diary_tag4c_diary_tag_id($c_diary_tag_id) {
    $sql = "DELETE FROM c_diary_tag WHERE c_diary_tag_id = ?";
    $params = intval($c_diary_tag_id);
    db_query($sql, $params);
    return true;
}

/*タグを修正する
 *
 *@param c_diary_tag_id		タグのID
 *@param tag_name		タグの名所
 *@param entry_member_id	操作した人のID
 *
 */
function db_tag_update_c_diary_tag4c_diary_tag_id($tag_name,$entry_member_id = '0',$c_diary_tag_id) {
    $sql = "UPDATE c_diary_tag SET tag_name = ? ,entry_member_id = ? WHERE c_diary_tag_id = ?";
    $params = array($tag_name,intval($entry_member_id),intval($c_diary_tag_id));
    db_query($sql, $params);
    return true;
}

?>
