<?php

/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable 
 *              to obtain it through the world-wide-web, please send a note to 
 *              license@php.net so we can mail you a copy immediately.  
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/02/17] Ver1.1.0Nighty package
 * ======================================================================== 
 */

//日記のタグ機能を実装
//2007/01/30 KT

/**
 * 日記のタグを追加する
 *@param c_diary_id       日記のID
 *@param c_tags_id    タグのID
 */
function setDiaryTag($c_diary_id, $c_tags_id,$c_member_id)
{

    $data = array(
        'c_diary_id' => intval($c_diary_id),
        'c_tags_id' => intval($c_tags_id),
        'entry_member_id' => intval($c_member_id),
        'r_datetime' => db_now(),
    );
    return db_insert(MYNETS_PREFIX_NAME . 'c_diary_tag', $data);
}

/*日記のタグを1こ削除する
 *
 *@param c_diary_tag_id     タグのID
 *
 */
function delDiaryTag($c_diary_tag_id)
{
    $sql = "DELETE FROM " . MYNETS_PREFIX_NAME . "c_diary_tag WHERE c_diary_tag_id = ?";
    $params = intval($c_diary_tag_id);
    db_query($sql, $params);
    return true;
}

/*日記についてるタグを複数削除する
 *
 *@param c_tags_id     タグのID
 *@param c_diary_id
 */

/*タグを修正する
 *
 *@param c_tags_id     タグのID
 *@param tag_name       タグの名所
 *@param entry_member_id    操作した人のID
 *
 */

?>
