require "rubygems"
require "mysql"

class MysqlForWebDB < Mysql
  @@log = Logger.new(STDOUT)
	@@log.level = Logger::DEBUG
	@@log.progname = "MysqlForWebDB"

  # pageIDを取得
  def get_page_id(url)
    # URLをデータベースに格納しIDを取得
    page_id = select_page_id_from_url(url)
    unless page_id
      insert_page(url)
      page_id = select_page_id_from_url(url)
    end
    return page_id;
  end


  # pageテーブルから指定したURLのページIDを取得。存在しない場合はnil
  def select_page_id_from_url(url)
    sql = 'select id from page where url = "' + url + '"'
    result = query_for_webdb(sql)
    if result.num_rows > 0
      column = ""
      result.each { |row|
        column = row[0]
      }
      return column.to_i
    else
      return nil
    end
  end

  # linkテーブルに複数のデータを一度に挿入
  # linksはfrom_idとto_idをkeyに持つハッシュの配列
  def insert_links(links)
    sql = 'insert ignore into link(from_id, to_id) values '
    link_values = []
    links.each do |link|
      value = '(' + link[:from_id].to_s + ', ' + link[:to_id].to_s + ')'
      link_values.push(value)
    end
    sql += link_values.join(",")
    query_for_webdb(sql)
  end

  # linkテーブルにデータを挿入
  def insert_link(from_id, to_id)
    sql = 'insert into link(from_id, to_id) values (' + from_id + ',' + to_id + ')'
    query_for_webdb(sql)
  end

  # pageテーブルにデータを挿入
  def insert_page(url)
    sql = 'insert into page(url) values ("' + url  + '")'
    query_for_webdb(sql)
  end

  # linkテーブルから指定したfrom_id, to_idのリンクIDを取得。存在しない場合はnil
  def get_link_id(from_id, to_id)
    sql = 'select id from link where from_id = ' + from_id + ' and to_id = ' + to_id
    query_for_webdb(sql)
  end

  def query_for_webdb(sql)
    begin
      @@log.debug("execute: " + sql)
      return query(sql)
    rescue => ex
      @@log.warn("Could not execute: " + sql)
    end
  end
  private :get_link_id, :select_page_id_from_url, :query_for_webdb
end