// Copyright (c) 2009 ochakko lab http://www5d.biglobe.ne.jp/~ochikko  All rights reserved.

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// ̃t@C͎RɉςĂ܂܂񂪉ςꍇ̓T|[gOłBŃfobOĂB
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

float WIDTH0;
float HEIGHT0;
float WIDTH1;
float HEIGHT1;

//Gauss
float  weight[8];
float2 offsetX;
float2 offsetY;
float colmult;


// The per-color weighting to be used for luminance calculations in RGB order.
static const float3 LUMINANCE_VECTOR  = float3(0.2125f, 0.7154f, 0.0721f);


// Tone mapping variables
float  fMiddleGray;       // The middle gray key value
float  fBrightPassThreshold;  // Threshold for BrightPass filter
float  fBrightPassOffset; // Offset for BrightPass filter


//YCbCr
float3 RGB2Y = float3( 0.29900f, 0.58700f, 0.11400f );
float3 Cb2RGB = float3( 0.0f, -0.34414f, 1.77200f );
float3 Cr2RGB = float3( 1.40200f, -0.71414f, 0.0f );

float2 CbCr;

//////////////////////////
// texture
//////////////////////////
texture Texture0;
sampler Samp0Linear = sampler_state
{
    Texture = <Texture0>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};
sampler Samp0Point = sampler_state
{
	Texture = <Texture0>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};

texture Texture1;
sampler Samp1Linear = sampler_state
{
    Texture = <Texture1>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};
sampler Samp1Point = sampler_state
{
	Texture = <Texture1>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};

texture Texture2;
sampler Samp2Linear = sampler_state
{
    Texture = <Texture2>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};
sampler Samp2Point = sampler_state
{
	Texture = <Texture2>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};

/////////////////////////////////
//// user߂ݒł萔
/////////////////////////////////
float2 avSampleOffsets[16];	// TvÖʒu
float4 avSampleWeights[16];	// TvȌd

float4 userFL4_0;
float4 userFL4_1;
float4 userFL4_2;
float4 userFL4_3;
float4 userFL4_4;
float4 userFL4_5;
float4 userFL4_6;
float4 userFL4_7;
float4 userFL4_8;
float4 userFL4_9;

texture usertex0;
texture usertex1;
texture usertex2;
texture usertex3;
texture usertex4;
texture usertex5;

	//sampler͎Œ`ĂB
    //`
sampler SampUser0Point = sampler_state
{
	Texture = <usertex0>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};

sampler SampUser1Point = sampler_state
{
	Texture = <usertex1>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};

sampler SampUser2Point = sampler_state
{
	Texture = <usertex2>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};
sampler SampUser3Point = sampler_state
{
	Texture = <usertex3>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
    AddressU = Clamp;
    AddressV = Clamp;
};
sampler SampUser4Point = sampler_state
{
	Texture = <usertex4>;
	MinFilter =LINEAR;
	MagFilter =LINEAR;
	MipFilter = LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

///////////////////////////////////////////////////////

struct VSTEX1_OUTPUT
{
	float4 Pos			: POSITION;
	float2 Tex0			: TEXCOORD0;
};

struct VSTEX4_OUTPUT
{
    float4 Pos			: POSITION;
	float2 Tex0			: TEXCOORD0;
	float2 Tex1			: TEXCOORD1;
	float2 Tex2			: TEXCOORD2;
	float2 Tex3			: TEXCOORD3;
};

struct VSTEX3_OUTPUT
{
    float4 Pos			: POSITION;
	float3 Tex0			: TEXCOORD0;
};


struct VSTEX9_OUTPUT
{
    float4 Pos            : POSITION;
    float2 Tex0            : TEXCOORD0;
    float2 Tex1            : TEXCOORD1;
    float2 Tex2            : TEXCOORD2;
    float2 Tex3            : TEXCOORD3;
    float2 Tex4            : TEXCOORD4;
    float2 Tex5            : TEXCOORD5;
    float2 Tex6            : TEXCOORD6;
    float2 Tex7            : TEXCOORD7;
};

struct VSTEX8_OUTPUT
{
    float4 Pos            : POSITION;
    float2 Tex0            : TEXCOORD0;
    float2 Tex1            : TEXCOORD1;
    float2 Tex2            : TEXCOORD2;
    float2 Tex3            : TEXCOORD3;
    float2 Tex4            : TEXCOORD4;
    float2 Tex5            : TEXCOORD5;
    float2 Tex6            : TEXCOORD6;
    float2 Tex7            : TEXCOORD7;
};

struct VSTLV_OUTPUT
{
    float4  Pos     : POSITION;
    float4  Diffuse : COLOR0;
    float2  Tex0    : TEXCOORD0;
};


struct PS_OUTPUT
{
	float4 Color	: COLOR0;
};

///////////////////////

// ------------------------------------------------------------
// _VF[_vO
// ------------------------------------------------------------

VSTEX1_OUTPUT VS1Tex (
      float4 Pos    : POSITION           // f̒_
     ,float2 Tex    : TEXCOORD0	         // eNX`W
){
    VSTEX1_OUTPUT Out;
    
    Out.Pos = Pos;    
    Out.Tex0 = Tex;
    
    return Out;
}

VSTEX4_OUTPUT VS16Box (
      float4 Pos    : POSITION           // f̒_
     ,float2 Tex    : TEXCOORD0	         // eNX`W
){
    VSTEX4_OUTPUT Out;
    
    Out.Pos = Pos;
    
    Out.Tex0 = Tex + float2(-1.0f/WIDTH0, -1.0f/HEIGHT0);
    Out.Tex1 = Tex + float2(+1.0f/WIDTH0, -1.0f/HEIGHT0);
    Out.Tex2 = Tex + float2(-1.0f/WIDTH0, +1.0f/HEIGHT0);
    Out.Tex3 = Tex + float2(+1.0f/WIDTH0, +1.0f/HEIGHT0);
    
    return Out;
}

VSTEX4_OUTPUT VS9Corn (
      float4 Pos    : POSITION           // f̒_
     ,float2 Tex   : TEXCOORD0	         // eNX`W
){
    VSTEX4_OUTPUT Out;
    
    Out.Pos = Pos;
    
    Out.Tex0 = Tex + float2( 0.0f/WIDTH0,  0.0f/HEIGHT0);
    Out.Tex1 = Tex + float2(+1.0f/WIDTH0,  0.0f/HEIGHT0);
    Out.Tex2 = Tex + float2( 0.0f/WIDTH0, +1.0f/HEIGHT0);
    Out.Tex3 = Tex + float2(+1.0f/WIDTH0, +1.0f/HEIGHT0);
    
    return Out;
}

VSTEX8_OUTPUT VSGaussX (
      float4 Pos    : POSITION,          // f̒_
      float2 Tex    : TEXCOORD0             // eNX`W
){
    VSTEX8_OUTPUT Out;
    
    Out.Pos = Pos;
    
    Out.Tex0 = Tex + float2( - 1.0f/WIDTH0, 0.0f );
    Out.Tex1 = Tex + float2( - 3.0f/WIDTH0, 0.0f );
    Out.Tex2 = Tex + float2( - 5.0f/WIDTH0, 0.0f );
    Out.Tex3 = Tex + float2( - 7.0f/WIDTH0, 0.0f );
    Out.Tex4 = Tex + float2( - 9.0f/WIDTH0, 0.0f );
    Out.Tex5 = Tex + float2( -11.0f/WIDTH0, 0.0f );
    Out.Tex6 = Tex + float2( -13.0f/WIDTH0, 0.0f );
    Out.Tex7 = Tex + float2( -15.0f/WIDTH0, 0.0f );
    
    return Out;
}

VSTEX8_OUTPUT VSGaussY (
      float4 Pos    : POSITION,          // f̒_
      float2 Tex    : TEXCOORD0             // eNX`W
){
    VSTEX8_OUTPUT Out;
    
    Out.Pos = Pos;
    
    Out.Tex0 = Tex + float2( 0.0f, - 1.0f/HEIGHT0 );
    Out.Tex1 = Tex + float2( 0.0f, - 3.0f/HEIGHT0 );
    Out.Tex2 = Tex + float2( 0.0f, - 5.0f/HEIGHT0 );
    Out.Tex3 = Tex + float2( 0.0f, - 7.0f/HEIGHT0 );
    Out.Tex4 = Tex + float2( 0.0f, - 9.0f/HEIGHT0 );
    Out.Tex5 = Tex + float2( 0.0f, -11.0f/HEIGHT0 );
    Out.Tex6 = Tex + float2( 0.0f, -13.0f/HEIGHT0 );
    Out.Tex7 = Tex + float2( 0.0f, -15.0f/HEIGHT0 );
    
    return Out;
}

VSTLV_OUTPUT VSTLV (
      float4 Pos    : POSITION           // f̒_
     ,float4 Diffuse : COLOR0
     ,float2 Tex    : TEXCOORD0	         // eNX`W
){
    VSTLV_OUTPUT Out;
    
    Out.Pos = Pos;
    Out.Diffuse = Diffuse;
    Out.Tex0 = Tex;
    
    return Out;
}


// ------------------------------------------------------------
// sNZVF[_vO
// ------------------------------------------------------------

PS_OUTPUT PSav4( VSTEX4_OUTPUT i )
{
	PS_OUTPUT Output;
	
	float4 col0, col1, col2, col3;
	col0 = tex2D( Samp0Linear, i.Tex0 );
	col1 = tex2D( Samp0Linear, i.Tex1 );
	col2 = tex2D( Samp0Linear, i.Tex2 );
	col3 = tex2D( Samp0Linear, i.Tex3 );
	
	Output.Color = ( col0 + col1 + col2 + col3 ) * 0.25f;	
//	Output.Color.w = 1.0f;

	return Output;
}

PS_OUTPUT PSGaussX(VSTEX8_OUTPUT In)
{   
    PS_OUTPUT Out;
    
    Out.Color  = weight[0] * (tex2D( Samp0Linear, In.Tex0 )
                        + tex2D( Samp0Linear, In.Tex7 + offsetX ));
    Out.Color += weight[1] * (tex2D( Samp0Linear, In.Tex1 )
                        + tex2D( Samp0Linear, In.Tex6 + offsetX ));
    Out.Color += weight[2] * (tex2D( Samp0Linear, In.Tex2 )
                        + tex2D( Samp0Linear, In.Tex5 + offsetX ));
    Out.Color += weight[3] * (tex2D( Samp0Linear, In.Tex3 )
                        + tex2D( Samp0Linear, In.Tex4 + offsetX ));
    Out.Color += weight[4] * (tex2D( Samp0Linear, In.Tex4 )
                        + tex2D( Samp0Linear, In.Tex3 + offsetX ));
    Out.Color += weight[5] * (tex2D( Samp0Linear, In.Tex5 )
                        + tex2D( Samp0Linear, In.Tex2 + offsetX ));
    Out.Color += weight[6] * (tex2D( Samp0Linear, In.Tex6 )
                        + tex2D( Samp0Linear, In.Tex1 + offsetX ));
    Out.Color += weight[7] * (tex2D( Samp0Linear, In.Tex7 )
                        + tex2D( Samp0Linear, In.Tex0 + offsetX ));
    
    Out.Color.xyz *= colmult;
    
    return Out;
}

PS_OUTPUT PSGaussY(VSTEX8_OUTPUT In)
{   
    PS_OUTPUT Out;
    
    Out.Color  = weight[0] * (tex2D( Samp0Linear, In.Tex0 )
                        + tex2D( Samp0Linear, In.Tex7 + offsetY ));
    Out.Color += weight[1] * (tex2D( Samp0Linear, In.Tex1 )
                        + tex2D( Samp0Linear, In.Tex6 + offsetY ));
    Out.Color += weight[2] * (tex2D( Samp0Linear, In.Tex2 )
                        + tex2D( Samp0Linear, In.Tex5 + offsetY ));
    Out.Color += weight[3] * (tex2D( Samp0Linear, In.Tex3 )
                        + tex2D( Samp0Linear, In.Tex4 + offsetY ));
    Out.Color += weight[4] * (tex2D( Samp0Linear, In.Tex4 )
                        + tex2D( Samp0Linear, In.Tex3 + offsetY ));
    Out.Color += weight[5] * (tex2D( Samp0Linear, In.Tex5 )
                        + tex2D( Samp0Linear, In.Tex2 + offsetY ));
    Out.Color += weight[6] * (tex2D( Samp0Linear, In.Tex6 )
                        + tex2D( Samp0Linear, In.Tex1 + offsetY ));
    Out.Color += weight[7] * (tex2D( Samp0Linear, In.Tex7 )
                        + tex2D( Samp0Linear, In.Tex0 + offsetY ));

    Out.Color.xyz *= colmult;
    
    return Out;
}

PS_OUTPUT PSGauss5x5( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	
    float4 sample = 0.0f;

	for( int i=0; i < 13; i++ ){
		sample += avSampleWeights[i] * tex2D( Samp0Point, In.Tex0 + avSampleOffsets[i] );
//		sample += avSampleWeights[i] * tex2D( Samp0Linear, In.Tex0 + avSampleOffsets[i] );
	}
	Out.Color = sample;

	return Out;
}

PS_OUTPUT PSTLVPoint( VSTLV_OUTPUT In )
{
	PS_OUTPUT Out;
	
    float4 sample;
	sample = tex2D( Samp0Point, In.Tex0 );

	Out.Color = sample * In.Diffuse;

	return Out;
}

PS_OUTPUT PSTLVLinear( VSTLV_OUTPUT In )
{
	PS_OUTPUT Out;
	
    float4 sample;
	sample = tex2D( Samp0Linear, In.Tex0 );

	Out.Color = sample * In.Diffuse;

	return Out;
}

PS_OUTPUT PSDownScale4x4( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
    float4 sample = 0.0f;

	for( int i=0; i < 16; i++ )
	{
		sample += tex2D( Samp0Point, In.Tex0 + avSampleOffsets[i] );
	}
    
	Out.Color = sample / 16;
	return Out;
}

PS_OUTPUT PSDownScale2x2( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
    float4 sample = 0.0f;

	for( int i=0; i < 4; i++ )
	{
		sample += tex2D( Samp0Point, In.Tex0 + avSampleOffsets[i] );
	}
    
    Out.Color = sample / 4;
	return Out;
}

PS_OUTPUT PSToneMapFirst( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
    float3 vSample = 0.0f;
    float  fLogLumSum = 0.0f;

    for(int iSample = 0; iSample < 9; iSample++)
    {
        // Compute the sum of log(luminance) throughout the sample points
        vSample = tex2D(Samp0Point, In.Tex0 + avSampleOffsets[iSample]);
        fLogLumSum += log(dot(vSample, LUMINANCE_VECTOR)+0.0001f);
    }
    
    // Divide the sum to complete the average
    fLogLumSum /= 9;

	Out.Color = float4(fLogLumSum, fLogLumSum, fLogLumSum, 1.0f);
    return Out;
}
PS_OUTPUT PSToneMapSecond( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
    float fResampleSum = 0.0f; 
    
    for(int iSample = 0; iSample < 16; iSample++)
    {
        // Compute the sum of luminance throughout the sample points
        fResampleSum += tex2D(Samp0Point, In.Tex0 + avSampleOffsets[iSample]);
    }
    
    // Divide the sum to complete the average
    fResampleSum /= 16;
	Out.Color = float4(fResampleSum, fResampleSum, fResampleSum, 1.0f);
    return Out;
}
PS_OUTPUT PSToneMapFinal( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
    float fResampleSum = 0.0f;
    
    for(int iSample = 0; iSample < 16; iSample++)
    {
        // Compute the sum of luminance throughout the sample points
        fResampleSum += tex2D(Samp0Point, In.Tex0 + avSampleOffsets[iSample]);
    }
    
    // Divide the sum to complete the average, and perform an exp() to complete
    // the average luminance calculation
    fResampleSum = exp(fResampleSum/16);
    Out.Color = float4(fResampleSum, fResampleSum, fResampleSum, 1.0f);
    return Out;
}


PS_OUTPUT PSBrightPass( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	float4 vSample = tex2D( Samp0Point, In.Tex0 );
	float  fAdaptedLum = tex2D( Samp1Point, float2(0.5f, 0.5f) );
	
	// Determine what the pixel's value will be after tone-mapping occurs
	vSample.rgb *= fMiddleGray/(fAdaptedLum + 0.001f);
	
	// Subtract out dark pixels
	vSample.rgb -= fBrightPassThreshold;
	
	// Clamp to 0
	vSample = max(vSample, 0.0f);
	
	// Map the resulting value into the 0 to 1 range. Higher values for
	// BRIGHT_PASS_OFFSET will isolate lights from illuminated scene 
	// objects.
	vSample.rgb /= (fBrightPassOffset + vSample);
    Out.Color = vSample;
	return Out;
}

PS_OUTPUT PSHDRFinalPass( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
    float4 vSample = tex2D(Samp0Point, In.Tex0);
    float4 vBloom = tex2D(Samp1Linear, In.Tex0);
	float fAdaptedLum = tex2D(Samp2Point, float2(0.5f, 0.5f));
	
    // Map the high range of color values into a range appropriate for
    // display, taking into account the user's adaptation level, and selected
    // values for for middle gray and white cutoff.
	vSample.rgb *= fMiddleGray/(fAdaptedLum + 0.001f);
	vSample.rgb /= (1.0f+vSample);
    
    // Add the star and bloom post processing effects
    vSample += vBloom;
    Out.Color = vSample;
    return Out;
}

PS_OUTPUT PSMono( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;

	float4 vSample;
	vSample = tex2D( Samp0Point, In.Tex0 );

	Out.Color.xyz = dot( vSample.xyz, RGB2Y );
	Out.Color.w = vSample.w;

    return Out;
}

PS_OUTPUT PSCbCr( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;

	float4 vSample = tex2D( Samp0Point, In.Tex0 );

	float3 YCbCr;
	YCbCr.x = dot( vSample.xyz, RGB2Y );
	
	YCbCr.y = CbCr.x;//萔(wl)
	YCbCr.z = CbCr.y;//萔(wl)
	
	float3 newrgb = YCbCr.x
			+ mul( Cb2RGB, YCbCr.y )
			+ mul( Cr2RGB, YCbCr.z );
			
	Out.Color.xyz = newrgb;
	Out.Color.w = vSample.w;		

    return Out;
}

PS_OUTPUT PSDummy( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;

	float4 vSample = tex2D( SampUser0Point, In.Tex0 );
	Out.Color = vSample * userFL4_0;

	return Out;
}

// ------------------------------------------------------------
// eNjbN
// ------------------------------------------------------------
technique PostEffectBlur0
{
    pass P0// PU{bNXtB^TvO
    {
        VertexShader = compile vs_2_0 VS16Box();
        PixelShader  = compile ps_2_0 PSav4();        
    }
    pass P1// XR[tB^TvO
    {
        VertexShader = compile vs_2_0 VS9Corn();
        PixelShader  = compile ps_2_0 PSav4();        
    }
    pass P2// Gauss5x5tB^TvO
    {
        VertexShader = compile vs_2_0 VS1Tex();
        PixelShader  = compile ps_2_0 PSGauss5x5();        
    }
}

technique PostEffectBlurGauss
{
    pass P0
    {
        VertexShader = compile vs_2_0 VSGaussX();
        PixelShader  = compile ps_2_0 PSGaussX();
    }
    pass P1
    {
        VertexShader = compile vs_2_0 VSGaussY();
        PixelShader  = compile ps_2_0 PSGaussY();
    }
}

technique PostEffectTLV
{
	//E3DBlendRTTexturesrcdestƂłꂼĂяoB
	//blend̂͌Œ@\ŁiRenderStateŁjsB
    pass P0
    {
        VertexShader = compile vs_2_0 VSTLV();
        PixelShader  = compile ps_2_0 PSTLVPoint();
    }
    pass P1
    {
        VertexShader = compile vs_2_0 VSTLV();
        PixelShader  = compile ps_2_0 PSTLVLinear();
    }
}

technique PostEffectDownScale
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSDownScale4x4();
	}

	pass P1
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSDownScale2x2();
	}

}

technique PostEffectToneMap
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSToneMapFirst();
	}

	pass P1
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSToneMapSecond();
	}

	pass P2
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSToneMapFinal();
	}

}

technique PostEffectBrightPass
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSBrightPass();
	}
}

technique PostEffectHDRFinal
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSHDRFinalPass();
	}
}

technique PostEffectMono
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSMono();
	}
}

technique PostEffectCbCr
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSCbCr();
	}
}











































































































//////////////////////////////////////////////
// user`eNjbN
//////////////////////////////////////////////


// ------------------------------------------------------------
// _VF[_vO
// ------------------------------------------------------------
VSTEX3_OUTPUT VS3Tex (
      float4 Pos    : POSITION           // f̒_
     ,float3 Tex    : TEXCOORD0	         // eNX`W
){
   VSTEX3_OUTPUT Out;
    Out.Pos = Pos;
	Out.Tex0 = Tex;
    return Out;
}



VSTEX1_OUTPUT VS2Tex (
      float4 Pos    : POSITION           // f̒_
     ,float2 Tex    : TEXCOORD0	         // eNX`W
){
    VSTEX1_OUTPUT Out;
    
    Out.Pos = Pos;
//    Out.Pos = Pos - float4(1.1001f, -1.1001f, 0.0f, 0.0f);
	Out.Tex0 = Tex;
    return Out;
}

VSTEX4_OUTPUT VS4Btx (
      float4 Pos    : POSITION           // f̒_
     ,float2 Tex    : TEXCOORD0	         // eNX`W
){
    VSTEX4_OUTPUT Out;
    Out.Pos = Pos;
    Out.Tex0 = Tex + float2(-1.0/userFL4_0[2], 0.0);
    Out.Tex1 = Tex + float2(1.0/userFL4_0[2], 0.0);
    Out.Tex2 = Tex + float2(0.0, 1.0/userFL4_0[3]);
    Out.Tex3 = Tex + float2(0.0, -1.0/userFL4_0[3]);
    return Out;
}

VSTEX9_OUTPUT VS9Btx (
      float4 Pos    : POSITION           // f̒_
     ,float2 Tex    : TEXCOORD0	         // eNX`W
){
    VSTEX9_OUTPUT Out;
    Out.Pos = Pos;
    Out.Tex0 = Tex + float2(-1.0/userFL4_0[2], -1.0/userFL4_0[3]);
    Out.Tex1 = Tex + float2(-1.0/userFL4_0[2], -0.0/userFL4_0[3]);
    Out.Tex2 = Tex + float2(-1.0/userFL4_0[2], +1.0/userFL4_0[3]);
    Out.Tex3 = Tex + float2(-0.0/userFL4_0[2], -1.0/userFL4_0[3]);
    Out.Tex4 = Tex + float2(-0.0/userFL4_0[2], -0.0/userFL4_0[3]);
    Out.Tex5 = Tex + float2(-0.0/userFL4_0[2], +1.0/userFL4_0[3]);
    Out.Tex6 = Tex + float2(+1.0/userFL4_0[2], -1.0/userFL4_0[3]);
    Out.Tex7 = Tex + float2(+1.0/userFL4_0[2], -0.0/userFL4_0[3]);
    return Out;
}


// ------------------------------------------------------------
// sNZVF[_vO
// ------------------------------------------------------------


////////////////////////////////////////////////////////痬̗͊w֘A
//W
PS_OUTPUT PSUserCopy( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	Out.Color.xyz = tex2D( SampUser0Point, In.Tex0 ).xyz;
	Out.Color.w = tex2D( SampUser0Point, In.Tex0 ).w;
	return Out;
}



//イP
PS_OUTPUT PSUserIryu( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;

	float c,u,v,p,s,u0,u1,u2,u3,u5,u6,u7,v0,v1,v2,v3,v5,v6,v7,iu,iv,f4,inv,u11,u33,u55,u77,v11,v33,v55,v77;
	float fxa,fxb,fxc,kkk1;
	u= tex2D( SampUser0Point, In.Tex4 ).x;
	iu= u;
	v= tex2D( SampUser0Point, In.Tex4 ).y;
	iv= v;
	p= tex2D( SampUser0Point, In.Tex4 ).z;
	s= tex2D( SampUser0Point, In.Tex4 ).w;

	u0=tex2D( SampUser0Point, In.Tex0 ).x;
	u1=tex2D( SampUser0Point, In.Tex1 ).x;
	u2=tex2D( SampUser0Point, In.Tex2 ).x;
	u3=tex2D( SampUser0Point, In.Tex3 ).x;
	u5=tex2D( SampUser0Point, In.Tex5 ).x;
	u6=tex2D( SampUser0Point, In.Tex6 ).x;
	u7=tex2D( SampUser0Point, In.Tex7 ).x;

	v0=tex2D( SampUser0Point, In.Tex0 ).y;
	v1=tex2D( SampUser0Point, In.Tex1 ).y;
	v2=tex2D( SampUser0Point, In.Tex2 ).y;
	v3=tex2D( SampUser0Point, In.Tex3 ).y;
	v5=tex2D( SampUser0Point, In.Tex5 ).y;
	v6=tex2D( SampUser0Point, In.Tex6 ).y;
	v7=tex2D( SampUser0Point, In.Tex7 ).y;

	u11=tex2D( SampUser0Point, In.Tex4+float2(0.0/userFL4_0[2], -1.0/userFL4_0[3]) ).x;
	u33=tex2D( SampUser0Point, In.Tex4+float2(-1.0/userFL4_0[2], 0.0/userFL4_0[3]) ).x;
	u55=tex2D( SampUser0Point, In.Tex4+float2(1.0/userFL4_0[2], 0.0/userFL4_0[3]) ).x;
	u77=tex2D( SampUser0Point, In.Tex4+float2(0.0/userFL4_0[2], 1.0/userFL4_0[3]) ).x;
	v11=tex2D( SampUser0Point, In.Tex4+float2(0.0/userFL4_0[2], -1.0/userFL4_0[3]) ).y;
	v33=tex2D( SampUser0Point, In.Tex4+float2(-1.0/userFL4_0[2], 0.0/userFL4_0[3]) ).y;
	v55=tex2D( SampUser0Point, In.Tex4+float2(1.0/userFL4_0[2], 0.0/userFL4_0[3]) ).y;
	v77=tex2D( SampUser0Point, In.Tex4+float2(0.0/userFL4_0[2], 1.0/userFL4_0[3]) ).y;

//Uڗ
//y
//`FbNOƂ̓CfgP̂Ƃ낾
	c = ( iv + v3 + v7 + v6 ) * 0.25f;

//			if c>0.0:u.a.cnt-=c*(iu.a.cnt-iu.a.b0)*t
//			if c<0.0:u.a.cnt-=c*(iu.a.b1-iu.a.cnt)*t
	u-=max(0.0,c)*(iu-u3)*userFL4_0[0];
	u-=min(0.0,c)*(u5-iu)*userFL4_0[0];
//x
//			if iu.a.cnt>0.0:u.a.cnt-=iu.a.cnt*(iu.a.cnt-iu.a0.cnt)*t
//			if iu.a.cnt<0.0:u.a.cnt-=iu.a.cnt*(iu.a1.cnt-iu.a.cnt)*t
	u-=max(0.0,iu)*(iu-u1)*userFL4_0[0];
	u-=min(0.0,iu)*(u7-iu)*userFL4_0[0];

//Vڗ
//x
//			c=(iu.a0.cnt+iu.a.cnt+iu.a0.b1+iu.a.b1)/4.0
//			if c>0.0:v.a.cnt-=c*(iv.a.cnt-iv.a0.cnt)*t
//			if c<0.0:v.a.cnt-=c*(iv.a1.cnt-iv.a.cnt)*t
	c = ( u1 + iu + u2 + u5 ) * 0.25f;
	v-=max(0.0,c)*(iv-v1)*userFL4_0[0];
	v-=min(0.0,c)*(v7-iv)*userFL4_0[0];
//y
//			if iv.a.cnt>0.0:v.a.cnt-=iv.a.cnt*(iv.a.cnt-iv.a.b0)*t
//			if iv.a.cnt<0.0:v.a.cnt-=iv.a.cnt*(iv.a.b1-iv.a.cnt)*t
	v-=max(0.0,iv)*(iv-v3)*userFL4_0[0];
	v-=min(0.0,iv)*(v5-iv)*userFL4_0[0];













//			if iv.a.b>=0.0{
//				fy_a=(iv.a.(b+1)-3.0*(iv.a.b-iv.a.(b-1))-iv.a.(b-2))/6.0
//				fy_b=(iv.a.(b+1)+iv.a.(b-1))/2.0-iv.a.b
//				fy_c=(2.0*iv.a.(b+1)+3.0*iv.a.b-6.0*iv.a.(b-1)+iv.a.(b-2))/6.0
//			}else{
//				fy_a=(iv.a.(b+2)-3.0*(iv.a.(b+1)-iv.a.b)-iv.a.(b-1))/6.0
//				fy_b=(iv.a.(b+1)+iv.a.(b-1))/2.0-iv.a.b
//				fy_c=(-iv.a.(b+2)+6.0*iv.a.(b+1)-3.0*iv.a.b-2.0*iv.a.(b-1))/6.0
//			}
//			kkk1=0.0-t*iv.a.b
//			kkk2=kkk1*kkk1
//			kkk3=kkk2*kkk1
//			v.a.b+=kkk3*fy_a+kkk2*fy_b+kkk1*fy_c









//S
//			if kku.a.cnt:u.a.cnt-=Re*(4.0*iu.a.cnt-iu.a1.cnt-iu.a0.cnt-iu.a.b1-iu.a.b0)
//			if kkv.a.cnt:v.a.cnt-=Re*(4.0*iv.a.cnt-iv.a1.cnt-iv.a0.cnt-iv.a.b1-iv.a.b0)
	u-=(4.0*iu-u7-u1-u5-u3)*userFL4_0[1]*userFL4_0[0];
	v-=(4.0*iv-v7-v1-v5-v3)*userFL4_0[1]*userFL4_0[0];


	Out.Color.x = u;
	Out.Color.y = v;
	Out.Color.z = p;
	Out.Color.w = s;
	return Out;
}



//_Co[WFX
PS_OUTPUT PSUserDivrjns( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;

	float c,u,v,p,s,u7,v5,ss,s2;
	u= tex2D( SampUser0Point, In.Tex4 ).x;
	v= tex2D( SampUser0Point, In.Tex4 ).y;
	p= tex2D( SampUser0Point, In.Tex4 ).z;
	ss= tex2D( SampUser1Point, In.Tex4 ).z;
	s2= tex2D( SampUser1Point, In.Tex4 ).x;
	u7=tex2D( SampUser0Point, In.Tex7 ).x;
	v5=tex2D( SampUser0Point, In.Tex5 ).y;
//		repeat wx
//		a=cnt
//		a1=cnt+1
//			repeat wy
//			b1=cnt+1
//			s.a.cnt=v.a1.b1-v.a1.cnt+u.a1.b1-u.a.b1-|v*(kabe1.a1.b1=14)
//			loop
//		loop
//s̃Ef葝₷s.a.cnt=s.a1.b1ɕϊ
//
	s=v5-v+u7-u;
	if (ss==0.0){
		s-=1.0*userFL4_1[0]*userFL4_0[0];
	}
	s*=s2;
	if (userFL4_1[3]==1.0){
		p=0.0f;
	}

	Out.Color.x = u;
	Out.Color.y = v;
	Out.Color.z = p;
	Out.Color.w = s;
	return Out;
}




//red|A\red͑邪
PS_OUTPUT PSUserRedPoisn( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;

	float u,v,s,p,p1,p3,p5,p7,c,c1,c3,c5,c7,ic,d1,red;
	u=tex2D( SampUser0Point, In.Tex4 ).x;
	v=tex2D( SampUser0Point, In.Tex4 ).y;
	s=tex2D( SampUser0Point, In.Tex4 ).w;
	p=tex2D( SampUser0Point, In.Tex4 ).z;
	p1=tex2D( SampUser0Point, In.Tex1 ).z;
	p3=tex2D( SampUser0Point, In.Tex3 ).z;
	p5=tex2D( SampUser0Point, In.Tex5 ).z;
	p7=tex2D( SampUser0Point, In.Tex7 ).z;
	c=tex2D( SampUser1Point, In.Tex4 ).x;
	c1=tex2D( SampUser1Point, In.Tex1 ).x;
	c3=tex2D( SampUser1Point, In.Tex3 ).x;
	c5=tex2D( SampUser1Point, In.Tex5 ).x;
	c7=tex2D( SampUser1Point, In.Tex7 ).x;
	d1=tex2D( SampUser1Point, In.Tex4 ).y;
	red=tex2D( SampUser2Point, In.Tex4 ).x;
//:ip.a.cnt=0*p.a.cnt+4*(p.a1.cnt+ip.a0.cnt+p.a.(cnt+1)+ip.a.(cnt-1)-s.a.cnt)
	p+=(userFL4_1[1]*(p1*c1+p3*c3+p5*c5+p7*c7-s+p*(4.0-c1-c3-c5-c7))-userFL4_1[2]*p)*red*d1;
	Out.Color.x = u;
	Out.Color.y = v;
	Out.Color.z = p;
	Out.Color.w = s;
	return Out;
}



//C
PS_OUTPUT PSUserSyusei( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;

	float u,v,s,p,p1,p3,c,c1,c3;
	s= tex2D( SampUser0Point, In.Tex4 ).w;
	u= tex2D( SampUser0Point, In.Tex4 ).x;
	v= tex2D( SampUser0Point, In.Tex4 ).y;
	p=tex2D( SampUser0Point, In.Tex4 ).z;
	p1=tex2D( SampUser0Point, In.Tex1 ).z;
	p3=tex2D( SampUser0Point, In.Tex3 ).z;
	c=tex2D( SampUser1Point, In.Tex4 ).x;
	c1=tex2D( SampUser1Point, In.Tex1 ).x;
	c3=tex2D( SampUser1Point, In.Tex3 ).x;
//			if kku.a.cnt:u.a.cnt-=p.a.b0-p.a0.b0
//			if kkv.a.cnt:v.a.cnt-=p.a0.cnt-p.a0.b0
// ͂Ef₵ߏp.a.cntp.a1.b1
	u-=(p-p1)*c*c1;
	v-=(p-p3)*c*c3;

	Out.Color.x = u;
	Out.Color.y = v;
	Out.Color.z = p;
	Out.Color.w = s;
	return Out;
}




//Qx\
PS_OUTPUT PSUserUzud( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;
	float ww,u,v,p,s,u0,u1,u2,u3,u5,u6,u7,u8,v0,v1,v2,v3,v5,v6,v7,v8,rix,riy;
	rix=tex2D( SampUser1Point, In.Tex4 ).x;
	riy=tex2D( SampUser1Point, In.Tex4 ).y;

	u0=tex2D( SampUser0Point, In.Tex0 ).x;
	u1=tex2D( SampUser0Point, In.Tex1 ).x;
	u2=tex2D( SampUser0Point, In.Tex2 ).x;
	u3=tex2D( SampUser0Point, In.Tex3 ).x;
	u5=tex2D( SampUser0Point, In.Tex5 ).x;
	u6=tex2D( SampUser0Point, In.Tex6 ).x;
	u7=tex2D( SampUser0Point, In.Tex7 ).x;
	u8=tex2D( SampUser0Point, In.Tex5 + float2(1.0/userFL4_0[2], 0.0) ).x;

	v0=tex2D( SampUser0Point, In.Tex0 ).y;
	v1=tex2D( SampUser0Point, In.Tex1 ).y;
	v2=tex2D( SampUser0Point, In.Tex2 ).y;
	v3=tex2D( SampUser0Point, In.Tex3 ).y;
	v5=tex2D( SampUser0Point, In.Tex5 ).y;
	v6=tex2D( SampUser0Point, In.Tex6 ).y;
	v7=tex2D( SampUser0Point, In.Tex7 ).y;
	v8=tex2D( SampUser0Point, In.Tex5 + float2(1.0/userFL4_0[2], 0.0) ).y;

//w1=u.a.w+u.(a+1).w-u.a.(w+2)-u.(a+1).(w+2)-v.a.w-v.a.(w+1)+v.(a+2).w+v.(a+2).(w+1)
	ww=u3+u6-u5-u8-v1-v2+v7+v8;
	u=-min(ww,0.0)*1.8f;
	v=max(ww,0.0)*1.8f;

	Out.Color.x = u;
	Out.Color.y = v;
	Out.Color.z = 0.0;
	Out.Color.w = 1.0;
	return Out;
}




//ǂ̑x_8bit rgb  32bit x@ɕϊ
PS_OUTPUT PSUserMoveKabe( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;
	float r1,r2,g1,g2,b1,b2,spdx,spdy;
	r1= 1.0*tex2D( SampUser0Point, In.Tex4 ).x*2550.0-1280.0;
	r2= 1.0*tex2D( SampUser1Point, In.Tex4 ).x*2550.0-1280.0;
	g1= 1.0*tex2D( SampUser0Point, In.Tex4 ).y*2550.0;
	g2= 1.0*tex2D( SampUser1Point, In.Tex4 ).y*2550.0;
	b1= 1.0*tex2D( SampUser0Point, In.Tex4 ).z*2550.0;
	b2= 1.0*tex2D( SampUser1Point, In.Tex4 ).z*2550.0;
//	spd=cos(0.01*flm*t)*60.0/1000.0
//	spd*=8.0
//	spd+=128.0
//	spd*=256.0
//	spd*=256.0
//	spdi=int(spd)
//	spdb=spdi\256:spdi/=256
//	spdg=spdi\256:spdi/=256
//	spdr=spdi\256
//	color spdr,spdg,spdb
	spdx=(r1+g1/256.0+b1/65536.0)/80.0;
	spdy=(r2+g2/256.0+b2/65536.0)/80.0;

	Out.Color.x = spdx;
	Out.Color.y = spdy;
	Out.Color.z =0.0f;
	Out.Color.w =1.0f;
	return Out;
}




//gȂEEE_Co[WFXmF
PS_OUTPUT PSUserTesto3( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;

	float c,u,v,p,s,u1,v3,ss;
	u= tex2D( SampUser0Point, In.Tex4 ).x;
	v= tex2D( SampUser0Point, In.Tex4 ).y;
	p= tex2D( SampUser0Point, In.Tex4 ).z;
	s= tex2D( SampUser0Point, In.Tex4 ).w;

	Out.Color.x =10.0;
	Out.Color.y =0.0;
	Out.Color.z =0.0;
	Out.Color.w = 1.0f;
	return Out;
}




//gEEE͊mF
PS_OUTPUT PSUserPressHyoji( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;
	Out.Color.x = -min(tex2D( SampUser0Point, In.Tex4 ).z,0.0)*5.01;
	Out.Color.y = max(tex2D( SampUser0Point, In.Tex4 ).z,0.0)*5.01;
	Out.Color.z = 0.0f;
	Out.Color.w = 1.0f;
	return Out;
}




//ǋEݒ
PS_OUTPUT PSUserKabekyoukaisettei( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;
//			if kabe.a.cnt=13{
//				b0=cnt-1
//				if cnt!wy+1:kkv.a.cnt=0
//				if b0!-1:kkv.a.b0=0
//				if a!wx+1:kku.a.cnt=0
//				if a0!-1:kku.a0.cnt=0

	float c,c1,c3,u,v,p,s,x1,y1,u2,v2;
	u= tex2D( SampUser0Point, In.Tex4 ).x;
	v= tex2D( SampUser0Point, In.Tex4 ).y;
	p= tex2D( SampUser0Point, In.Tex4 ).z;
	s= tex2D( SampUser0Point, In.Tex4 ).w;
	c= tex2D( SampUser1Point, In.Tex4 ).x;
	c3= tex2D( SampUser1Point, In.Tex3 ).x;
	c1= tex2D( SampUser1Point, In.Tex1 ).x;
	x1= tex2D( SampUser2Point, In.Tex4 ).x;
	y1= tex2D( SampUser2Point, In.Tex4 ).y;

	u2=u*c*c1;
	v2=v*c*c3;

	if (abs(x1)>=0.000001){
		u2=x1;
	}
	if (abs(y1)>=0.000001){
		v2=y1;
	}
	Out.Color.x = u2;
	Out.Color.y = v2;
	Out.Color.z = p;
	Out.Color.w = s;

	return Out;
}




//qړ
PS_OUTPUT PSUserRyusiMove( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;
	float u,v;
	u= tex2D( SampUser0Point, In.Tex4 ).x;
	v= tex2D( SampUser0Point, In.Tex4 ).y;

	u+=userFL4_0[0]/userFL4_0[2]*tex2D( SampUser4Point,float2(u,v-0.5/userFL4_0[3]) ).x;
	v+=userFL4_0[0]/userFL4_0[3]*tex2D( SampUser4Point,float2(u-0.5/userFL4_0[2],v) ).y;
	if (v<=0.01){
		u=0.3;
		v=0.02;
	}
	if (v>=0.985){
		u=0.4;
		v=0.0212;
	}
	if (u>=0.985){
		u=0.5;
		v=0.021;
	}
	Out.Color.x =u;
	Out.Color.y =v;
	Out.Color.z =0.0f;
	Out.Color.w =1.0f;
	return Out;
}



//Rǁ@xǁ@red black
PS_OUTPUT PSUserJykbskdkbrdblcksykk( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;
	Out.Color.x = tex2D( SampUser0Point, In.Tex4 ).x;
	Out.Color.y = tex2D( SampUser0Point, In.Tex4 ).y;
	Out.Color.z = tex2D( SampUser0Point, In.Tex4 ).z;
	Out.Color.w = tex2D( SampUser1Point, In.Tex4 ).x;
	return Out;
}




//|A\black
PS_OUTPUT PSUserBlackPoisn( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;
	float u,v,s,p,p1,p3,p5,p7,c,c1,c3,c5,c7,ic,d1,red;
	u=tex2D( SampUser0Point, In.Tex4 ).x;
	v=tex2D( SampUser0Point, In.Tex4 ).y;
	s=tex2D( SampUser0Point, In.Tex4 ).w;
	p=tex2D( SampUser0Point, In.Tex4 ).z;
	p1=tex2D( SampUser0Point, In.Tex1 ).z;
	p3=tex2D( SampUser0Point, In.Tex3 ).z;
	p5=tex2D( SampUser0Point, In.Tex5 ).z;
	p7=tex2D( SampUser0Point, In.Tex7 ).z;
	c=tex2D( SampUser1Point, In.Tex4 ).x;
	c1=tex2D( SampUser1Point, In.Tex1 ).x;
	c3=tex2D( SampUser1Point, In.Tex3 ).x;
	c5=tex2D( SampUser1Point, In.Tex5 ).x;
	c7=tex2D( SampUser1Point, In.Tex7 ).x;
	d1=tex2D( SampUser1Point, In.Tex4 ).y;
	red=1.0-tex2D( SampUser2Point, In.Tex4 ).x;
//:ip.a.cnt=0*p.a.cnt+4*(p.a1.cnt+ip.a0.cnt+p.a.(cnt+1)+ip.a.(cnt-1)-s.a.cnt)
	p+=(userFL4_1[1]*(p1*c1+p3*c3+p5*c5+p7*c7-s+p*(4.0-c1-c3-c5-c7))-userFL4_1[2]*p)*red*d1;

	Out.Color.x = u;
	Out.Color.y = v;
	Out.Color.z = p;
	Out.Color.w = s;
	return Out;
}




//Qx\Q
PS_OUTPUT PSUserTesto9( VSTEX9_OUTPUT In )
{
	PS_OUTPUT Out;
	float ww,u,v,p,s,u0,u1,u2,u3,u4,v4,u5,u6,u7,u8,v0,v1,v2,v3,v5,v6,v7,v8;

	u1=tex2D( SampUser4Point, In.Tex4+float2(0.0,-0.5/userFL4_0[2]) ).x;
	u4=tex2D( SampUser4Point, In.Tex4 ).x;

	v3=tex2D( SampUser4Point, In.Tex4 +float2(-0.5/userFL4_0[2],0.0)).y;
	v4=tex2D( SampUser4Point, In.Tex4 ).y;

	ww=v4-v3+u1-u4;
	u=abs(ww)*6.3f;
	v=max(u-0.5,0.0)*0.63;

	p=tex2D( SampUser4Point, In.Tex4 ).x;
	if (p==0.0){
		u=1.0;
		v=1.0;
		ww=1.0;
}

	Out.Color.x = u;
	Out.Color.y = v;
	Out.Color.z = ww;
	Out.Color.w = 1.0;
	return Out;
}









////////////////////////////////////////////////////////܂ŗ̗͊w֘A
////////////////////////////////////////////////////////烌Cg֘A






//gpuobt@ɕ_i[ =li[ (1)
PS_OUTPUT PSUserDainyuu( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	float4 xyzw;
	xyzw=tex2D( SampUser0Point,In.Tex0 );
	if (int(In.Tex0.x*userFL4_0[1])==int(userFL4_0[0])){
	xyzw=float4(userFL4_1[0],userFL4_1[1],userFL4_1[2],userFL4_1[3]);
}

	Out.Color = xyzw;
	return Out;
}


//ݒ̈ꕔ_P   (2)
PS_OUTPUT PSUserSisensiten1( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	float3 cb,cc;
//		cb0=-0.005*yoko/ipbi+0.01*mcnt1/ipbi
//		cb1=0.005*tate/ipbi-0.01*cnt/ipbi
//		cb2=9.3
	cb.x=(0.005-0.01*(In.Tex0.x) )*userFL4_0[2];
	cb.y=(0.005-0.01*(In.Tex0.y) )*userFL4_0[3];
	cb.z=11.3/512.0*userFL4_0[3];
	cb=normalize(cb);
	cc=cb;

//Ɍ]s
	cc.y=cb.y*cos(0.47)- cb.z*sin(0.47);
	cc.z=cb.y*sin(0.47)+ cb.z*cos(0.47);
	cb=cc;
//cɃVĂ]
	cb.z=cc.z*cos(userFL4_1[3])- cc.x*sin(userFL4_1[3]);
	cb.x=cc.z*sin(userFL4_1[3])+ cc.x*cos(userFL4_1[3]);


	Out.Color.xyz = normalize(cb)*65536.0;
	Out.Color.w = -1.0;
//}id
	return Out;
}


//ݒ̈ꕔ_Q (3)
PS_OUTPUT PSUserSisensiten2( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
//		ca0=0.0
//		ca1=3.0
//		ca2=-7.0

	Out.Color.x = userFL4_1[0];
	Out.Color.y = userFL4_1[1];
	Out.Color.z = userFL4_1[2];
	Out.Color.w = 1.0;
//̔
	return Out;
}



//~g̓蔻 (4)
PS_OUTPUT PSUserEn( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	float b,c,d4,kai,htmate,t,usfl1;
	float4 kyu;
	float3 q,ca,cb;

//	q0=ca0-kyu.0.cnt
//	q1=ca1-kyu.1.cnt
//	q2=ca2-kyu.2.cnt
//	qt2=q0*q0+q1*q1+q2*q2
//	b=q0*cb0+q1*cb1+q2*cb2
//	c=qt2-kyu.4.cnt
//	d4=b*b-c
//	if d4>0.0:kai=-sqrt(d4)-b
//	if (d4>0.0)&(kai>0.0)&(t>kai){
//		t=kai
//		htmate=cnt
//	}

	usfl1=userFL4_0[0];
	cb=tex2D( SampUser0Point,In.Tex0 ).xyz;
	htmate=tex2D( SampUser0Point,In.Tex0 ).w;
	ca=tex2D( SampUser1Point,In.Tex0 ).xyz;
	t=sqrt(dot(cb,cb));
	cb=cb/t;


	kyu=tex2D( SampUser4Point,float2(usfl1/userFL4_0[1],0.0) );
	q=ca-kyu.xyz;
	b=dot(q,cb);
	c=dot(q,q)-pow(kyu.w,2);
	d4=b*b-c;

	if (d4>=0.0){
	kai=-sqrt(d4)-b;
		if (t>=kai){
			if (kai>=0.0){
			t=kai;
			htmate=usfl1;
			}
		}
	}

	usfl1+=1.0;





	kyu=tex2D( SampUser4Point,float2(usfl1/userFL4_0[1],0.0) );
	q=ca-kyu.xyz;
	b=dot(q,cb);
	c=dot(q,q)-pow(kyu.w,2);
	d4=b*b-c;

	if (d4>=0.0){
	kai=-sqrt(d4)-b;
		if (t>=kai){
			if (kai>=0.0){
			t=kai;
			htmate=usfl1;
			}
		}
	}



	Out.Color.xyz = cb*t;
	Out.Color.w = htmate;
	return Out;
}




//ˎ̈ʒuĐݒ (5)
PS_OUTPUT PSUser105( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	float3 ca,cb;
	float www,ww;
	ca=tex2D( SampUser1Point,In.Tex0).xyz;
	cb=tex2D( SampUser0Point,In.Tex0).xyz;
	www=tex2D( SampUser1Point,In.Tex0).w;
	if (sqrt(dot(cb,cb))<=65530.0){
		www=www*0.8;
		ca=ca+cb;
}
	Out.Color.xyz=ca;
	Out.Color.w=www;
	return Out;
}




//ˎ̔˃xNgĐݒ (6)
PS_OUTPUT PSUser106( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	float3 cb,kxyz,housen;
	float htmate;
	cb=normalize(tex2D( SampUser0Point,In.Tex0).xyz);
	htmate=tex2D( SampUser0Point,In.Tex0).w;
	if (htmate!=-1){
		housen=normalize(tex2D( SampUser1Point,In.Tex0).xyz-tex2D( SampUser4Point,float2(htmate/userFL4_0[1],0.0)).xyz);
		cb=-2.0*housen*dot(housen,cb)+cb;
}

	Out.Color.xyz=65536.0*cb;
	Out.Color.w=-1.0;
	return Out;
}


PS_OUTPUT PSUser107( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;

	Out.Color.xyz=tex2D( SampUser0Point,In.Tex0).xyz+tex2D( SampUser1Point,In.Tex0).xyz*1.0+tex2D( SampUser2Point,In.Tex0).xyz*2.0+tex2D( SampUser3Point,In.Tex0).xyz*4.0+tex2D( SampUser4Point,In.Tex0).xyz*8.0;
	Out.Color.w=1.0;
	return Out;
}

PS_OUTPUT PSUser108( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	float3 u1,u2,u3,u4,u5,u6,u7,u8,u9;
	u1=tex2D( SampUser4Point, In.Tex0+float2(-1.0/userFL4_0[2],-1.0/userFL4_0[3]) ).xyz;
	u2=tex2D( SampUser4Point, In.Tex0+float2(0.0/userFL4_0[2],-1.0/userFL4_0[3]) ).xyz;
	u3=tex2D( SampUser4Point, In.Tex0+float2(1.0/userFL4_0[2],-1.0/userFL4_0[3]) ).xyz;
	u4=tex2D( SampUser4Point, In.Tex0+float2(-1.0/userFL4_0[2],0.0) ).xyz;
	u5=tex2D( SampUser4Point, In.Tex0+float2(0.0/userFL4_0[2],0.0) ).xyz;
	u6=tex2D( SampUser4Point, In.Tex0+float2(1.0/userFL4_0[2],0.0) ).xyz;
	u7=tex2D( SampUser4Point, In.Tex0+float2(-1.0/userFL4_0[2],1.0/userFL4_0[3]) ).xyz;
	u8=tex2D( SampUser4Point, In.Tex0+float2(0.0/userFL4_0[2],1.0/userFL4_0[3]) ).xyz;
	u9=tex2D( SampUser4Point, In.Tex0+float2(1.0/userFL4_0[2],1.0/userFL4_0[3]) ).xyz;

	Out.Color.xyz=(u1+u2*2.0+u3+u4*2.0+u5*4.0+u6*2.0+u7+u8*2.0+u9)/11.0;
	Out.Color.w=1.0;
	return Out;
}

PS_OUTPUT PSUser109( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	float3 u1,u2,u3,u4,u5,u6,u7,u8,u9;
	u1=tex2D( SampUser4Point, In.Tex0+float2(-1.0/userFL4_0[2],-1.0/userFL4_0[3]) ).xyz;
	u2=tex2D( SampUser4Point, In.Tex0+float2(0.0/userFL4_0[2],-1.0/userFL4_0[3]) ).xyz;
	u3=tex2D( SampUser4Point, In.Tex0+float2(1.0/userFL4_0[2],-1.0/userFL4_0[3]) ).xyz;
	u4=tex2D( SampUser4Point, In.Tex0+float2(-1.0/userFL4_0[2],0.0) ).xyz;
	u5=tex2D( SampUser4Point, In.Tex0+float2(0.0/userFL4_0[2],0.0) ).xyz;
	u6=tex2D( SampUser4Point, In.Tex0+float2(1.0/userFL4_0[2],0.0) ).xyz;
	u7=tex2D( SampUser4Point, In.Tex0+float2(-1.0/userFL4_0[2],1.0/userFL4_0[3]) ).xyz;
	u8=tex2D( SampUser4Point, In.Tex0+float2(0.0/userFL4_0[2],1.0/userFL4_0[3]) ).xyz;
	u9=tex2D( SampUser4Point, In.Tex0+float2(1.0/userFL4_0[2],1.0/userFL4_0[3]) ).xyz;

	Out.Color.xyz=max ( (u1+u2*2.0+u3+u4*2.0+u5*4.0+u6*2.0+u7+u8*2.0+u9)/16.0-1.0 ,0.0);
	Out.Color.w=1.0;
	return Out;
}






//`P  (10)
PS_OUTPUT PSUser110( VSTEX1_OUTPUT In )
{
	PS_OUTPUT Out;
	float ww,naiseki,vmr,vmg,vmb;
	float3 cb;

//naiseki=(cb0*light0+cb1*light1+cb2*light2)
//vmr=(1.5+naiseki)*120.0:if naiseki>0.96:vmr+=(naiseki-0.96)*8200.0
//vmg=(1.5+naiseki)*120.0:if naiseki>0.96:vmg+=(naiseki-0.96)*8200.0
//vmb=(1.5+naiseki)*190.0:if naiseki>0.96:vmb+=(naiseki-0.96)*8200.0

	cb=normalize( tex2D( SampUser0Point, In.Tex0 ).xyz );
	ww=tex2D( SampUser1Point, In.Tex0 ).w;

	naiseki=cb.x*userFL4_1[0]+cb.y*userFL4_1[1]+cb.z*userFL4_1[2];

	vmr=(1.56+naiseki/1.5)*120.0;
	vmg=(1.56+naiseki/1.5)*120.0;
	vmb=(1.66+naiseki/1.5)*190.0;

	if (naiseki>=0.95){
		vmr+=(naiseki-0.95)*(naiseki-0.95)*8200.0;
		vmg+=(naiseki-0.95)*(naiseki-0.95)*8200.0;
		vmb+=(naiseki-0.95)*(naiseki-0.95)*8200.0;
	}

	Out.Color.x = min(1.0,vmr/256.0*ww)+(1.0-ww)*userFL4_8[0];
	Out.Color.y = min(1.0,vmg/256.0*ww)+(1.0-ww)*userFL4_8[1];
	Out.Color.z = min(1.0,vmb/256.0*ww)+(1.0-ww)*userFL4_8[2];
	Out.Color.w = 1.0;

	return Out;
}






































































//////////////////////////////////////////////
// user`eNjbN
//////////////////////////////////////////////

//0=̗͊w֘A
technique PostEffectUser0
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSDummy();
	}

	//   W  Rs[
	pass P1
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUserCopy();
	}

	//   ڗ
	pass P2
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserIryu();
	}

	//   _Co[WFX
	pass P3
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserDivrjns();
	}

	//   |A\red
	pass P4
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserRedPoisn();
	}

	//   C
	pass P5
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserSyusei();
	}

	//   Qx\
	pass P6
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserUzud();
	}

	//   ǂ̑x_8bit rgb  32bit x@ɕϊ
	pass P7
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserMoveKabe();
	}

	//   gĂȂeXg3
	pass P8
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserTesto3();
	}

	//   ͕\
	pass P9
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserPressHyoji();
	}

	//   ǋEݒ
	pass P10
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserKabekyoukaisettei();
	}

	//@@qړ
	pass P11
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserRyusiMove();
	}

	//@@Rǁ@xǁ@red black
	pass P12
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserJykbskdkbrdblcksykk();
	}

	//@@|A\black
	pass P13
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserBlackPoisn();
	}

	//@@Qx\Q
	pass P14
	{
		VertexShader = compile vs_2_0 VS9Btx();
		PixelShader = compile ps_2_0 PSUserTesto9();
	}
}





//1=A^CCg֘A
technique PostEffectUser1
{

	pass P0	//Rs[
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUserCopy();
	}
	pass P1	//li[@(_)
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUserDainyuu();
	}
	pass P2 //l̈ꕔ@_Ă邾
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUserSisensiten1();
	}
	pass P3 //l̈ꕔ@_Ă邾
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUserSisensiten2();
	}
	pass P4
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUserEn();
	}
	pass P5
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUser105();
	}
	pass P6
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUser106();
	}
	pass P7
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUser107();
	}
	pass P8
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUser108();
	}
	pass P9
	{
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUser109();
	}
	pass P10
	{
		//`
		VertexShader = compile vs_2_0 VS2Tex();
		PixelShader = compile ps_2_0 PSUser110();
	}
}











































































technique PostEffectUser2
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSDummy();
	}
}
technique PostEffectUser3
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSDummy();
	}
}
technique PostEffectUser4
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS1Tex();
		PixelShader = compile ps_2_0 PSDummy();
	}
}

