/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.ldap;

import java.text.MessageFormat;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Rdn;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.ldap.LDAPCallBack;
import org.activiti.ldap.LDAPConfigurator;
import org.activiti.ldap.LDAPTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPQueryBuilder {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LDAPQueryBuilder.class);

    public String buildQueryByUserId(LDAPConfigurator ldapConfigurator, String userId) {
        String searchExpression = null;
        searchExpression = ldapConfigurator.getQueryUserByUserId() != null ? MessageFormat.format(ldapConfigurator.getQueryUserByUserId(), userId) : userId;
        return searchExpression;
    }

    public String buildQueryGroupsForUser(final LDAPConfigurator ldapConfigurator, final String userId) {
        String searchExpression = null;
        if (ldapConfigurator.getQueryGroupsForUser() != null) {
            LDAPTemplate ldapTemplate = new LDAPTemplate(ldapConfigurator);
            String userDn = ldapTemplate.execute(new LDAPCallBack<String>(){

                @Override
                public String executeInContext(InitialDirContext initialDirContext) {
                    String userDnSearch = LDAPQueryBuilder.this.buildQueryByUserId(ldapConfigurator, userId);
                    try {
                        String baseDn = ldapConfigurator.getUserBaseDn() != null ? ldapConfigurator.getUserBaseDn() : ldapConfigurator.getBaseDn();
                        NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, userDnSearch, LDAPQueryBuilder.this.createSearchControls(ldapConfigurator));
                        if (namingEnum.hasMore()) {
                            SearchResult result = namingEnum.next();
                            return result.getNameInNamespace();
                        }
                        namingEnum.close();
                    }
                    catch (NamingException e) {
                        LOGGER.debug("Could not find user dn : " + e.getMessage(), (Throwable)e);
                    }
                    return null;
                }
            });
            searchExpression = MessageFormat.format(ldapConfigurator.getQueryGroupsForUser(), Rdn.escapeValue(userDn));
        } else {
            searchExpression = userId;
        }
        return searchExpression;
    }

    public String buildQueryByFullNameLike(LDAPConfigurator ldapConfigurator, String searchText) {
        String searchExpression = null;
        if (ldapConfigurator.getQueryUserByFullNameLike() == null) {
            throw new ActivitiIllegalArgumentException("No 'queryUserByFullNameLike' configured");
        }
        searchExpression = MessageFormat.format(ldapConfigurator.getQueryUserByFullNameLike(), ldapConfigurator.getUserFirstNameAttribute(), searchText, ldapConfigurator.getUserLastNameAttribute(), searchText);
        return searchExpression;
    }

    protected SearchControls createSearchControls(LDAPConfigurator ldapConfigurator) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(ldapConfigurator.getSearchTimeLimit());
        return searchControls;
    }
}

