/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.ldap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntity;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.activiti.engine.impl.persistence.entity.UserIdentityManager;
import org.activiti.ldap.LDAPCallBack;
import org.activiti.ldap.LDAPConfigurator;
import org.activiti.ldap.LDAPConnectionUtil;
import org.activiti.ldap.LDAPTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPUserManager
extends AbstractManager
implements UserIdentityManager {
    private static Logger logger = LoggerFactory.getLogger(LDAPUserManager.class);
    protected LDAPConfigurator ldapConfigurator;

    public LDAPUserManager(LDAPConfigurator ldapConfigurator) {
        this.ldapConfigurator = ldapConfigurator;
    }

    public User createNewUser(String userId) {
        throw new ActivitiException("LDAP user manager doesn't support creating a new user");
    }

    public void insertUser(User user) {
        throw new ActivitiException("LDAP user manager doesn't support inserting a new user");
    }

    public void updateUser(User updatedUser) {
        throw new ActivitiException("LDAP user manager doesn't support updating a user");
    }

    public boolean isNewUser(User user) {
        throw new ActivitiException("LDAP user manager doesn't support adding or updating a user");
    }

    public UserEntity findUserById(final String userId) {
        LDAPTemplate ldapTemplate = new LDAPTemplate(this.ldapConfigurator);
        return ldapTemplate.execute(new LDAPCallBack<UserEntity>(){

            @Override
            public UserEntity executeInContext(InitialDirContext initialDirContext) {
                try {
                    String searchExpression = LDAPUserManager.this.ldapConfigurator.getLdapQueryBuilder().buildQueryByUserId(LDAPUserManager.this.ldapConfigurator, userId);
                    String baseDn = LDAPUserManager.this.ldapConfigurator.getUserBaseDn() != null ? LDAPUserManager.this.ldapConfigurator.getUserBaseDn() : LDAPUserManager.this.ldapConfigurator.getBaseDn();
                    NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, searchExpression, LDAPUserManager.this.createSearchControls());
                    UserEntity user = new UserEntity();
                    while (namingEnum.hasMore()) {
                        SearchResult result = namingEnum.next();
                        LDAPUserManager.this.mapSearchResultToUser(result, user);
                    }
                    namingEnum.close();
                    return user;
                }
                catch (NamingException ne) {
                    logger.debug("Could not find user " + userId + " : " + ne.getMessage(), (Throwable)ne);
                    return null;
                }
            }
        });
    }

    public void deleteUser(String userId) {
        throw new ActivitiException("LDAP user manager doesn't support deleting a user");
    }

    public List<User> findUserByQueryCriteria(UserQueryImpl query, Page page) {
        if (query.getId() != null) {
            ArrayList<User> result = new ArrayList<User>();
            result.add((User)this.findUserById(query.getId()));
            return result;
        }
        if (query.getFullNameLike() != null) {
            final String fullNameLike = query.getFullNameLike().replaceAll("%", "");
            LDAPTemplate ldapTemplate = new LDAPTemplate(this.ldapConfigurator);
            return ldapTemplate.execute(new LDAPCallBack<List<User>>(){

                @Override
                public List<User> executeInContext(InitialDirContext initialDirContext) {
                    ArrayList<User> result = new ArrayList<User>();
                    try {
                        String searchExpression = LDAPUserManager.this.ldapConfigurator.getLdapQueryBuilder().buildQueryByFullNameLike(LDAPUserManager.this.ldapConfigurator, fullNameLike);
                        String baseDn = LDAPUserManager.this.ldapConfigurator.getUserBaseDn() != null ? LDAPUserManager.this.ldapConfigurator.getUserBaseDn() : LDAPUserManager.this.ldapConfigurator.getBaseDn();
                        NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, searchExpression, LDAPUserManager.this.createSearchControls());
                        while (namingEnum.hasMore()) {
                            SearchResult searchResult = namingEnum.next();
                            UserEntity user = new UserEntity();
                            LDAPUserManager.this.mapSearchResultToUser(searchResult, user);
                            result.add((User)user);
                        }
                        namingEnum.close();
                    }
                    catch (NamingException ne) {
                        logger.debug("Could not execute LDAP query: " + ne.getMessage(), (Throwable)ne);
                        return null;
                    }
                    return result;
                }
            });
        }
        throw new ActivitiIllegalArgumentException("Query is currently not supported by LDAPUserManager.");
    }

    protected void mapSearchResultToUser(SearchResult result, UserEntity user) throws NamingException {
        if (this.ldapConfigurator.getUserIdAttribute() != null) {
            user.setId(result.getAttributes().get(this.ldapConfigurator.getUserIdAttribute()).get().toString());
        }
        if (this.ldapConfigurator.getUserFirstNameAttribute() != null) {
            try {
                user.setFirstName(result.getAttributes().get(this.ldapConfigurator.getUserFirstNameAttribute()).get().toString());
            }
            catch (NullPointerException e) {
                user.setFirstName("");
            }
        }
        if (this.ldapConfigurator.getUserLastNameAttribute() != null) {
            try {
                user.setLastName(result.getAttributes().get(this.ldapConfigurator.getUserLastNameAttribute()).get().toString());
            }
            catch (NullPointerException e) {
                user.setLastName("");
            }
        }
        if (this.ldapConfigurator.getUserEmailAttribute() != null) {
            try {
                user.setEmail(result.getAttributes().get(this.ldapConfigurator.getUserEmailAttribute()).get().toString());
            }
            catch (NullPointerException e) {
                user.setEmail("");
            }
        }
    }

    public long findUserCountByQueryCriteria(UserQueryImpl query) {
        return this.findUserByQueryCriteria(query, null).size();
    }

    public List<Group> findGroupsByUser(String userId) {
        throw new ActivitiException("LDAP user manager doesn't support querying");
    }

    public UserQuery createNewUserQuery() {
        return new UserQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutor());
    }

    public IdentityInfoEntity findUserInfoByUserIdAndKey(String userId, String key) {
        throw new ActivitiException("LDAP user manager doesn't support querying");
    }

    public List<String> findUserInfoKeysByUserIdAndType(String userId, String type) {
        throw new ActivitiException("LDAP user manager doesn't support querying");
    }

    public List<User> findPotentialStarterUsers(String proceDefId) {
        throw new ActivitiException("LDAP user manager doesn't support querying");
    }

    public List<User> findUsersByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        throw new ActivitiException("LDAP user manager doesn't support querying");
    }

    public long findUserCountByNativeQuery(Map<String, Object> parameterMap) {
        throw new ActivitiException("LDAP user manager doesn't support querying");
    }

    public void setUserPicture(String userId, Picture picture) {
        throw new ActivitiException("LDAP user manager doesn't support user pictures");
    }

    public Picture getUserPicture(String userId) {
        logger.debug("LDAP user manager doesn't support user pictures. Returning null");
        return null;
    }

    public Boolean checkPassword(final String userId, final String password) {
        if (password == null || password.length() == 0) {
            throw new ActivitiException("Null or empty passwords are not allowed!");
        }
        try {
            LDAPTemplate ldapTemplate = new LDAPTemplate(this.ldapConfigurator);
            return ldapTemplate.execute(new LDAPCallBack<Boolean>(){

                @Override
                public Boolean executeInContext(InitialDirContext initialDirContext) {
                    if (initialDirContext == null) {
                        return false;
                    }
                    String userDn = null;
                    try {
                        String searchExpression = LDAPUserManager.this.ldapConfigurator.getLdapQueryBuilder().buildQueryByUserId(LDAPUserManager.this.ldapConfigurator, userId);
                        String baseDn = LDAPUserManager.this.ldapConfigurator.getUserBaseDn() != null ? LDAPUserManager.this.ldapConfigurator.getUserBaseDn() : LDAPUserManager.this.ldapConfigurator.getBaseDn();
                        NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, searchExpression, LDAPUserManager.this.createSearchControls());
                        while (namingEnum.hasMore()) {
                            SearchResult result = namingEnum.next();
                            userDn = result.getNameInNamespace();
                        }
                        namingEnum.close();
                    }
                    catch (NamingException ne) {
                        logger.info("Could not authenticate user " + userId + " : " + ne.getMessage(), (Throwable)ne);
                        return false;
                    }
                    if (userDn != null) {
                        InitialDirContext verificationContext = null;
                        try {
                            verificationContext = LDAPConnectionUtil.createDirectoryContext(LDAPUserManager.this.ldapConfigurator, userDn, password);
                        }
                        catch (ActivitiException activitiException) {
                            // empty catch block
                        }
                        if (verificationContext != null) {
                            LDAPConnectionUtil.closeDirectoryContext(verificationContext);
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        catch (ActivitiException e) {
            logger.info("Could not authenticate user : " + (Object)((Object)e));
            return false;
        }
    }

    protected SearchControls createSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(this.ldapConfigurator.getSearchTimeLimit());
        return searchControls;
    }
}

