unit manuscript4uu1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, SynEdit, Forms, Controls, Graphics, Dialogs,
  ComCtrls, Grids, StdCtrls, ExtCtrls, LCLProc, LazHelpHTML, UTF8Process, MGBUTF8;

const
  StProgName = 'Manuscript4u';
  StIniDefault = 'manuscript4u.ini';

type

  { Tmanuscript4uf1 }

  Tmanuscript4uf1 = class(TForm)
    ImageList1: TImageList;
    Label1: TLabel;
    Memo1: TMemo;
    Memo2: TMemo;
    MemoAux: TMemo;
    MemoBookNames: TMemo;
    RadioGroup1: TRadioGroup;
    StatusBar1: TStatusBar;
    StringGrid1: TStringGrid;
    StringGrid2: TStringGrid;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Memo1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Memo2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StringGrid1SelectCell(Sender: TObject; aCol, aRow: Integer;
      var CanSelect: Boolean);
    procedure StringGrid1Selection(Sender: TObject; aCol, aRow: Integer);
    procedure StringGrid2SelectCell(Sender: TObject; aCol, aRow: Integer;
      var CanSelect: Boolean);
    procedure StringGrid2Selection(Sender: TObject; aCol, aRow: Integer);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ToolButton7Click(Sender: TObject);
    procedure ToolButton8Click(Sender: TObject);
    procedure ToolButton9Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    procedure FormSmall;
    procedure FormBig;
    procedure ReadTextA(StFile:ShortString);
    procedure ReadTextB(StFile:ShortString; var boSomeinBandNotFoundinA:boolean);
    procedure LoadBooks;
    function IsNumber(s: string): Boolean;
    function IsVerse(strLabel:string):boolean;
    function SeekBook(sstDada:ShortString;item:word):ShortString; {funciona mas demora para carregar}
    function TiraChar(StDada:String;ChDado,DirEsc:char):String;
    function StripStrChar(StDada:String;ChDado:char):String;
    function StripStrStr(StTirar,StDada:String):String;

    function GetField(noField:word; strDada:string):string;
    procedure LaunchBro(strDada:string);
    procedure ReadDic(StArqEnt:string);
//    function GetField(noField:word; strDada:string):string;

    procedure Browseie(boBro,boWin:boolean);
    procedure StrongWindow(boWin:boolean;strDada:string);
   end;

var
  manuscript4uf1: Tmanuscript4uf1;

  boIndex, boAux, boBig:boolean;
  sstTitleA,sstTitleB,sstOldSearch,strArqDic,sstLangFile:ShortString;
  greek : TStringList;

implementation
uses manuscript4uuconf, manuscript4uucomp, manuscript4uusearch, manuscript4uuedit,
     manuscript4uuabout, manuscript4uuhelp, manuscript4uustrongwind;
{$R *.lfm}

{ Tmanuscript4uf1 }

procedure Tmanuscript4uf1.FormCreate(Sender: TObject);
begin
  Caption:=StProgName;
  Label1.Font.Size:=16;
  Label1.Caption:=' '+StProgName;

   Top:=0;
   Left  :=Trunc(Screen.Width/3);
   Width :=Screen.Width-Left;
   Height:=Trunc(Screen.Height/1.5);

  with StringGrid1 do begin
   Width := 160;//159;
   Height := Trunc(manuscript4uf1.Height-60);
   Top := ToolBar1.Height+5;
   Left := 2;
  end;
  with StringGrid2 do begin
   Width := StringGrid1.Width;
   Height := StringGrid1.Height;
   Top := StringGrid1.Top;
   Left := StringGrid1.Left;
  end;

  StringGrid1.ColWidths[0]:=45; {numeracao}
  StringGrid1.ColWidths[1]:=100;{90} {id versiculo}
  StringGrid1.ColWidths[2]:=0;  {texto A}
  StringGrid1.ColWidths[3]:=0;  {texto B}

  StringGrid2.ColWidths[0]:=StringGrid1.ColWidths[0]; {numeracao}
  StringGrid2.ColWidths[1]:=StringGrid1.ColWidths[1]; {id versiculo}
  StringGrid2.ColWidths[2]:=StringGrid1.ColWidths[2]; {texto A}
  StringGrid2.ColWidths[3]:=StringGrid1.ColWidths[3]; {texto B}

  with Memo1 do begin
   Width := Trunc((manuscript4uf1.Width-StringGrid1.Width-StringGrid1.Left)/2);
   Height := StringGrid1.Height;
   Top := StringGrid1.Top;
   Left := StringGrid1.Left+StringGrid1.Width;
  end;{with SynEdit1}
  with Memo2 do begin
   Width := Memo1.Width;
   Height := Memo1.Height;
   Top := Memo1.Top;
   Left := Memo1.Width+Memo1.Left;
  end;{with SynEdit2}

  KeyPreview := true;
  //Caption := 'Test Form';

 (*
  with Ple16F1 do begin
   Left:=Trunc(Screen.Width/2 )-200;
   Top :=Trunc(Screen.Height/2)-100;
  end;
 *)
  Memo1.Font.Color := clNavy;
  Memo2.Font.Color := Memo1.Font.Color;
 // Memo1.Font.Color := clYellow;
 // Memo2.Font.Color := clYellow;
  Memo1.Color := 13882325; {creme (couro, pergaminho) (leather color)}
  Memo2.Color := Memo1.Color;
 // Memo1.SelStart := 0;
 // Memo1.SelStart := Length(Memo1.Lines.Text)-1;

  {dictionary dicionario dicionário}
 // strArqDic:='/home/max/Desktop/mylaz/stronger/txt/teste1.txt';

  strArqDic:='strong_greek.dic.txt';
  ReadDic(strArqDic);

  sstLangFile:='book_names.txt';
  try
   MemoBookNames.Lines.LoadFromFile(sstLangFile);
  except
   ShowMessage(sstLangFile+' not found or could not be open.');
  end;
end;

procedure Tmanuscript4uf1.FormSmall;
begin
 Top:=0;
 Left  :=Trunc(Screen.Width/3);
 Width :=Screen.Width-Left;
 Height:=Trunc(Screen.Height/1.5);

 manuscript4ufstrongwind.Top:=0;
 manuscript4ufstrongwind.Left:=0;
 manuscript4ufstrongwind.Width:=Screen.Width-Width-5;
 manuscript4ufstrongwind.Height:=Height;//Trunc(manuscript4ufstrongwind.Height/2);
 boBig:=false;
end;

procedure Tmanuscript4uf1.FormBig;
begin
 Top:=0;
 Left  :=Trunc(Screen.Width/3);
 Width :=Screen.Width-Left;
 Height:=Screen.Height;

 manuscript4ufstrongwind.Top:=0;
 manuscript4ufstrongwind.Left:=0;
 manuscript4ufstrongwind.Width:=400;
 manuscript4ufstrongwind.Width:=Screen.Width-Width-5;
 manuscript4ufstrongwind.Height:=Screen.Height;
 boBig:=true;
end;

(*
function Tmanuscript4uf1.SeekBook(sstDada:ShortString;item:word):ShortString; {Não usei porque demora para carregar}
var  i:word;
     sstAux:ShortString;
     boAchou:boolean;
begin
 i:=0;
 boAchou:=false;
 Result:=sstDada;
 while (not boAchou) and (i<MemoBookNames.Lines.Count-1) do begin
  if copy(MemoBookNames.Lines[i],1,3) = sstDada then begin
    boAchou:= true;
    case item of
      1:Result:=copy(MemoBookNames.Lines[i],6,3);
      2:Result:=copy(MemoBookNames.Lines[i],11,25);
      3:Result:=copy(MemoBookNames.Lines[i],38,3);
      4:Result:=copy(MemoBookNames.Lines[i],43,25);
     end;
   end;{if copy}
  i:=i+1;
 end;{while}
end;
*)

procedure Tmanuscript4uf1.ReadTextA(StFile:ShortString);   {Ler do Memo é mais rápido que readln aqui}
var //StAux1:String;
    StAux0:ShortString;
//    IniFile:TextFile;
    i,lin,intAux:LongInt;
///    book:word;

begin
// ple16f1.StringGrid1.RowCount:=2;
 if not FileExists(StFile) then
 begin
  ShowMessage(StFile
    +#13+'was not found in this path.'
    +#13
    +#13+'Please, click on the botton Settings (the gear),'
    +#13+'open the text files that you have, save and load.');
  Exit;
 end;
 Lin:=1;
// book:=0; {0=Nome do texto; 1-66 (até 100) nome dos livros da biblia. Se não houver linha de identificação (000:000) para cada livro não há problema, book será sempre 1 mas lê beleza}
 try
 MemoAux.Lines.LoadFromFile(StFile);

 StringGrid1.RowCount:=MemoAux.Lines.Count;
 for i:=0 to MemoAux.Lines.Count-1 do begin
//   i:=1;
//   StAux1:=Memo1.Lines[i];
     StAux0 := Copy(MemoAux.Lines[i],1,11)+'                                    ';
     with StringGrid1 do //begin
//     if  ( (StAux0[8]=':') and (Copy(StAux0,5,3)<>'000')  and (book>0) )  then
     if (IsVerse(StAux0)){ and (book>0)} then
      begin                                                  {book>0 para liberar o cabecalho para ter : onde quiser, mesmo na 8a. posição}
       while RowCount <= lin do RowCount:=RowCount+1;
       Cells[0,lin] := IntToStr(Lin);
       Cells[1,lin] := Copy(StAux0,1,11);

       {ple16flang.StringGrid1.Cells[ple16f4.RadioGroup1.ItemIndex+2, StrToInt( Copy( Cells[1,Lin],1,2) )+300]+}
       {SeekBook(copy(MemoAux.Lines[i],1,3),3)}

       try intAux:=strToInt(copy(MemoAux.Lines[i],1,2)); except intAux:=0; end;
       if manuscript4ufconf.RadioGroup1.ItemIndex = 1 then begin {segunda lingua (portugues?)}
        Cells[2,Lin]:=copy(MemoBookNames.Lines[intAux],38,3)+Copy(MemoAux.Lines[i],4,Length(MemoAux.Lines[i]));
       end
       else begin {primeira lingua (default English?)}
        Cells[2,Lin]:=copy(MemoBookNames.Lines[intAux],6,3)+Copy(MemoAux.Lines[i],4,Length(MemoAux.Lines[i]))
       end;

      Lin:=Lin+1;
      end {if StAux[8]}
      else
      if Copy(StAux0,5,7) = '000:000' then begin
       sstTitleA:=Copy(MemoAux.Lines[i],13,255);
//    if (StAux0[5] = '0') and (StAux0[6] = '0') then begin
//       ple16f4.StringGrid1.Cells[0,book] := MemoAux.Lines[i];
//       book:=book+1;
      //Ple16F1.Caption:=Copy(StAux1,24,Length(StAux1));
      //Ple16F1.Caption:=StFile;
      end;{if Copy(StAux1}
  end;{for i}
 finally
  MemoAux.Lines.Clear;
 end;{finally}
// for i:=Lin+1 to StringGrid1.RowCount-1 do StringGrid1.Cells[0,i]:=ColocChar(inttostr(i),'0','E',5);

// Isto deve ser feito no final da ReadTextB, se fizer aqui pode faltar Rows para carregar o B.
// while StringGrid1.Cells[1,StringGrid1.RowCount-1] = '' do begin
//  StringGrid1.RowCount:=StringGrid1.RowCount-1;
// end;
(*
 with StringGrid1 do begin
// Cells[0,RowCount-1]:=inttostr(RowCount-1);
  i:=RowCount-2;
 //while RowCount <= i do RowCount:=RowCount+1;
  while Cells[1,i] = '' do begin
  Cells[0,i]:=inttostr(i); //ColocChar(inttostr(i),'0','E',5);
  i:=i-1;
  end;
  RowCount:=RowCount-1;
 end;
*)

end;  {proc. ReadTextA}

procedure Tmanuscript4uf1.ReadTextB(StFile:ShortString; var boSomeinBandNotFoundinA:boolean);   {readln é mais rápido que ler do MemoAux}
var StrAux:String;
    sstAux:ShortString;
    IniFile:TextFile;
//    book:byte; {só 0 ou 1, podia ser um boolean}
    k,i{,Lin}{,LowLim,UppLim}:word;
    intAux:LongInt;

 function SeekRow(StGiven:ShortString; var m:word):boolean;
 var boAchou:boolean;
     n:Cardinal;
 begin
  boAchou:=false;
  result:=false;
  if not IsVerse(StGiven) then Exit;
  n:=m;
  while (not boAchou) and (n<manuscript4uf1.StringGrid1.RowCount-1) do begin
   if StGiven = manuscript4uf1.StringGrid1.Cells[1,n] then begin
    boAchou := true;
    m:=n;
   end
   else begin
    n:=n+1;
    end;
   end;
  result := boAchou;
end;{function}

begin
 if not FileExists(StFile) then
 begin
  ShowMessage(StFile
    +#13+'was not found in this path.'
    +#13
    +#13+'Click on the botton Settings (the gear),'
    +#13+'open the text files that you have, save and load.');
  Exit;
 end;
   MemoAux.Lines.LoadFromFile(StFile);

   try
     k:=0;
     i:=0;
     boSomeinBandNotFoundinA:=false;
     manuscript4ufcomp.Memo1.Lines.Clear;

///     with StringGrid1 do while Cells[0,RowCount-1]='' do RowCount:=RowCount-1; {Win}
     while (i<=MemoAux.Lines.Count-1) do //and (i<=stringgrid1.RowCount-1) do //begin
      with manuscript4uf1.StringGrid1 do
      begin
       StrAux:=MemoAux.Lines[i];
       sstAux:=Copy(StrAux,1,11);  {label}
       if Copy(sstAux,5,7) = '000:000' then begin
        sstTitleB:=Copy(StrAux,13,255);
       end;

       if isVerse(sstAux) then begin
//         k:=StrToInt(manuscript4uf1.StringGrid1.Cells[0,k])+1;
       if ( SeekRow(SstAux,k) ) then begin

        try intAux:=strToInt(copy(sstAux,1,2)); except intAux:=1; end;
        if manuscript4ufconf.RadioGroup1.ItemIndex = 0 then begin
          Cells[3,k]:=copy(MemoBookNames.Lines[intAux],6,3) +Copy(StrAux,4,Length(StrAux));//MemoAux.Lines[k],4,Length(MemoAux.Lines[k])) //Copy(StAux1,5,Length(StAux1))
        end
        else begin
          Cells[3,k]:=copy(MemoBookNames.Lines[intAux],38,3)+Copy(StrAux,4,Length(StrAux));
        end;

       end else begin
      //   if boSomeinBandNotFoundinA then
         strAux:=sstAux+' - '+copy(MemoBookNames.Lines[intAux],6,3) +Copy(StrAux,4,Length(StrAux));
         {+ple16flang.StringGrid1.Cells[ple16f4.RadioGroup1.ItemIndex+2, StrToInt( Copy( StringGrid1.Cells[1,Lin],1,2) )+300]+')'}
      //   +copy(strAux,12,length(strAux));
         manuscript4ufcomp.Memo1.Lines.Append(strAux);
         boSomeinBandNotFoundinA:=true;
       end;
       end;{isVerse}
       i:=i+1;
       end;

   manuscript4uf1.StringGrid1.RowCount:=manuscript4uf1.StringGrid1.RowCount-2;
   finally
    MemoAux.Lines.Clear;
   end;{finally}

{***}   while StringGrid1.Cells[1,StringGrid1.RowCount-1] = '' do
         StringGrid1.RowCount:=StringGrid1.RowCount-1;

   Caption:=sstTitleA+'   -||-   '+sstTitleB;
end;
//*)

procedure Tmanuscript4uf1.LoadBooks;

Type str3 = string[3];
var VtBook : array [1..40] of str3; {27 para o novo e 39 para o velho}
    i,k,botao:word;
//    Save_Cursor:TCursor;
//    StFileName:ShortString;
   boSomeinBandNotFoundinA:boolean;

begin
 (*
 if filesize(manuscript4ufconf.label4.Caption) - filesize(manuscript4ufconf.label2.Caption) > 3E6 then begin
  ShowMessage('Files:'+#13
  +'A: '+manuscript4ufconf.label2.Caption+#13
  +'And'+#13
  +'B: '+manuscript4ufconf.label4.Caption+#13+#13
  +'The second file is too much bigger than the first ('+inttostr(filesize(manuscript4ufconf.label2.Caption))
  +' and '+inttostr(filesize(manuscript4ufconf.label4.Caption))+'),'+#13
  +'Suggestion: Break the second in two smaller units (a file with the Old Testament and another with the New, for example).'+#13
  +'obs. You can load B as first (left) and A as second (right), though.');
//  if botao<>mrYes then begin
   Exit;
  end;
*)
 if abs(filesize(manuscript4ufconf.label4.Caption) - filesize(manuscript4ufconf.label2.Caption)) > 1E6 then begin
  botao:=MessageDlg('About to Load:'+#13
  +'A: '+manuscript4ufconf.label2.Caption+#13
  +'And'+#13
  +'B: '+manuscript4ufconf.label4.Caption+#13+#13
  +'One file is much bigger than the other ('+inttostr(filesize(manuscript4ufconf.label2.Caption))+' and '+inttostr(filesize(manuscript4ufconf.label4.Caption))+'),'+#13
  +'That means the loading can take a long time (like 5 min or so).'+#13
  +'Are you sure you want to load them?',mtCustom,[mbYes,mbNo], 0);
  if botao<>mrYes then begin
   Exit;
  end;
 end; {if filesize}

 boSomeInBandNotFoundinA:=false;
 manuscript4ufcomp.Memo1.Lines.Clear;
 manuscript4ufcomp.Memo1.Lines.Append(' - Verses in file B that are not in file A -');
 manuscript4ufcomp.Memo1.Lines.Append('           (They are not loaded)');
 manuscript4uf1.StringGrid1.RowCount := 2;k:=1;
//  StFileName := ExtractFilePath(A1.FileName)+A1.FileName;//Copy(ExtractFileName(REPar1.FileName),1,5)+VtBook[i]+Copy(ExtractFileName(REPar1.FileName),9,4);
 manuscript4uf1.ReadTextA(manuscript4ufconf.label2.Caption);
 manuscript4uf1.ReadTextB(manuscript4ufconf.label4.Caption,boSomeInBandNotFoundinA);
 manuscript4ufconf.label1.Caption:=Copy(sstTitleA,1,111);
 manuscript4ufconf.label3.Caption:=Copy(sstTitleB,1,111);
 if not boSomeInBandNotFoundinA then begin
   manuscript4ufcomp.Memo1.Lines.Append('None. Every verse in text B has its conterpart in text A. The other way around was not verified though. To do that you have to load current text A as B and vice-versa.');
 end;
end;{fim da LoadBooks}

{xxxxxxxxxxxxxxxxxxxxxxxxxxxx Interface xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx}

procedure Tmanuscript4uf1.FormResize(Sender: TObject);
begin
   with StringGrid1 do begin
  Height := Trunc(manuscript4uf1.Height-ToolBar1.Height-30);
 end;
 with StringGrid2 do begin
  Height := StringGrid1.Height;
 end;
 with Memo1 do begin
  Width := Trunc((manuscript4uf1.Width-StringGrid1.Width-StringGrid1.Left)/2);
  Height := StringGrid1.Height;
//  Top := StringGrid1.Top;                      {definido no Create e não muda}
//  Left := StringGrid1.Left+StringGrid1.Width;  {definido no Create e não muda}
 end;{with SynEdit1}
 with Memo2 do begin
  Width := Memo1.Width;
  Height := Memo1.Height;
//  Top := Memo1.Top;                            {definido no Create e não muda}
  Left := Memo1.Width+Memo1.Left;
 end;{with SynEdit2}
end;

{xxxxxxxxxxxxxxxxxxxxxxxxxx Launch Browser xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx}

procedure Tmanuscript4uf1.LaunchBro(strDada:string);
var
  v: THTMLBrowserHelpViewer;
  BrowserPath, BrowserParams: string;
  p: LongInt;
  URL: String;
  BrowserProcess: TProcessUTF8;
begin
  v:=THTMLBrowserHelpViewer.Create(nil);
  try
    v.FindDefaultBrowser(BrowserPath,BrowserParams);
    debugln(['Path=',BrowserPath,' Params=',BrowserParams]);
//    URL:='http://www.blueletterbible.org/lang/lexicon/Lexicon.cfm?Strongs=G5624';
//    URL:='http://studybible.info/strongs/H6049';
//    URL:='http://www.blueletterbible.org/lang/lexicon/Lexicon.cfm?Strongs='+strDada;
    URL:=strDada;
    p:=System.Pos('%s', BrowserParams);
    System.Delete(BrowserParams,p,2);
    System.Insert(URL,BrowserParams,p);

    // start browser
    BrowserProcess:=TProcessUTF8.Create(nil);
    try
      BrowserProcess.CommandLine:=BrowserPath+' '+BrowserParams;
      BrowserProcess.Execute;
    finally
      BrowserProcess.Free;
    end;
  finally
    v.Free;
  end;
end;

procedure Tmanuscript4uf1.ReadDic(StArqEnt:string);
var
  Arq : TextFile;
  Linha : string;
  i       : Integer;
begin
  // Define a string list object, and point our variable at it
  if FileExists(StArqEnt) then
   try begin
    greek := TStringList.Create;
    greek.LoadFromFile(StArqEnt);
   end
   except
    ShowMessage(sstLangFile+'Could not open '+StArqEnt);
   end
  else ShowMessage(StArqEnt+' not found'); {file dont exists}
end;

function Tmanuscript4uf1.GetField(noField:word; strDada:string):string;
var strAux1,strAux2,strAux3:string;
begin
 strAux2:=UTF8copy(strDada,UTF8pos(' ',strDada)+1,UTF8length(strDada));
 strAux3:=UTF8copy(strAux2,UTF8pos(' ',strAux2)+1,UTF8length(strAux2));
 strAux2:=UTF8copy(strAux2,1,UTF8pos(' ',strAux2)-1);
// memo2.lines.Append(strAux2);
// memo2.lines.Append(strAux3);
 strAux1:=UTF8copy(strDada,1,UTF8pos(' ',strDada)-1);
// strAux2:=ColocChar(strAux2,'0','E',4);
// result:='G'+strAux2+' '+strAux1+' '+strAux3;
 if noField = 1 then result:=strAux1 else
  if noField = 2 then result:=strAux2 else
   if noField = 3 then result:=strAux3 else result:='ERROR: Field number out of range. Must be 1 to 3.';
end;

procedure Tmanuscript4uf1.Browseie(boBro,boWin:boolean);
  var                                        {false, false: shows Strong on Status bar}
   boAchou:boolean;                          {false, true: shows Strong on window}
   i:Cardinal;                               {true, false: goes to the internet}
   strAux:string;                            {true, true: would go to the intenet AND show window (not to be used)}
   btAux:byte;

begin
  boAchou:=false;
  i:=0;
  strAux:=Memo1.SelText;
{  btAux:=btLanguage(strAux); }
//  btAux:=1;
//  if ( btAux=1 ) then
//  if (not boBro) and (not boWin) then
//  begin {greek=1}{when I get a hebrew dictionary with the strong numbers and the word in hebrew characters, then btAux=0 too}
  repeat
   if GetField(2,greek[i]) = strAux then boAchou:=true;
   i:=i+1;
  until (boAchou) or (i>greek.count-1); {}
//  if boAchou then ShowMessage(greek[i-1]);
//  if boAchou then
   StatusBar1.Panels[0].Text:=greek[i-1];
 // LaunchBro('http://www.blueletterbible.org/lang/lexicon/Lexicon.cfm?Strongs='+GetField(1,greek[i-1]));
   if boBro then LaunchBro(manuscript4ufconf.ComboBox1.Text+GetField(1,greek[i-1]));
   if boWin then StrongWindow(true,greek[i-1]);
//  end; //else LaunchBro(manuscript4ufconf.ComboBox1.Text+'G'+manuscript4ufstrongwind.Memo1.SelText);
end;


{xxxxxxxxxxxxxxxxxxxxxxxxx end Lauch Browser xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx}


procedure Tmanuscript4uf1.Memo1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   //if RadioGroup1.ItemIndex <> 2 then begin
   if Memo1.SelText<>'' then begin

   manuscript4ufsearch.ComboBox1.Text := Memo1.SelText;
   manuscript4ufsearch.RadioGroup1.ItemIndex := 0; {search on Memo1}
   if Button = mbLeft then begin

    if RadioGroup1.ItemIndex=0 then begin
     manuscript4ufsearch.Search(Memo1.SelText);  {Go}
//     Ple16F3.ComboBox1.Item0s.Append( Ple16F3.ComboBox1.Text );
    end;
    if RadioGroup1.ItemIndex=1 then manuscript4ufsearch.Show; {search window}

    if RadioGroup1.ItemIndex=2 then Browseie(false,false); {Strongs dictionary}
    if RadioGroup1.ItemIndex=3 then Browseie(false,true);//ToolButton9Click(Sender); {Show Strong Window}

    if RadioGroup1.ItemIndex=4 then Browseie(true,false);  {intenet}

    end;

    {ItemIndex=4 eh para nao fazer nada}
{
  sstAux:=Gematria(RadioGroup1.ItemIndex,Edit2.Text);
  Edit1.Text:=ple16f1.stripStrStr(' ',Copy(sstAux,1,9));
}
///    if RadioGroup1.ItemIndex=5 then BibleWheel;
///if manuscript4ufconf.CheckBox1.Checked then
 end; {if Memo1.SelText<>''}
end;

procedure Tmanuscript4uf1.Memo2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
    if Memo2.SelText<>'' then begin

   manuscript4ufsearch.ComboBox1.Text := Memo2.SelText;
   manuscript4ufsearch.RadioGroup1.ItemIndex := 1; {search on Memo2}
   if Button = mbLeft then begin

    if RadioGroup1.ItemIndex=0 then begin
     manuscript4ufsearch.Search(Memo2.SelText);  {Go}
//     Ple16F3.ComboBox1.Item0s.Append( Ple16F3.ComboBox1.Text );
    end;
    if RadioGroup1.ItemIndex=1 then manuscript4ufsearch.Show; {search window}

    if RadioGroup1.ItemIndex=2 then Browseie(false,false); {Strongs dictionary}
    if RadioGroup1.ItemIndex=3 then Browseie(false,true);//ToolButton9Click(Sender); {Show Strong Window}

    if RadioGroup1.ItemIndex=4 then Browseie(true,false);  {intenet}

    end;
 end;
end;

procedure Tmanuscript4uf1.StringGrid1SelectCell(Sender: TObject; aCol, aRow: Integer; var CanSelect: Boolean);
var i,NoVer,IntAux:word;

begin
 NoVer:=10; {15}  {number of verses displayed on the memo at a time}
(**)
 Memo1.Lines.Clear;
 with StringGrid1 do begin
 for i:=ARow to ARow+NoVer-1 do
  if i < StringGrid1.RowCount then begin
   Memo1.Lines.Append(Cells[2,i]);
   Memo1.Lines.Append('');
  end;
 Memo1.SelStart := 0;

 Memo2.Lines.Clear;
 for i:=ARow to ARow+NoVer-1 do
  if i < StringGrid1.RowCount then begin
   Memo2.Lines.Append(Cells[3,i]);
   Memo2.Lines.Append('');
  end;
 Memo2.SelStart := 0;

 end; {with StringGrid1 do}
end;

function Tmanuscript4uf1.SeekBook(sstDada:ShortString;item:word):ShortString; {Finds the label or name of the book loaded in MemoBookNames}
var  i:word;
     sstAux:ShortString;
     boAchou:boolean;
begin
 i:=0;
 boAchou:=false;
 Result:=sstDada;
 while (not boAchou) and (i<MemoBookNames.Lines.Count-1) do begin
  if copy(MemoBookNames.Lines[i],1,3) = sstDada then begin
    boAchou:= true;
    case item of
      1:Result:=copy(MemoBookNames.Lines[i],6,3);   {1 for first language abreviation of the book name}
      2:Result:=copy(MemoBookNames.Lines[i],11,25); {2 for first language book name}
      3:Result:=copy(MemoBookNames.Lines[i],38,3);  {3 for second language abreviation of the book name}
      4:Result:=copy(MemoBookNames.Lines[i],43,25); {4 for second language book name}
     end;
   end;{if copy}
  i:=i+1;
 end;{while}
end;

procedure Tmanuscript4uf1.StringGrid1Selection(Sender: TObject; aCol, aRow: Integer);
var IntAux:word;
    sstAux:ShortString;
begin
 IntAux:=0;
 if IsNumber(Copy( StringGrid1.Cells[1,ARow],1,2)) then
 try
   IntAux:=StrToInt( Copy( StringGrid1.Cells[1,ARow],1,2) );
   sstAux:=SeekBook(Copy(StringGrid1.Cells[1,aRow],1,3),manuscript4ufconf.RadioGroup1.ItemIndex*2+2);
   Label1.Caption:=' '+Copy(StringGrid1.Cells[1,aRow],1,2)+' - '+sstAux;
 except
  ShowMessage('Is '+Copy(StringGrid1.Cells[1,ARow],1,2)+' a number?');
  Exit;
 end;
end;

procedure Tmanuscript4uf1.StringGrid2SelectCell(Sender: TObject; aCol,
  aRow: Integer; var CanSelect: Boolean);
var i,NoVer:word;
begin
 NoVer:=15;
(**)
 Memo1.Lines.Clear;
 for i:=ARow to ARow+NoVer-1 do
//  if i < StringGrid2.RowCount then Memo1.Lines.Add(Copy(StringGrid2.Cells[2,i],5,Length(StringGrid2.Cells[2,i])));
  if i < StringGrid2.RowCount then begin
   Memo1.Lines.Append(StringGrid2.Cells[2,i]);
   Memo1.Lines.Append('');
  end;
 Memo1.SelStart := 0;
 Memo2.Lines.Clear;
 for i:=ARow to ARow+NoVer-1 do
  if i < StringGrid2.RowCount then begin
   Memo2.Lines.Append(StringGrid2.Cells[3,i]);
   Memo2.Lines.Append('');
  end;
 Memo2.SelStart := 0;
end;

procedure Tmanuscript4uf1.StringGrid2Selection(Sender: TObject; aCol, aRow: Integer);
  var IntAux:word;
      sstAux:ShortString;
begin
 IntAux:=0;
 if copy(StringGrid2.Cells[1,ARow],1,2) <> '' then begin
  IntAux:=StrToInt( Copy( StringGrid2.Cells[1,ARow],1,2) );
  sstAux:=SeekBook(Copy(StringGrid2.Cells[1,aRow],1,3),manuscript4ufconf.RadioGroup1.ItemIndex*2+2);
  Label1.Caption:=' '+Copy(StringGrid2.Cells[1,aRow],1,2)+' - '+sstAux;
 end;
end;

procedure Tmanuscript4uf1.ToolButton1Click(Sender: TObject); {Search}
begin
 with manuscript4ufsearch do begin
  Show;
  ComboBox1.SetFocus;
 end;
end;

procedure Tmanuscript4uf1.ToolButton2Click(Sender: TObject);
begin
 sstOldSearch:=StatusBar1.Panels[0].Text;
 StatusBar1.Panels[0].Text:='';
 if IsNumber(StringGrid2.Cells[0,StringGrid2.Row]) then
 try
  StringGrid1.Row := StrToInt(StringGrid2.Cells[0,StringGrid2.Row]);
 except
 end;
 manuscript4uf1.StringGrid1.Visible:=true;
 manuscript4uf1.StringGrid2.Visible:=false;
end;

procedure Tmanuscript4uf1.ToolButton3Click(Sender: TObject); {back to previous search}
begin
 if not StringGrid2.Visible then StatusBar1.Panels[0].Text:= sstOldSearch;
 manuscript4uf1.StringGrid1.Visible:=false;
 manuscript4uf1.StringGrid2.Visible:=true;
 StringGrid2.SetFocus;
end;

procedure Tmanuscript4uf1.ToolButton4Click(Sender: TObject); {Edit Search}
var i:word;
    StAux:string;
begin
  with manuscript4ufedit.Memo1.Lines do begin
   Clear;
   for i:=1 to StringGrid2.RowCount-1 do begin

   if IsNumber(Copy( StringGrid2.Cells[1,i],1,2)) then
    try
//   StAux:=ple16flang.StringGrid1.Cells[ple16f4.RadioGroup1.ItemIndex+2,StrToInt( Copy( StringGrid2.Cells[1,i],1,2) )+300];
     stAux:=SeekBook(Copy(StringGrid2.Cells[1,i],1,3),manuscript4ufconf.RadioGroup1.ItemIndex*2+2);
    except       {StAux now is the name of the book which can vary in length}
     StAux:='';
     ShowMessage('Click on Edit Search again');
    end;

   //TiraChar(StDada:String;ChDado,DirEsc:char):String;
    StAux:=TiraChar(StAux,' ','D');                                                 {"D" for from the Right side}
    Add(StAux+' '+Copy( StringGrid2.Cells[1,i],4, Length(StringGrid2.Cells[1,i]) ) );
    Add('   '+Copy(StringGrid2.Cells[2,i],Length(StringGrid2.Cells[1,i])+1, Length(StringGrid2.Cells[2,i]) ) );
    Add('   '+Copy(StringGrid2.Cells[3,i],Length(StringGrid2.Cells[1,i])+1, Length(StringGrid2.Cells[3,i]) ) );

//    Add( StringGrid2.Cells[2,i] );
//    Add(Copy( StringGrid2.Cells[3,i],Length(StAux)+1, Length(StringGrid2.Cells[3,i]) ) );

    Add('');
   end;
  end;
{
  with manuscript4ufedit.SaveDialog1 do begin
   DefaultExt:='.txt';
   FilterIndex:=1;
  end;
}
  manuscript4ufedit.Memo1.SelStart := 0;
  manuscript4ufedit.Caption:=manuscript4ufsearch.ComboBox1.Text;
  manuscript4ufedit.show;
end;

procedure Tmanuscript4uf1.ToolButton5Click(Sender: TObject);
begin
 manuscript4ufconf.show;
end;

procedure Tmanuscript4uf1.ToolButton6Click(Sender: TObject);  {Help}
begin
 manuscript4ufhelp.Show;
end;

procedure Tmanuscript4uf1.ToolButton7Click(Sender: TObject);
begin
  manuscript4ufabout.Show;
end;

procedure Tmanuscript4uf1.ToolButton8Click(Sender: TObject);
begin
  Close;
end;

procedure Tmanuscript4uf1.StrongWindow(boWin:boolean;strDada:string);
begin
  if strDada<>'' then begin
  manuscript4ufstrongwind.Memo1.Lines.Clear;
  if boWin then begin
   manuscript4ufstrongwind.Memo1.Lines.Add(strDada);
   manuscript4ufstrongwind.Memo1.SelStart := 0;
   manuscript4ufstrongwind.Caption:=manuscript4ufsearch.ComboBox1.Text+'  '+'(internet:Select a number)';
   manuscript4ufstrongwind.show;
  end;
  end;
end;

procedure Tmanuscript4uf1.ToolButton9Click(Sender: TObject); {Show Strong Window}
begin
//Browseie(false,true);
// Minimize;
 if BoBig then FormSmall else FormBig;
(*
 Width := 500;

 manuscript4ufstrongwind.Top:=0;
 manuscript4ufstrongwind.Left:=0;
 manuscript4ufstrongwind.Width:=400;
 manuscript4ufstrongwind.Height:=Screen.Height;

 Width :=Screen.Width-manuscript4ufstrongwind.Width-5;
 Left  :=manuscript4ufstrongwind.Width+5;
 Height:=manuscript4ufstrongwind.Height;
 manuscript4ufstrongwind.Show;
 *)
end;

procedure Tmanuscript4uf1.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
  greek.free;
  CloseAction:=caFree;
end;

function Tmanuscript4uf1.IsVerse(strLabel:string):boolean;
begin
  result:=false;
  if Copy(strLabel,1,3) = '01O' then result := true else
  if Copy(strLabel,1,3) = '02O' then result := true else
  if Copy(strLabel,1,3) = '03O' then result := true else
  if Copy(strLabel,1,3) = '04O' then result := true else
  if Copy(strLabel,1,3) = '05O' then result := true else
  if Copy(strLabel,1,3) = '06O' then result := true else
  if Copy(strLabel,1,3) = '07O' then result := true else
  if Copy(strLabel,1,3) = '08O' then result := true else
  if Copy(strLabel,1,3) = '09O' then result := true else
  if Copy(strLabel,1,3) = '10O' then result := true else
  if Copy(strLabel,1,3) = '11O' then result := true else
  if Copy(strLabel,1,3) = '12O' then result := true else
  if Copy(strLabel,1,3) = '13O' then result := true else
  if Copy(strLabel,1,3) = '14O' then result := true else
  if Copy(strLabel,1,3) = '15O' then result := true else
  if Copy(strLabel,1,3) = '16O' then result := true else
  if Copy(strLabel,1,3) = '17O' then result := true else
  if Copy(strLabel,1,3) = '18O' then result := true else
  if Copy(strLabel,1,3) = '19O' then result := true else
  if Copy(strLabel,1,3) = '20O' then result := true else
  if Copy(strLabel,1,3) = '21O' then result := true else
  if Copy(strLabel,1,3) = '22O' then result := true else
  if Copy(strLabel,1,3) = '23O' then result := true else
  if Copy(strLabel,1,3) = '24O' then result := true else
  if Copy(strLabel,1,3) = '25O' then result := true else
  if Copy(strLabel,1,3) = '26O' then result := true else
  if Copy(strLabel,1,3) = '27O' then result := true else
  if Copy(strLabel,1,3) = '28O' then result := true else
  if Copy(strLabel,1,3) = '29O' then result := true else
  if Copy(strLabel,1,3) = '30O' then result := true else
  if Copy(strLabel,1,3) = '31O' then result := true else
  if Copy(strLabel,1,3) = '32O' then result := true else
  if Copy(strLabel,1,3) = '33O' then result := true else
  if Copy(strLabel,1,3) = '34O' then result := true else
  if Copy(strLabel,1,3) = '35O' then result := true else
  if Copy(strLabel,1,3) = '36O' then result := true else
  if Copy(strLabel,1,3) = '37O' then result := true else
  if Copy(strLabel,1,3) = '38O' then result := true else
  if Copy(strLabel,1,3) = '39O' then result := true else
  if Copy(strLabel,1,3) = '40N' then result := true else
  if Copy(strLabel,1,3) = '41N' then result := true else
  if Copy(strLabel,1,3) = '42N' then result := true else
  if Copy(strLabel,1,3) = '43N' then result := true else
  if Copy(strLabel,1,3) = '44N' then result := true else
  if Copy(strLabel,1,3) = '45N' then result := true else
  if Copy(strLabel,1,3) = '46N' then result := true else
  if Copy(strLabel,1,3) = '47N' then result := true else
  if Copy(strLabel,1,3) = '48N' then result := true else
  if Copy(strLabel,1,3) = '49N' then result := true else
  if Copy(strLabel,1,3) = '50N' then result := true else
  if Copy(strLabel,1,3) = '51N' then result := true else
  if Copy(strLabel,1,3) = '52N' then result := true else
  if Copy(strLabel,1,3) = '53N' then result := true else
  if Copy(strLabel,1,3) = '54N' then result := true else
  if Copy(strLabel,1,3) = '55N' then result := true else
  if Copy(strLabel,1,3) = '56N' then result := true else
  if Copy(strLabel,1,3) = '57N' then result := true else
  if Copy(strLabel,1,3) = '58N' then result := true else
  if Copy(strLabel,1,3) = '59N' then result := true else
  if Copy(strLabel,1,3) = '60N' then result := true else
  if Copy(strLabel,1,3) = '61N' then result := true else
  if Copy(strLabel,1,3) = '62N' then result := true else
  if Copy(strLabel,1,3) = '63N' then result := true else
  if Copy(strLabel,1,3) = '64N' then result := true else
  if Copy(strLabel,1,3) = '65N' then result := true else
  if Copy(strLabel,1,3) = '66N' then result := true else
  if Copy(strLabel,1,3) = '67A' then result := true else
  if Copy(strLabel,1,3) = '68A' then result := true else
  if Copy(strLabel,1,3) = '69A' then result := true else
  if Copy(strLabel,1,3) = '70A' then result := true else
  if Copy(strLabel,1,3) = '71A' then result := true else
  if Copy(strLabel,1,3) = '72A' then result := true else
  if Copy(strLabel,1,3) = '73A' then result := true else
  if Copy(strLabel,1,3) = '74A' then result := true else
  if Copy(strLabel,1,3) = '75A' then result := true else
  if Copy(strLabel,1,3) = '76A' then result := true else
  if Copy(strLabel,1,3) = '77A' then result := true else
  if Copy(strLabel,1,3) = '78A' then result := true else
  if Copy(strLabel,1,3) = '79A' then result := true else
  if Copy(strLabel,1,3) = '80A' then result := true else
  if Copy(strLabel,1,3) = '81A' then result := true else
  if Copy(strLabel,1,3) = '82A' then result := true else
  if Copy(strLabel,1,3) = '83A' then result := true else
  if Copy(strLabel,1,3) = '84A' then result := true else
  if Copy(strLabel,1,3) = '85A' then result := true else
  if Copy(strLabel,1,3) = '86A' then result := true else
  if Copy(strLabel,1,3) = '87A' then result := true else
  if Copy(strLabel,1,3) = '88A' then result := true else
  if Copy(strLabel,1,3) = '89A' then result := true else
  if Copy(strLabel,1,3) = '90A' then result := true else
  if Copy(strLabel,1,3) = '91A' then result := true else
  if Copy(strLabel,1,3) = '92A' then result := true else
  if Copy(strLabel,1,3) = '93A' then result := true else
  if Copy(strLabel,1,3) = '94A' then result := true else
  if Copy(strLabel,1,3) = '95A' then result := true else
  if Copy(strLabel,1,3) = '96A' then result := true else
  if Copy(strLabel,1,3) = '97A' then result := true else
  if Copy(strLabel,1,3) = '98A' then result := true else
  if Copy(strLabel,1,3) = '99A' then result := true;
end;{function IsVerse}


function Tmanuscript4uf1.IsNumber(s: string): Boolean;
var
  i: Integer;
begin
 Result := False;
 for i := 1 to Length(s) do
  case s[i] of
   '0'..'9' : Result := True;
  else begin
   Result := False;
   Exit;
  end; {else}
 end; {case}
end;

function Tmanuscript4uf1.TiraChar(StDada:String;ChDado,DirEsc:char):String;
begin
 if UpCase(DirEsc) = 'D' then {tirar o último char}
 while (Copy(StDada,Length(StDada),1) = ChDado) and (Length(StDada)>0) do
 begin
  StDada := Copy(StDada,1,Length(StDada)-1)
 end
 else begin {chDado=E, tirar o primeiro char}
 while (Copy(StDada,1,1) = ChDado) and (Length(StDada)>0) do
  StDada := Copy(StDada,2,Length(StDada));
 end;
 TiraChar := StDada;
end;

function Tmanuscript4uf1.StripStrChar(StDada:String;ChDado:char):String;
var i:word;
    StrAux:string;
begin
 i:=0;
 StrAux:='';
 while (i<Length(StDada)) and (Length(StDada)>0) do
// for i:=1 to Lenght(StDada) do
 begin
  i:=i+1;
  if Copy(StDada,i,1) <> ChDado then
   StrAux:=StrAux+Copy(StDada,i,1)
 end;
 StripStrChar := StrAux;
end;

function Tmanuscript4uf1.StripStrStr(StTirar,StDada:String):String;
begin
 while ( Pos(StTirar,StDada) <> 0) and (Length(StDada)>1) do
 begin
   StDada := Copy(StDada,0,Pos(StTirar,StDada)-1) + Copy(StDada,Pos(StTirar,StDada)+1, Length(StDada))
 end;
 StripStrStr := StDada;
end;

end.

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
Manuscrip4u 2.5

You can translate it to your language by editing
this file. Just the two columns with the abreviation
of the book and the name of it. Keep the spacing:
2 spaces between the columns and complete the names
of the first language with spaces up to 25 characters.
3__2_3__2_25_________________________3__2_?_________
------------------------------------------------------

