unit manuscript4uuconf;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ComCtrls,
  StdCtrls, LCLProc, ExtCtrls{, UTF8Process}{, IniFiles};

type

  { Tmanuscript4ufconf }

  Tmanuscript4ufconf = class(TForm)
    Button1: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    Button15: TButton;
    Button17: TButton;
    Button18: TButton;
    Button19: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    ColorDialog1: TColorDialog;
    ComboBox1: TComboBox;
    FontDialog1: TFontDialog;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    GroupBox6: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    OpenDialog1: TOpenDialog;
    PageControl1: TPageControl;
    RadioGroup1: TRadioGroup;
    SaveDialog1: TSaveDialog;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    procedure ReadAboutText(StFile:ShortString);
    procedure ReadIni(sstFileName:ShortString);
  end;

var
  manuscript4ufconf: Tmanuscript4ufconf;

implementation
uses manuscript4uu1, manuscript4uucopy, manuscript4uucomp, manuscript4uustrongwind;
{$R *.lfm}

{ Tmanuscript4ufconf }


{..................}
procedure Tmanuscript4ufconf.ReadAboutText(StFile:ShortString);
var StrAux1:String;
//    SstAux:ShortString;
    IniFile:TextFile;
begin
   AssignFile(IniFile,StFile);
   {$I-}
   ReSet(IniFile);
   {$I+}
   if IOResult <> 0 then
   begin                   {}
    ShowMessage('The file: '+StFile
    +#13+'was not found in this path or cannot be opened.'
    +#13
    +#13+'Please, click on the button "Choose",'
    +#13+'open the text files that you have and save.');
    Exit;
   end;
   try
     with manuscript4ufcopy.Memo1 do begin
     Lines.Clear;
     StrAux1:='                                         ';
     while (   ( not EOF(IniFile) ) and ( (Copy(StrAux1,1,3)<>'###') and (Copy(StrAux1,5,7)<>'000:000') )  ) do begin
      readln(IniFile,StrAux1);
      if (Copy(StrAux1,5,7)<>'000:000') then
      {manuscript4ufcopy.Memo1.}Lines.Append(StrAux1);
     end;{while}
     SelStart:=0;
     end; {with manuscript4ufcopy}
   finally
   CloseFile(IniFile);
   end;
end;

{..................}

procedure Tmanuscript4ufconf.Button5Click(Sender: TObject); {About A}
begin
 ReadAboutText(label2.Caption);
 manuscript4ufcopy.Show;
end;

procedure Tmanuscript4ufconf.Button10Click(Sender: TObject); {About B}
begin
 ReadAboutText(label4.Caption);
 manuscript4ufcopy.Show;
end;

procedure Tmanuscript4ufconf.ReadIni(sstFileName:ShortString);  {Read .INI file}
var {Ini: TIniFile;}
    StAux:ShortString;
    i:word;
begin
 if FileExists(ExtractFilePath(Application.ExeName)+sstFileName) then begin (**)
  try
  with manuscript4uf1.MemoAux do begin
   Lines.LoadFromFile(sstFileName);
   ComboBox1.Items.Clear;
   for i:=0 to Lines.Count-1 do begin
    StAux:=UTF8Copy(Lines[i],1,7);

{Left side Memo1}
    if StAux = 'flName1' then Label2.Caption:=UTF8Copy(Lines[i],9,200) else  {txt/0n0_greek_textus_receptus_utf8.txtub.txt}
     if StAux = 'ftName1' then manuscript4uf1.Memo1.Font.Name:=UTF8Copy(Lines[i],9,200) else
      if StAux = 'ftSize1' then manuscript4uf1.Memo1.Font.Size:=StrToInt(UTF8Copy(Lines[i],9,200)) else
       if StAux = 'ftColo1' then manuscript4uf1.Memo1.Font.Color:=StrToInt(UTF8Copy(Lines[i],9,200)) else //        if StAux =  'ftStyl1' then manuscript4uf1.Memo1.Font.Style:=StrToInt(UTF8Copy(Lines[i],9,200));// else
      if StAux = 'ftStyl1' then begin
          if UTF8Copy(Lines[i],9,1) = '0' then manuscript4uf1.Memo1.Font.Style:= [] else
           if UTF8Copy(Lines[i],9,1) = '1' then manuscript4uf1.Memo1.Font.Style:= [fsBold] else
            if UTF8Copy(Lines[i],9,1) = '2' then manuscript4uf1.Memo1.Font.Style:= [fsItalic] else
             if UTF8Copy(Lines[i],9,1) = '3' then manuscript4uf1.Memo1.Font.Style:= [fsBold, fsItalic] else
              manuscript4uf1.Memo1.Font.Style:= [];
        end;
         if StAux = 'bkColo1' then manuscript4uf1.Memo1.Color:=StrToInt(UTF8Copy(Lines[i],9,200));// else


{Right side Memo1}
        if StAux = 'flName2' then Label4.Caption:=UTF8Copy(Lines[i],9,200) else  {txt/0n0_greek_textus_receptus_utf8.txtub.txt}
         if StAux = 'ftName2' then manuscript4uf1.Memo2.Font.Name:=UTF8Copy(Lines[i],9,200) else
          if StAux = 'ftSize2' then manuscript4uf1.Memo2.Font.Size:=StrToInt(UTF8Copy(Lines[i],9,200)) else
           if StAux = 'ftColo2' then manuscript4uf1.Memo2.Font.Color:=StrToInt(UTF8Copy(Lines[i],9,200));// else
         if StAux = 'ftStyl2' then begin
           if UTF8Copy(Lines[i],9,1) = '0' then manuscript4uf1.Memo2.Font.Style:= [] else
            if UTF8Copy(Lines[i],9,1) = '1' then manuscript4uf1.Memo2.Font.Style:= [fsBold] else
             if UTF8Copy(Lines[i],9,1) = '2' then manuscript4uf1.Memo2.Font.Style:= [fsItalic] else
              if UTF8Copy(Lines[i],9,1) = '3' then manuscript4uf1.Memo2.Font.Style:= [fsBold, fsItalic] else
                manuscript4uf1.Memo2.Font.Style:= [];
         end;
            if StAux = 'bkColo2' then manuscript4uf1.Memo2.Color:=StrToInt(UTF8Copy(Lines[i],9,200));// else


{Strongs dictionary Memo1}
             if StAux = 'ftName3' then manuscript4ufstrongwind.Memo1.Font.Name:=UTF8Copy(Lines[i],9,200) else
              if StAux = 'ftSize3' then manuscript4ufstrongwind.Memo1.Font.Size:=StrToInt(UTF8Copy(Lines[i],9,200)) else
               if StAux = 'ftColo3' then manuscript4ufstrongwind.Memo1.Font.Color:=StrToInt(UTF8Copy(Lines[i],9,200)) else //        if StAux =  'ftStyl1' then manuscript4uf1.Memo1.Font.Style:=StrToInt(UTF8Copy(Lines[i],9,200));// else
              if StAux = 'ftStyl3' then begin
                  if UTF8Copy(Lines[i],9,1) = '0' then manuscript4ufstrongwind.Memo1.Font.Style:= [] else
                   if UTF8Copy(Lines[i],9,1) = '1' then manuscript4ufstrongwind.Memo1.Font.Style:= [fsBold] else
                    if UTF8Copy(Lines[i],9,1) = '2' then manuscript4ufstrongwind.Memo1.Font.Style:= [fsItalic] else
                     if UTF8Copy(Lines[i],9,1) = '3' then manuscript4ufstrongwind.Memo1.Font.Style:= [fsBold, fsItalic] else
                      manuscript4uf1.Memo1.Font.Style:= [];
                end;
                 if StAux = 'bkColo3' then manuscript4ufstrongwind.Memo1.Color:=StrToInt(UTF8Copy(Lines[i],9,200));


            if StAux = 'bokLang' then manuscript4ufconf.RadioGroup1.ItemIndex:=StrToInt(UTF8Copy(Lines[i],9,1));

            if StAux = 'inter00' then ComboBox1.Text:=UTF8Copy(Lines[i],9,200) else
             if Copy(StAux,1,5) = 'inter' then ComboBox1.AddItem( UTF8Copy(Lines[i],9,200), nil ) {or ComboBox1.Items.Add('Test')}
    end;
  end;{with Memo3}
  except
   ShowMessage('Initialization file ('+sstFileName+') not found or could not be readed.')
  end;
 end{if FileExists}
  else begin
   ShowMessage('initialization file ('+sstFileName+') not found.');
  end;
end;   {Save .INI}

procedure Tmanuscript4ufconf.Button11Click(Sender: TObject); {Open .INI}
begin
  OpenDialog1.FilterIndex:=2;
  if OpenDialog1.Execute then begin
    if ExtractFileExt(OpenDialog1.FileName) <> '.ini' then begin
     ShowMessage('This file is not an .ini file.');
     Exit;
    end;
    Label5.Caption:=ExtractFileName(OpenDialog1.FileName);
//    manuscript4uf1.
    ReadIni(Label5.Caption);
    manuscript4uf1.LoadBooks;
  end;
end;

procedure Tmanuscript4ufconf.Button12Click(Sender: TObject); {Save .INI}
var i:word;
begin
 with manuscript4uf1.MemoAux.Lines do begin
  Clear;
  Add('flName1='+Label2.Caption);
  Add('ftName1='+manuscript4uf1.Memo1.Font.Name);
  Add('ftSize1='+intToStr(manuscript4uf1.Memo1.Font.Size));
  Add('ftColo1='+intToStr(manuscript4uf1.Memo1.Font.Color));
   if manuscript4uf1.Memo1.Font.Style = [fsBold] then Add('ftStyl1=1') else
    if manuscript4uf1.Memo1.Font.Style = [fsItalic] then Add('ftStyl1=2') else
     if manuscript4uf1.Memo1.Font.Style = [fsBold, fsItalic] then Add('ftStyl1=3') else
      Add('ftStyl1=0');
  Add('bkColo1='+intToStr(manuscript4uf1.Memo1.Color));

  Add('flName2='+Label4.Caption);
  Add('ftName2='+manuscript4uf1.Memo2.Font.Name);
  Add('ftSize2='+intToStr(manuscript4uf1.Memo2.Font.Size));
  Add('ftColo2='+intToStr(manuscript4uf1.Memo2.Font.Color));
   if manuscript4uf1.Memo2.Font.Style = [fsBold] then Add('ftStyl2=1') else
    if manuscript4uf1.Memo2.Font.Style = [fsItalic] then Add('ftStyl2=2') else
     if manuscript4uf1.Memo2.Font.Style = [fsBold, fsItalic] then Add('ftStyl2=3') else
      Add('ftStyl2=0');
  Add('bkColo2='+intToStr(manuscript4uf1.Memo2.Color));

  Add('ftName3='+manuscript4ufstrongwind.Memo1.Font.Name);
  Add('ftSize3='+intToStr(manuscript4ufstrongwind.Memo1.Font.Size));
  Add('ftColo3='+intToStr(manuscript4ufstrongwind.Memo1.Font.Color));
   if manuscript4ufstrongwind.Memo1.Font.Style = [fsBold] then Add('ftStyl3=1') else
    if manuscript4ufstrongwind.Memo1.Font.Style = [fsItalic] then Add('ftStyl3=2') else
     if manuscript4ufstrongwind.Memo1.Font.Style = [fsBold, fsItalic] then Add('ftStyl3=3') else
      Add('ftStyl3=0');
  Add('bkColo3='+intToStr(manuscript4ufstrongwind.Memo1.Color));

  Add('bokLang='+IntToStr(RadioGroup1.ItemIndex));
  Add('inter00='+ComboBox1.Text);

  if ComboBox1.Items.Count > 0 then
   for i:=0 to ComboBox1.Items.Count-1 do
    Add('interXX='+ComboBox1.Items[i]);

  SaveToFile(Label5.Caption);
 end;
end;

procedure Tmanuscript4ufconf.Button13Click(Sender: TObject); {Save As}
begin
 SaveDialog1.FilterIndex:=1;
 if SaveDialog1.Execute then begin
  label5.Caption:=SaveDialog1.FileName;
  Button12Click(Sender); {Save .INI}
//  Caption:='After choosing A and B, click on button "Load".';
 end;
end;

procedure Tmanuscript4ufconf.Button14Click(Sender: TObject); {Load}
begin
  manuscript4uf1.LoadBooks;
  Caption:=StProgName;
end;

procedure Tmanuscript4ufconf.Button15Click(Sender: TObject);
begin
  manuscript4ufcomp.Show;
end;

procedure Tmanuscript4ufconf.Button17Click(Sender: TObject);{Strongs Font}
var clAux:Cardinal;
begin
  if FontDialog1.Execute then begin
   clAux:=manuscript4ufstrongwind.Memo1.Font.Color;
//   clAux:=manuscript4uf1.Memo1.Font.Color;
   manuscript4ufstrongwind.Memo1.Font := FontDialog1.Font;
   manuscript4ufstrongwind.Memo1.Font.Color:=clAux
//   manuscript4ufstrongwind.Memo1.Font.Color:=clAux;
  end;
end;

procedure Tmanuscript4ufconf.Button18Click(Sender: TObject);{Strongs Font color}
//var clAux:Cardinal;
begin
  if ColorDialog1.Execute then begin
//
   manuscript4ufstrongwind.Memo1.Font.Color := ColorDialog1.Color;
//
  end;
end;

procedure Tmanuscript4ufconf.Button19Click(Sender: TObject);{Strongs Background color}
//var clAux:Cardinal;
begin
  if ColorDialog1.Execute then begin
//   clAux:=manuscript4ufstrongwind.Memo1.Color;
   manuscript4ufstrongwind.Memo1.Color := ColorDialog1.Color;
//   manuscript4ufstrongwind.Memo1.Color:=clAux
  end;
end;

procedure Tmanuscript4ufconf.Button1Click(Sender: TObject); {Choose A}
begin
  OpenDialog1.FilterIndex:=1;
  if OpenDialog1.Execute then begin
   label2.Caption:=OpenDialog1.FileName;
   Caption:='After choosing A and B, click on button "Load".';
  end;
end;

procedure Tmanuscript4ufconf.Button6Click(Sender: TObject);  {Choose B}
begin
  OpenDialog1.FilterIndex:=1;
  if OpenDialog1.Execute then begin
   label4.Caption:=OpenDialog1.FileName;
   Caption:='After choosing A and B, click on button "Load".';
  end;
end;

procedure Tmanuscript4ufconf.Button2Click(Sender: TObject); {Font A}
var clAux:Cardinal;
begin
  if FontDialog1.Execute then begin
   clAux:=manuscript4uf1.Memo1.Font.Color;
   manuscript4uf1.Memo1.Font := FontDialog1.Font;
   manuscript4uf1.Memo1.Font.Color:=clAux;
  end;
end;

procedure Tmanuscript4ufconf.Button7Click(Sender: TObject);  {Font B}
var clAux:Cardinal;
begin
  if FontDialog1.Execute then begin
   clAux:=manuscript4uf1.Memo2.Font.Color;
   manuscript4uf1.Memo2.Font := FontDialog1.Font;
   manuscript4uf1.Memo2.Font.Color:=clAux;
  end;
end;

procedure Tmanuscript4ufconf.Button3Click(Sender: TObject); {Font color A}
begin
  if ColorDialog1.Execute then begin
   manuscript4uf1.Memo1.Font.Color := ColorDialog1.Color;
  end;
end;

procedure Tmanuscript4ufconf.Button8Click(Sender: TObject); {Font color B}
begin
  if ColorDialog1.Execute then begin
   manuscript4uf1.Memo2.Font.Color := ColorDialog1.Color;
  end;
end;

procedure Tmanuscript4ufconf.Button4Click(Sender: TObject); {Back color A}
begin
  if ColorDialog1.Execute then begin
    manuscript4uf1.Memo1.Color := ColorDialog1.Color;
   end;
end;

procedure Tmanuscript4ufconf.Button9Click(Sender: TObject); {Back color B}
begin
  if ColorDialog1.Execute then begin
    manuscript4uf1.Memo2.Color := ColorDialog1.Color;
   end;
end;

procedure Tmanuscript4ufconf.FormCreate(Sender: TObject);
begin
  Label5.Caption:='manuscript4u.ini';
  RadioGroup1.Items.Strings[0]:=copy(manuscript4uf1.MemoBookNames.Lines[0],11,25);
  RadioGroup1.Items.Strings[1]:=copy(manuscript4uf1.MemoBookNames.Lines[0],43,25);
end;

end.

