#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

#koko, AAA㑱ꉹŐsꉹƓɂȂȂ悤ɂƂB
#koko, sAšŒ͈͂ɒB鉹͔ƂB
#koko, Gx[vp3łƂB

#---------------------------------------------------
# ϐ
#---------------------------------------------------

if {[info exists ::starkit::topdir]} {
  set topdir [file dirname [info nameofexecutable]]
} else {
  set topdir [file dirname $argv0]
}

set v(appname) scat
set v(version) 0.1
set v(delParam) 1       ;# 1=͂ꂽslƃI[o[bvl폜ďo͂
set v(repetition) 1     ;# 0=AȂ悤ɂ
set v(flagN) 0          ;# FormantFilterOFFɂm
set v(flagG) 0          ;# 1=gtO_ɕύX
set v(gMin) 0           ;# gtO̍ŏl
set v(gMax) 0           ;# gtO̍ől
set v(candidateChar) ",,,"
set v(rangeL) 0         ;# vOCŏJnsi[#PREV]̎[]j
set v(rangeR) 0         ;# vOCŏIs̎̍si[#NEXT]̈ʒuj

if {$argc > 0} {
  set inFile  [lindex $argv 0]
  set outFile $inFile
} else {
  tk_messageBox -message "usage: $argv0 inUstfile" \
    -title error -icon warning
  exit
}

array unset ustData     ;# ustf[^

#---------------------------------------------------
# Tu[`
#---------------------------------------------------

#--------------------------------------
# ustf[^ǂ
#
proc readUst {inFile} {
  global ustData v

  set v(N) 0
  if [catch {open $inFile r} in] {
    tk_messageBox -message "$inFileǂݍ߂܂" \
      -title error -icon warning
    return 1
  }
  array unset ustData
  set ustDataSeq 0
  while {![eof $in]} {
    set l [gets $in]
    set ustData($ustDataSeq) $l
    incr ustDataSeq
  }
  set v(N) [array size ustData]
  return 0
}

#--------------------------------------
# [#PREV]̎̈ʒuA[#NEXT]̑Öʒu𓾂
#
proc getRangeLR {} {
  global ustData v

  set v(rangeL) 0
  set v(rangeR) 0

  # rangeL߂
  set i 0
  while {$i < $v(N)} {
    if [regexp {^\[#[0-9]+\]} $ustData($i)] {
      set v(rangeL) $i
      break
    }
    incr i
  }
  # rangeR߂
  while {$i < $v(N)} {
    if [regexp {^\[#NEXT\]} $ustData($i)] {
      set v(rangeR) $i
      break
    }
    incr i
  }
  return 0
}


#--------------------------------------
# eLyric_ȕɏ
#
proc changeLyric {} {
  global ustData v

  set newLyric ""
  set oldLyric ""
  for {set i [expr $v(rangeL) +1]} {$i < $v(rangeR)} {incr i} {
    if [regexp {^Lyric=} $ustData($i)] {
      set l [split $ustData($i) "="]
      if {[lindex $l 1] != "R"} {
        set newLyric [lindex $v(lyricList) [expr int(rand() * $v(lyricListN))]]
        while {$v(repetition) == 0 && $newLyric == $oldLyric && $v(lyricListN) > 1} {
          set newLyric [lindex $v(lyricList) [expr int(rand() * $v(lyricListN))]]
        }
        set ustData($i) "Lyric=$newLyric"
        set oldLyric $newLyric
      }
    }
  }
  return 0
}

#--------------------------------------
# eɃ_ɕ蓖ĂLyricu
#
proc changeLyric2 {} {
  global ustData v

  # eɕ蓖ĂiȂAUTAUNoteNum͈̔͂24107j
  array unset wariate
  for {set i 0} {$i < 128} {incr i} {
    set wariate($i) [lindex $v(lyricList) [expr int(rand() * $v(lyricListN))]]
  }

  # ẻ(NoteNum)𓾂
  array unset noteNum
  set seq 0
  for {set i [expr $v(rangeL) +1]} {$i < $v(rangeR)} {incr i} {
    if [regexp {^NoteNum=} $ustData($i)] {
      set l [split $ustData($i) "="]
      set noteNum($seq) [lindex $l 1]
      incr seq
    }
  }

  # eLyricΉ镶ɏ
  set seq 0
  for {set i [expr $v(rangeL) +1]} {$i < $v(rangeR)} {incr i} {
    if [regexp {^Lyric=} $ustData($i)] {
      set l [split $ustData($i) "="]
      if {[lindex $l 1] != "R"} {
        set newLyric $wariate($noteNum($seq))
        set ustData($i) "Lyric=$newLyric"
        set oldLyric $newLyric
      }
      incr seq
    }
  }
  return 0
}

#--------------------------------------
# egtO_ɓւ
#
proc changeFlagG {} {
  global ustData v

  if {$v(flagG) == 0} {return 0}

  set changed 0
  set i [expr $v(rangeL) +1]
  while {$i < $v(rangeR)} {
    # gl߂
    set gnew [expr int(rand() * ($v(gMax) - $v(gMin)) + $v(gMin))]

    if [regexp {^\[#[0-9]+\]} $ustData($i)] {
      # ỎFlags̎w肪ȂȂ
      if {$changed == 0} {
        # Flags̃Gg}
        for {set j [expr $v(N) - 1]} {$j >= $i} {incr j -1} {
          set k [expr $j + 1]
          set ustData($k) $ustData($j)
        }
        set ustData($i) "Flags=g$gnew"
        incr v(N)
        incr v(rangeR)
        incr i
      }
      set changed 0

    } elseif [regexp {^Flags=} $ustData($i)] {
      regsub {g(\+|\-|)[0-9]+} $ustData($i) "" ustData($i)   ;# gtO
      set ustData($i) "$ustData($i)g$gnew"
      set changed 1
    }
    incr i
  }
  return 0
}

#--------------------------------------
# eN FlagON/OFF_ɓւ
#
proc changeFlagN {} {
  global ustData v

  if {$v(flagN) <= 0} {return 0}

  set changed 0
  set i [expr $v(rangeL) +1]
  while {$i < $v(rangeR)} {
    # formant filterON/OFF߂l߂
    set flagN [expr rand() * 100]

    if [regexp {^\[#[0-9]+\]} $ustData($i)] {
      # ỎFlags̎w肪ȂȂ
      if {$changed == 0} {
        # formant filter𖳌ɂ邩
        if {$flagN < $v(flagN)} {
          # Flags̃Gg}
          for {set j [expr $v(N) - 1]} {$j >= $i} {incr j -1} {
            set k [expr $j + 1]
            set ustData($k) $ustData($j)
          }
          set ustData($i) "Flags=N"
          incr v(N)
          incr v(rangeR)
          incr i
        }
      }
      set changed 0

    } elseif [regexp {^Flags=} $ustData($i)] {
      regsub {N} $ustData($i) "" ustData($i)   ;# NtO
      # formant filter𖳌ɂ邩
      if {$flagN < $v(flagN)} {
        set ustData($i) "$ustData($i)N"
      }
      set changed 1
    }
    incr i
  }
  return 0
}

#--------------------------------------
# beLXgt@CɏށBIȂ0ԂB
#
proc writeUst {outFile} {
  global ustData v

  if [catch {open $outFile w} out] {
    tk_messageBox -message "$outFileɏ߂܂" \
      -title error -icon warning
    return 1
  }
  for {set i 0} {$i < $v(N)} {incr i} {
    if {$v(delParam) != 0 && [regexp {^(PreUtterance|VoiceOverlap)=} $ustData($i)]} {
    } else {
      puts $out $ustData($i)
    }
  }
  close $out
  return 0
}

#--------------------------------------
# s
#
proc doChange {mode} {
  global inFile outFile v

  if [readUst $inFile]   exit
  if [getRangeLR]        exit

  set v(lyricList)  [split $v(candidateChar) ","]
  set v(lyricListN) [llength $v(lyricList)]

  switch $mode {
    1 { if [changeLyric]  exit }
    2 { if [changeLyric2] exit }
  }

  if [changeFlagN] exit
  if [changeFlagG] exit
  if [writeUst $outFile] exit
  exit
}

#---------------------------------------------------
# widget
#---------------------------------------------------

labelframe .fs -relief groove -padx 5 -pady 5 -labelanchor n -text "ݒ"
label .fs.lCC -text "gp镶(J}݂Ŏw)"
entry .fs.eCC -textvar v(candidateChar) -width 60
checkbutton .fs.cDelParam -text "̐sƃI[o[bv폜" -variable v(delParam)
checkbutton .fs.cRepetition -text "AĂ悢(ŝP̐ݒ荀)" -variable v(repetition)
#label .fs.lNF -text "(ł͖)formant filter_OFFɂm(0-100B0ȂύX)"
#entry .fs.eNF -textvar v(flagN)
checkbutton .fs.cFlagG -text "gtO_ɕύX" -variable v(flagG)
label .fs.lGMin -text "gtO̍ŏl"
entry .fs.eGMin -textvar v(gMin)
label .fs.lGMax -text "gtO̍ől"
entry .fs.eGMax -textvar v(gMax)
grid .fs.lCC -row 0 -column 0 -sticky e -pady 5
grid .fs.eCC -row 0 -column 1 -columnspan 3 -sticky ew -pady 5
grid .fs.cDelParam   -row 1 -column 0 -columnspan 4 -sticky w -pady 5
grid .fs.cRepetition -row 2 -column 0 -columnspan 4 -sticky w -pady 5
grid .fs.cFlagG -row 3 -column 0 -columnspan 4 -sticky w -pady 5
grid .fs.lGMin  -row 4 -column 0 -sticky e -pady 5
grid .fs.eGMin  -row 4 -column 1 -sticky ew -pady 5
grid .fs.lGMax  -row 4 -column 2 -sticky e -pady 5
grid .fs.eGMax  -row 4 -column 3 -sticky ew -pady 5

labelframe .fb -relief groove -padx 5 -pady 5 -labelanchor n -text "s"
button .fb.bDoChange  -text "sPieɕ_ɑj" -command {doChange 1}
button .fb.bDoChange2 -text "sQieɕ_Ɋ蓖Ăj" -command {doChange 2}
button .fb.bCancel    -text "LZ" -command exit
pack .fb.bDoChange .fb.bDoChange2 .fb.bCancel -side left

grid .fs -row 0 -column 0 -sticky ew -pady 5 -padx 3
grid .fb -row 1 -column 0 -sticky ew -pady 5 -padx 3

wm title . "$v(appname) $v(version)"
