// 汎用処理定義
// この sourceは UI thread, Worker threadのそれぞれから呼び出される

var DEBUGLOG = true;
debuglog = (true==DEBUGLOG)? debugLog : logQuiet;

function debugLog(str) {
	console.log(str);
};
function logQuiet(str) {
	// 処理なし
};



function rectData( left, top, right, bottom ) {
	this.setData( left, top, right, bottom );
};
rectData.prototype.setData = function ( left, top, right, bottom ) {
	this.left = parseInt(left);
	this.top = parseInt(top);
	this.right = parseInt(right);
	this.bottom = parseInt(bottom);
};
rectData.prototype.setLTWH = function (left, top, width, height) {
	this.left = parseInt(left);
	this.top = parseInt(top);
	this.right = this.left + parseInt(width);
	this.bottom = this.top + parseInt(height);
};


function angle(x1, y1, x2, y2) {
	let theta = Math.atan2(y2 - y1, x2 - x1);
	if (theta < 0) {
		theta = theta + 2 * Math.PI;
	}
	return (theta * 360 / (2 * Math.PI) - 90); // atan2は X軸基準での角度を出すため、画面表示系の Y軸基準に合わせるため 90を減算する
};


class SaveFile {
	constructor() {
		this.filename = null;
		this.callbackComplete = null;
		this.callbackError = null;
	}

	// ブラウザ上で実行している場合のファイル保存処理
	saveFileBrowser(filename, data) {
		// Blobに変換して download
		let blob = new Blob([data], { type: "text/plain" });
		let a = document.createElement('a');
		a.href = URL.createObjectURL(blob);
		a.target = '_blank';
		a.download = filename;	// Edgeは無効……
		a.click();

		// download完了後に memory解放したほうがいい
		// URL.revokeObjectURL();
	};

	// アプリケーションとして実行している場合のファイル保存処理
	saveFileApp(filename, data, callbackComplete, callbackError) {
		if (null != callbackComplete) this.callbackComplete = callbackComplete;
		if (null != callbackError) this.callbackError = callbackError;

		// Unique filename作成 (ABC.txtが既にある → ABC(1).txt という file nameになる
		// write, append指定はerrorになる。filepickerかmanifestで権限取得する必要があるかも
		let fileoption = Windows.Storage.CreationCollisionOption.generateUniqueName;
		Windows.Storage.DownloadsFolder.createFileAsync(filename, fileoption).done(this.saveFileAppOpenFile.bind(this, data), this.saveFileError.bind(this));
	};

	// 以下、Private関数 -------------------

	saveFileAppOpenFile(savedata, file) {	// [!!caution] callback設定時に savedataを無理やりbind済み
		// 実際に書き込まれた file nameを取得
		let name = file.name;
		// file objectの pathを参照すると保存先 folderが大変なことになっているが
		// 実際に保存される場所は Downloads/<ApplicationName>/ になる

		// この時点で fileは既に open済みになっている
		// fileへデータ書き込み
		Windows.Storage.FileIO.writeTextAsync(file, savedata);
		// 書き込み完了チェック
		Windows.Storage.CachedFileManager.completeUpdatesAsync(file).done(this.saveFileComplete.bind(this), this.saveFileError.bind(this));

	};
	saveFileComplete() {
		// 保存完了
		debuglog('ファイル保存完了');

		if (null != this.callbackComplete) this.callbackComplete();
	};
	saveFileError(err) {
		console.error('ファイル保存エラー\nerror=' + err.message + 'description=' + err.description);
		if (null != this.callbackError) this.callbackError(err.message);
	};
}	// class SaveFile
