
class CDispObj {
	constructor() {
		this.ObjID = 0;
		this.GroupID = 0;
		this.type = 0;
		this.x = 0.0;
		this.y = 0.0;
		this.width = 0.0;
		this.height = 0.0;
		this.opacity = 1.0;
		this.degree = 0;
		this.text = null;
		this.transformStr = null;
		this.DOMobject = null;
		this.renderFunc = new Queue();

		this.originalWidth = 0;
		this.originalHeight = 0;

		this.dropinitsize = 100.0;
	}

	debuglog(str) {
		debuglog("【DispObj " + this.ObjID + "】" + str);
	}



	// ブラウザ上への描画 -------------------------

	// コマンド要求実行後の描画共通処理
	// requestAnimationFrameのcallbackから呼び出される
	render() {
		while (0 < this.renderFunc.size()) {
			this.debuglog("render() renderFunc size=" + this.renderFunc.size());
			let renderFunction = this.renderFunc.dequeue();
			renderFunction();
		}
	}

	// コマンド実行処理 -----------------------------

	// DIV Box作成
	// 作成 ObjIDMgrへの登録も行う
	create(type, rect, opt1) {
		this.debuglog("DispObj.Create() called. type=" + type + ", left=" + rect.left + ", top=" + rect.top + ", right=" + rect.right + ", bottom=" + rect.bottom);
		let ret = this.checkType(type);
		if (false == ret) {
			console.error("【CDispObj XX】 create() object type error. type = " + type);
			return false;
		}
		this.type = type;

		// ObjIDMgrへ 自身の登録
		this.ObjID = window.ObjIDMgr.registerDispObj(this);
		if (this.ObjID < 0) {
			console.error("【CDispObj XX】 create() ObjID error. ObjID = " + this.ObjID);
			return false;
		}
		// サイズ設定
		this.x = rect.left;
		this.y = rect.top;
		this.width = rect.right - rect.left;
		this.height = rect.bottom - rect.top;
		this.originalWidth = this.width;
		this.originalHeight = this.height;

		// 画面に影響しない範囲で作成できるところまで Dom objectを作成する
		let elType = (null != type.match(/imagebox/)) ? 'img' : 'div';
		this.DOMobject = document.createElement(elType);
		this.DOMobject.dataset.objid = this.ObjID;
		this.DOMobject.dataset.orgwidth = this.originalWidth;	// transform: scaleの基準サイズ
		this.DOMobject.dataset.orgheight = this.originalHeight;
		this.DOMobject.dataset.degree = 0;
		this.DOMobject.addEventListener('mousedown', this.onMouseDown.bind(this), false);
		if (null != type.match(/imagebox/)) {
			// imageの場合、画像読み込み完了後に描画する必要がある
			this.loadImage(opt1);
		}
		else {
			if (null != opt1) {
				this.loadText(opt1);
			}
			else {
				// 描画呼び出し時に呼び出す関数を登録
				this.renderFunc.enqueue(this.renderCreate.bind(this));
			}
		}
		return true;
	}
	loadText(file) {
		let reader = new FileReader();
		// fileを読み込み
		reader.readAsText(file);	// UTF-8として読み込み
		reader.onload = function (evt) {
			this.text = evt.target.result;
			// 描画呼び出し時に呼び出す関数を登録
			this.renderFunc.enqueue(this.renderCreate.bind(this));
		}.bind(this);
	}
	loadImage(file) {
		let reader = new FileReader();
		// fileを読み込み
		reader.readAsDataURL(file);
		reader.onload = function (evt) {
			// src属性にURLをセットして、画像として再度読み込み
			this.DOMobject.src = evt.target.result;
			this.DOMobject.onload = function (evt) {
				// 画像としての読み込み完了後に幅と高さが取れる
				// 大きすぎ/小さすぎても困るため初期サイズに収まるように拡大/縮小
				let rect = this.calcImageWH(parseInt(evt.target.naturalWidth), parseInt(evt.target.naturalHeight));
				this.width = rect.right - rect.left;
				this.height = rect.bottom - rect.top;
				this.originalWidth = this.width;
				this.originalHeight = this.height;
				this.DOMobject.dataset.orgwidth = this.originalWidth;	// transform: scaleの基準サイズ
				this.DOMobject.dataset.orgheight = this.originalHeight;
				// 表示サイズ取得完了したので画面に表示
				this.renderFunc.enqueue(this.renderCreate.bind(this));
			}.bind(this);
		}.bind(this);
	}
	calcImageWH(srcW, srcH) {
		let destW = 0;
		let destH = 0;
		let isLongWidth = (srcW < srcH) ? false : true;
		if (isLongWidth) {
			let ratio = this.dropinitsize / srcW;
			destW = this.dropinitsize;
			destH = srcH * ratio;
		}
		else {
			let ratio = this.dropinitsize / srcH;
			destH = this.dropinitsize;
			destW = srcW * ratio;
		}
		return new rectData(0, 0, destW, destH);
	}
	renderCreate() {
		this.DOMobject.style.position = "absolute"; // 決め打ち
		this.DOMobject.style.left = this.x.toString() + "px";
		this.DOMobject.style.top = this.y.toString() + "px";
		this.DOMobject.style.width = this.width.toString() + "px";
		this.DOMobject.style.height = this.height.toString() + "px";
		this.DOMobject.style.border = "1px solid black"; // 指定するI/Fが必要
//		this.DOMobject.style.backgroundColor = "#cdcdcd";
		if (null != this.text) this.DOMobject.innerHTML = this.text;

		document.getElementById('DispField').appendChild(this.DOMobject);

		this.debuglog("renderCreate() left=" + this.DOMobject.style.left
								  + ", top=" + this.DOMobject.style.top
								  + ", width=" + this.DOMobject.style.width
								  + ", height=" + this.DOMobject.style.height
								  + ", border=" + this.DOMobject.style.border);
	}

	// DIV box 移動 (移動先確定後の移動)
	// ※ Drag中の表示は別で行っている
	movebox(x, y) {
		this.x = x;
		this.y = y;
		this.renderFunc.enqueue(this.rendermove.bind(this));

		this.debuglog("movebox() x=" + this.x + ", y=" + this.y + ", renderFunc size=" + this.renderFunc.size());
	}
	rendermove() {
		this.DOMobject.style.left = this.x.toString() + "px";
		this.DOMobject.style.top = this.y.toString() + "px";
		this.DOMobject.style.opacity = this.opacity.toString();

		this.debuglog("rendermove() left=" + this.DOMobject.style.left
												 + ", top=" + this.DOMobject.style.top
												 + ", width=" + this.DOMobject.style.width
												 + ", height=" + this.DOMobject.style.height
												 + ", border=" + this.DOMobject.style.border);
	}

	scalebox(rect) {
		this.x = rect.left;
		this.y = rect.top;
		this.width = rect.right - rect.left;
		this.height = rect.bottom - rect.top;
		this.renderFunc.enqueue(this.renderscalebox.bind(this));
	}
	renderscalebox() {
		this.DOMobject.style.left = this.x.toString() + "px";
		this.DOMobject.style.top = this.y.toString() + "px";
		this.DOMobject.style.width = this.width.toString() + "px";
		this.DOMobject.style.height = this.height.toString() + "px";
		this.DOMobject.style.opacity = this.opacity.toString();
	}

	rollbox(degree) {
		this.degree = degree;
		this.DOMobject.dataset.degree = degree;
		this.renderFunc.enqueue(this.renderrollbox.bind(this));
	}
	renderrollbox() {
		this.DOMobject.style.transform = 'rotateZ(' + this.degree + 'deg);';
	}



	checkType(str) {
		return true;
	}





	// イベント処理関数 ---------------------------
	onMouseDown(evt) {
		this.debuglog("onMouseDown");
		if (0 == (evt.buttons & 0x0001)) {	// 左クリックチェック
			return;
		}
		// Mouse eventをDisplayFieldからScalerに渡してもらうように設定
		window.displayField.setMouseEventObj(this.mouseMove.bind(this), this.mouseUp.bind(this));


		// Focus設定
		evt.target.dataset.focus = "true";
		// 移動元として座標を保持
		this.startDragX = evt.pageX;
		this.startDragY = evt.pageY;

		// Focus表示
		window.partsFocus.setClingingPartner(this.DOMobject);

	}
	mouseMove(evt) {
		// 画像の仮移動
		this.endDragX = evt.pageX;
		this.endDragY = evt.pageY;
		// 移動量取得
		let moveX = this.endDragX - this.startDragX;
		let moveY = this.endDragY - this.startDragY;
		// dispObjがあった位置からマウス移動分移動させた後の位置取得
		moveX = this.x + moveX;
		moveY = this.y + moveY;

		this.renderFunc.enqueue(this.renderMoveDragging.bind(this, moveX, moveY));
	}
	renderMoveDragging(x, y) {
		this.DOMobject.style.left = x + "px";
		this.DOMobject.style.top = y + "px";
		this.DOMobject.style.opacity = 0.4;
	}
	mouseUp(evt) {
		this.debuglog("mouseUp");
		// Mouse event処理対象をクリア
		window.displayField.setMouseEventObj(null, null);


		// 移動元として座標を保持
		this.endDragX = evt.pageX;
		this.endDragY = evt.pageY;
		// 移動量取得
		let moveX = this.endDragX - this.startDragX;
		let moveY = this.endDragY - this.startDragY;
		// dispObjがあった位置からマウス移動分移動させた後の位置取得
		let rect = new rectData(this.x + moveX, this.y + moveY, 0, 0);

		// 移動 Command発行
		let cmd = new CCommandObj();
		cmd.createCommand(cmdType.request, cmdAddress.ObjIDMgr, cmdAddress.ObjIDMgr, cmdCmd.movebox, rect, this.ObjID, 4);
		this.debuglog("postToWorker");
		window.postToWorker.post(cmd);
	}


} // class CDispObj


