

class CDisplayField {
	constructor(dom) {
		this.DOMobject = dom;
		this.renderFunc = new Queue();
		this.mouseMoveFunc = null;
		this.mouseUpFunc = null;
	}

	debuglog(str) {
		debuglog("【DisplayField】" + str);
	}

	// ■ 初期化
	initialize() {
		if (null == this.DOMobject) {
			console.log("【DisplayField】 initialize()  DOMobject is null.");
			return false;
		}
		this.debuglog("initialize");
		this.DOMobject.addEventListener('mousemove', this.onMouseMove.bind(this), false);
		this.DOMobject.addEventListener('mousedown', this.onMouseDown.bind(this), false);
		this.DOMobject.addEventListener('mouseup', this.onMouseUp.bind(this), false);
		this.DOMobject.addEventListener('dragstart', this.onDragStart.bind(this), false);
		this.DOMobject.addEventListener('dragover', this.onDragover.bind(this), false);
		this.DOMobject.addEventListener('drop', this.onDrop.bind(this), false);
	}

	// Mouse eventを処理するObj
	setMouseEventObj(mouseMove, mouseUp) {
		this.debuglog('setMouseEventObj');

		this.mouseMoveFunc = mouseMove;
		this.mouseUpFunc = mouseUp;
	}

	// ブラウザ上への描画 -------------------------
	render() {
		while (0 < this.renderFunc.size()) {
			//			this.debuglog("render() renderFunc size=" + this.renderFunc.size());
			let renderFunction = this.renderFunc.dequeue();
			renderFunction();
		}
	}



	// Event handler -------------------

	// ■マウス左ボタン押下 (Drag処理)
	onMouseDown(evt) {
	}
	// ■ マウス移動 (ドラッグ中)
	onMouseMove(evt) {
		if (null != this.mouseMoveFunc) {
			this.mouseMoveFunc(evt);
			return;
		}
	}
	// ■ ドロップ処理
	onMouseUp(evt) {
		if (null != this.mouseUpFunc) {
			this.mouseUpFunc(evt);
			return;
		}
	}

	// 表示要素の drag & drop禁止
	onDragStart(evt) {
		evt.preventDefault();
	}
	onDragover(evt) {
		evt.preventDefault();
		evt.dataTransfer.dropEffect = "move";
	}
	onDrop(evt) {
		let ret = false;
		this.debuglog('onDrop');
		evt.stopPropagation();				// event伝播を自分のところで止める(上位に行かなくなる)
		evt.stopImmediatePropagation();		// 処理中要素の他のevent listenerを止める
		evt.preventDefault();				// 要素既定のdefault動作を止める
		let files = evt.dataTransfer.files;
		if (!files) {
			console.error('dropされた file listが取得できない');
			return ret;
		}
		if (files.length <= 0) {
			// Fileではないものを Dropされると発生
			console.error('drop fileの file list length == 0');
			return ret;
		}
		let dropfile = null;
		for (var cnt = 0; cnt < files.length; cnt++) {
			dropfile = files[cnt];
			if (null != dropfile.type.match(/image/)) {

				// 画像box 作成 command要求
				let rect = new rectData(205, 205, 255, 255);
				var cmd = new CCommandObj();
				// Image box 新規作成 command(新規なので objidを指定する箇所はない)												   出力先rect, img blob
				cmd.createCommand(cmdType.request, cmdAddress.DisplayField, cmdAddress.ObjIDMgr, cmdCmd.createImagebox, rect, dropfile, null, 6);
				window.postToWorker.post(cmd);

				ret = true;
			}
			else if (null != dropfile.type.match(/text\/plain/)) {

				// Textbox作成 command要求
				let rect = new rectData(205, 205, 255, 255);
				var cmd = new CCommandObj();
				// Text box 新規作成 command(新規なので objidを指定する箇所はない)											     出力先rect, txt blob
				cmd.createCommand(cmdType.request, cmdAddress.DisplayField, cmdAddress.ObjIDMgr, cmdCmd.createTextbox, rect, dropfile, null, 6);
				window.postToWorker.post(cmd);

				ret = true;
			}
		}

		if (false == ret) {
			console.error('Drop file error. Drop するファイルは 画像かテキストにしてください\n'
						+ 'type=' + files[0].type.toString() + ', name=' + files[0].name.toString());
		}
		return ret;
	}







	// DOM obj → 対応する dispObjへ変換
	getDOMtoDispObj(dom) {
		if (true == /^DisplayField/.test(dom.dataset.objid)) return null;	// DisplayFieldを指しているのでreturn
		var dispObj = window.ObjIDMgr.getIDtoDispObj(dom.dataset.objid);
		if (null == dispObj) {
			console.log("dispObj取得失敗 dom.dataset.objid=" + dom.dataset.objid);
			return null;
		}
		return dispObj;
	}

}	// class CDisplayField
