
// [data-focus="true"] の場合のみ CSSで borderを変更したかったが
// DOMに直接 style指定するとその指定が最優先となるため CSSで上書きできない
// また、図形として borderを指定したい場合もあるため border: noneにもできない
// そのため Focus図形を描く専用の DOMを用意する
class CPartsFocus {
	constructor() {
		this.lineWidth = 2;
		this.markWidth = 20;
		this.num2str = ['focusleft', 'focustop', 'focusright', 'focusbottom'];
		this.clingingPartner = null;
		this.DOM = [null, null, null, null];		// focus表示用
		this.domScaler = null;
		this.domRoller = null;
		this.renderFunc = new Queue();
	}

	debuglog(str) {
		var focused = (null == this.clingingPartner) ? "null" : this.clingingPartner.dataset.objid;
		debuglog("【PartsFocus】 focused objid=" + focused + ", " + str);
	}


	// ブラウザ上への描画 -------------------------

	// domの淵を囲むように Focus lineを表示する
	// requestAnimationFrameからの呼び出しを想定
	render() {
		while (0 < this.renderFunc.size()) {
			//			this.debuglog("render() renderFunc size=" + this.renderFunc.size());
			let renderFunction = this.renderFunc.dequeue();
			renderFunction();
		}

		// Drag & Dropを追いかけるための処理
		this.renderClinging();
	}
	renderClinging() {
		if (null == this.clingingPartner) return;

		let originX = parseInt(this.clingingPartner.style.width) / 2;
		let originY = parseInt(this.clingingPartner.style.height) / 2;
		//								DOM			描画先rect			回転の中心位置
		this.renderClingingSetPosition(this.DOM[0], this.getRectLeft(), (originX + this.lineWidth / 2) + 'px', '50%');
		this.renderClingingSetPosition(this.DOM[1], this.getRectTop(), '50%', (originY + this.lineWidth / 2) + 'px');
		this.renderClingingSetPosition(this.DOM[2], this.getRectRight(), (originX - this.lineWidth / 2) * -1 + 'px', '50%');
		this.renderClingingSetPosition(this.DOM[3], this.getRectBottom(), '50%', (originY - this.lineWidth / 2) * -1 + 'px');
		this.renderClingingSetPosition(this.domScaler, this.getRectScaler(), (originX - this.markWidth / 2) * -1 + 'px', (originY - this.markWidth / 2) * -1 + 'px');
		//		this.renderClingingSetPosition( this.domRoller, this.getRectRoller(),	(originX - this.markWidth / 2) * -1 + 'px', (originY + this.markWidth / 2) + 'px');
		this.renderClingingSetPosition(this.domRoller, this.getRectRoller(), '50%', (originY + this.markWidth / 2) + 'px');
	}
	renderClingingSetPosition(dom, rect, ox, oy) {
		dom.style.left = rect.left.toString() + "px";
		dom.style.top = rect.top.toString() + "px";
		dom.style.width = (rect.right - rect.left).toString() + "px";
		dom.style.height = (rect.bottom - rect.top).toString() + "px";
		//		dom.style.border		= "1px solid blue";
		dom.style.transform = this.clingingPartner.style.transform;
		dom.style.transformOrigin = ox + ' ' + oy + ';';	// 回転の中心を focus対象の中心点に合わせる
	}



	// Elementの描画 size取得関数 -------------------------

	// Focusとして描画する４つのbar それぞれの サイズ取得
	getRectLeft() {
		if (null == this.clingingPartner) return new rectData(0, 0, 0, 0);
		let rect = new rectData();
		rect.setLTWH(this.clingingPartner.style.left, this.clingingPartner.style.top, this.clingingPartner.style.width, this.clingingPartner.style.height);
		rect.left -= this.lineWidth / 2;         rect.top -= this.lineWidth / 2;
		rect.right = rect.left + this.lineWidth; rect.bottom += this.lineWidth / 2;
		return rect;
	}
	getRectTop() {
		if (null == this.clingingPartner) return new rectData(0, 0, 0, 0);
		let rect = new rectData();
		rect.setLTWH(this.clingingPartner.style.left, this.clingingPartner.style.top, this.clingingPartner.style.width, this.clingingPartner.style.height);
		rect.left  += this.lineWidth / 2; rect.top -= this.lineWidth / 2;
		rect.right -= this.lineWidth / 2; rect.bottom = rect.top + this.lineWidth;
		return rect;
	}
	getRectRight() {
		if (null == this.clingingPartner) return new rectData(0, 0, 0, 0);
		let rect = new rectData();
		rect.setLTWH(this.clingingPartner.style.left, this.clingingPartner.style.top, this.clingingPartner.style.width, this.clingingPartner.style.height);
		rect.right += this.lineWidth / 2;        rect.bottom += this.lineWidth / 2;
		rect.left = rect.right - this.lineWidth; rect.top -= this.lineWidth / 2;
		return rect;
	}
	getRectBottom() {
		if (null == this.clingingPartner) return new rectData(0, 0, 0, 0);
		let rect = new rectData();
		rect.setLTWH(this.clingingPartner.style.left, this.clingingPartner.style.top, this.clingingPartner.style.width, this.clingingPartner.style.height);
		rect.right -= this.lineWidth / 2; rect.bottom += this.lineWidth / 2;
		rect.left  += this.lineWidth / 2; rect.top = rect.bottom - this.lineWidth;
		return rect;
	}
	// 拡大縮小用 右下マーカーの rect取得
	getRectScaler() {
		if (null == this.clingingPartner) return new rectData(0, 0, 0, 0);
		let centerX = parseInt(this.clingingPartner.style.left) + parseInt(this.clingingPartner.style.width);
		let centerY = parseInt(this.clingingPartner.style.top)  + parseInt(this.clingingPartner.style.height);
		let rect = new rectData();
		rect.left  = centerX - this.markWidth / 2; rect.top    = centerY - this.markWidth / 2;
		rect.right = centerX + this.markWidth / 2; rect.bottom = centerY + this.markWidth / 2;
		return rect;
	}
	// 回転用 上辺中心部 マーカーの rect取得
	getRectRoller() {
		if (null == this.clingingPartner) return new rectData(0, 0, 0, 0);
		let centerX = parseInt(this.clingingPartner.style.left) + parseInt(this.clingingPartner.style.width) / 2;
		let centerY = parseInt(this.clingingPartner.style.top);
		let rect = new rectData();
		rect.left  = centerX - this.markWidth / 2; rect.top    = centerY - this.markWidth / 2;
		rect.right = centerX + this.markWidth / 2; rect.bottom = centerY + this.markWidth / 2;
		return rect;
	}

	// 表示関数-----------------------------------
	// Focus作成
	create() {
		let getRectProperty = [this.getRectLeft.bind(this), this.getRectTop.bind(this), this.getRectRight.bind(this), this.getRectBottom.bind(this)];
		for (let cnt = 0; cnt < this.num2str.length; cnt++) {
			this.DOM[cnt] = document.createElement('div');
			this.DOM[cnt].dataset.objid = this.num2str[cnt];
			this.DOM[cnt].classList.add('focusimage');
			this.DOM[cnt].classList.add(this.num2str[cnt]);
			this.renderFunc.enqueue(this.renderCreateOneFocusbar.bind(this, this.DOM[cnt], getRectProperty[cnt]()));
		}
		//		this.debuglog("create() renderFunc size=" + this.renderFunc.size());

		this.createScaler();
		this.createRoller();
	}
	renderCreateOneFocusbar(dom, rect) {
		dom.style.display = (null == this.clingingPartner) ? "none" : "block";
		dom.style.position = "absolute";
		dom.style.left   = rect.left.toString() + "px";
		dom.style.top    = rect.top.toString() + "px";
		dom.style.width  = (rect.right - rect.left).toString() + "px";
		dom.style.height = (rect.bottom - rect.top).toString() + "px";
		//		dom.style.border		= "1px solid blue";
		document.getElementById('DispField').appendChild(dom);
	}


	// 拡大縮小操作マーカー作成
	createScaler() {
		this.domScaler = document.createElement('div');
		this.domScaler.dataset.objid = 'scaler';
		this.domScaler.classList.add('scaler');
		this.domScaler.addEventListener('mousedown', this.onMouseDownScale.bind(this), false);
		this.renderFunc.enqueue(this.renderScaler.bind(this, this.getRectScaler()));
	}
	renderScaler(rect) {
		this.domScaler.style.display = (null == this.clingingPartner) ? "none" : "block";
		this.domScaler.style.position = 'absolute';
		this.domScaler.style.left   = rect.left.toString() + "px";
		this.domScaler.style.top    = rect.top.toString() + "px";
		this.domScaler.style.width  = (rect.right - rect.left).toString() + "px";
		this.domScaler.style.height = (rect.bottom - rect.top).toString() + "px";
		//		this.domScaler.style.border			= "1px solid blue";
		document.getElementById('DispField').appendChild(this.domScaler);
	}

	// 回転操作マーカー作成
	createRoller() {
		this.domRoller = document.createElement('div');
		this.domRoller.dataset.objid = 'roller';
		this.domRoller.classList.add('roller');
		this.domRoller.addEventListener('mousedown', this.onMouseDownRoll.bind(this), false);
		this.renderFunc.enqueue(this.renderRoller.bind(this, this.getRectRoller()));
	}
	renderRoller(rect) {
		this.domRoller.style.display = (null == this.clingingPartner) ? "none" : "block";
		this.domRoller.style.position = 'absolute';
		this.domRoller.style.left   = rect.left.toString() + "px";
		this.domRoller.style.top    = rect.top.toString() + "px";
		this.domRoller.style.width  = (rect.right - rect.left).toString() + "px";
		this.domRoller.style.height = (rect.bottom - rect.top).toString() + "px";
		//		this.domRoller.style.border			= "1px solid blue";
		document.getElementById('DispField').appendChild(this.domRoller);
	}

	// 操作関数-----------------------------------
	// Focus中の objid取得
	// 非選択: nullを返す
	getFocusedObjid() {
		this.debuglog("getFocusedObjid().");
		let ret = null;
		if (null != this.clingingPartner) {
			ret = this.clingingPartner.dataset.objid;
		}
		return ret;
	}

	// Forcus先 クリア (focus 非表示)
	clearClingingPartner() {
		this.debuglog("setClingingPartner()  clear focus.");
		this.clingingPartner = null;
		// requestAnimationFrameでの描画タイミング中は DOM.outerHTMLを変更できないため
		// 処理ロジック上のまま削除処理を実行する
		//		this.renderFunc.enqueue( this.renderClearClingingPartner.bind(this) );
		this.debuglog("clearClingingPartner() renderFunc size=" + this.renderFunc.size());

		this.renderClearClingingPartner();
	}
	renderClearClingingPartner() {
		this.debuglog("renderClearClingingPartner()");

		for (let cnt = 0; cnt < this.num2str.length; cnt++) {
			if (null != this.DOM[cnt]) {
				this.DOM[cnt].outerHTML = "";
				delete this.DOM[cnt];
				this.DOM[cnt] = null;
			}
		}
		if (null != this.domScaler) {
			this.domScaler.outerHTML = "";
			delete this.domScaler;
			this.domScaler = null;
		}
		if (null != this.domRoller) {
			this.domRoller.outerHTML = "";
			delete this.domRoller;
			this.domRoller = null;
		}
	}

	// Forcus先設定
	setClingingPartner(dom) {
		this.debuglog("setClingingPartner()");

		// Focus先 クリア
		if (null == dom) {
			this.clearClingingPartner();
			return;
		}
			// Focus先 変更
		else if (this.clingingPartner != dom) {
			// 現在の情報をクリア
			this.clearClingingPartner();
			// 新しいFocus先に変更
			this.clingingPartner = dom;
			this.create();
		}
	}


	// Event handler -------------------------
	onMouseDownScale(evt) {
		this.debuglog('onMouseDownScale');

		// Mouse eventをDisplayFieldからScalerに渡してもらうように設定
		window.displayField.setMouseEventObj(this.mouseMoveScale.bind(this), this.mouseUpScale.bind(this));

		// 移動元として座標を保持
		this.scaleStartWidth  = parseInt(this.clingingPartner.style.width);
		this.scaleStartHeight = parseInt(this.clingingPartner.style.height);
		this.startDragX = evt.pageX;
		this.startDragY = evt.pageY;
	}
	mouseMoveScale(evt) {
		// 画像の仮変形
		this.endDragX = evt.pageX;
		this.endDragY = evt.pageY;
		// 移動量取得
		let moveX = this.endDragX - this.startDragX;
		let moveY = this.endDragY - this.startDragY;

		switch(1){
			case 0:	// 領域サイズ変更のみ
				this.renderFunc.enqueue(this.renderMouseMoveScale.bind(this, this.scaleStartWidth + moveX, this.scaleStartHeight + moveY));
				break;
			case 1:	// 縦倍率に合わせfont sizeも変更
				{
					let orgwidth = parseInt(this.clingingPartner.dataset.orgwidth);
					let orgheight = parseInt(this.clingingPartner.dataset.orgheight);
					let scaleY = (this.scaleStartHeight + moveY) / orgheight * 100;	// ★さらに初期倍率設定値を掛ける必要がある
					this.renderFunc.enqueue(this.renderMouseMoveScale.bind(this, this.scaleStartWidth + moveX, this.scaleStartHeight + moveY, scaleX, scaleY));
				}
				break;
		}
	}
	renderMouseMoveScale(width, height, scalefont) {
		this.clingingPartner.style.opacity = 0.4;

		switch(1){
			case 0:
				this.clingingPartner.style.width = width + "px";
				this.clingingPartner.style.height = height + "px";
				break;
			case 1:
				this.clingingPartner.style.width = width + "px";
				this.clingingPartner.style.height = height + "px";
				this.clingingPartner.style.fontSize = scalefont + '%';
				break;
		}
	}
	mouseUpScale(evt) {
		this.debuglog('mouseUpScale');
		// Mouse event callback設定をクリア
		window.displayField.setMouseEventObj(null, null);

		// 画像の仮変形
		this.endDragX = evt.pageX;
		this.endDragY = evt.pageY;
		// 移動量取得
		let moveX = this.endDragX - this.startDragX;
		let moveY = this.endDragY - this.startDragY;

		let rectFrom = new rectData();
		let rectTo = new rectData();
		rectFrom.setLTWH(parseInt(this.clingingPartner.style.left), parseInt(this.clingingPartner.style.top), this.scaleStartWidth, this.scaleStartHeight);
		rectTo.setLTWH(rectFrom.left, rectFrom.top, this.scaleStartWidth + moveX, this.scaleStartHeight + moveY);

		// Scale Command発行
		let cmd = new CCommandObj();
		cmd.createCommand(cmdType.request, cmdAddress.Focus, cmdAddress.ObjIDMgr, cmdCmd.scalebox, this.clingingPartner.dataset.objid, rectFrom, rectTo, 5);
		this.debuglog("postToWorker");
		window.postToWorker.post(cmd);
	}

	onMouseDownRoll(evt) {
		this.debuglog('onMouseDownRoll');

		// Mouse eventをDisplayFieldからRollerに渡してもらうように設定
		window.displayField.setMouseEventObj(this.mouseMoveRoll.bind(this), this.mouseUpRoll.bind(this));
	}
	mouseMoveRoll(evt) {
		let x1 = parseInt(this.clingingPartner.style.left) + parseInt(this.clingingPartner.style.width) / 2;
		let y1 = parseInt(this.clingingPartner.style.top)  + parseInt(this.clingingPartner.style.height) / 2;
		let x2 = evt.pageX;
		let y2 = evt.pageY;
		let degree = angle(x2, y2, x1, y1);

		this.renderFunc.enqueue(this.renderMouseMoveRoll.bind(this, degree));
	}
	renderMouseMoveRoll(degree) {
		this.clingingPartner.style.transform = 'rotateZ(' + degree + 'deg);';
	}
	mouseUpRoll(evt) {
		this.debuglog('mouseUpRoll');
		// Mouse event callback設定をクリア
		window.displayField.setMouseEventObj(null, null);

		let x1 = parseInt(this.clingingPartner.style.left) + parseInt(this.clingingPartner.style.width) / 2;
		let y1 = parseInt(this.clingingPartner.style.top)  + parseInt(this.clingingPartner.style.height) / 2;
		let x2 = evt.pageX;
		let y2 = evt.pageY;
		let degree = angle(x2, y2, x1, y1);
		//		this.debuglog('■■ x1=' + x1 + ', y1=' + y1 + ',\nx2=' + x2 + ', y2=' + y2 + '\nangle=' + degree);
		//		window.ObjIDMgr.rollbox( this.clingingPartner.dataset.objid, degree );	// debug用 設定情報で直接表示

		// Rotate command発行
		let cmd = new CCommandObj();
		cmd.createCommand(cmdType.request, cmdAddress.Focus, cmdAddress.ObjIDMgr, cmdCmd.rollbox, this.clingingPartner.dataset.objid, degree, null, 6);
		this.debuglog("postToWorker");
		window.postToWorker.post(cmd);
	}

}	// class CPartsFocus
